/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.algorithm.AbstractChecksum;
import jonelo.jacksum.algorithm.MD;
import jonelo.jacksum.algorithm.MDgnu;
import jonelo.sugar.util.GeneralProgram;
import org.apache.commons.logging.LogFactory;

public final class HashUtility {
    private static final String TRANS_ENC = "hex";

    private HashUtility() {
    }

    public static String calculateHash(String delim, String ... strings) {
        StringBuilder hashMe = new StringBuilder(512);
        int len = strings.length;
        if (len > 0) {
            hashMe.append(strings[0]);
            if (null != delim) {
                for (int i = 1; i < len; ++i) {
                    hashMe.append(delim).append(strings[i]);
                }
            }
        }
        return HashUtility.getSha256(hashMe.toString(), TRANS_ENC);
    }

    public static String getSha256(String string, String encoding) {
        try {
            MD checksum = GeneralProgram.isSupportFor((String)"1.4.2") ? new MD("SHA-256") : new MDgnu("sha-256");
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes("UTF-8"));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            LogFactory.getLog(HashUtility.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LogFactory.getLog(HashUtility.class).error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String getHash(String string, String algorithm, String encoding) {
        try {
            AbstractChecksum checksum = JacksumAPI.getChecksumInstance((String)algorithm);
            checksum.setEncoding(encoding);
            checksum.update(string.getBytes("UTF-8"));
            return checksum.getFormattedValue();
        }
        catch (NoSuchAlgorithmException e) {
            LogFactory.getLog(HashUtility.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LogFactory.getLog(HashUtility.class).error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

