/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.damienmiller.BCrypt;
import com.openexchange.passwordchange.mechs.SHACrypt;
import com.openexchange.passwordchange.mechs.UnixCrypt;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class PasswordMechanism {
    public static final String MECH_CRYPT = "{CRYPT}".intern();
    public static final String MECH_SHA = "{SHA}".intern();
    public static final String MECH_BCRYPT = "{BCRYPT}".intern();

    public static final String getEncodedPassword(String mech, String newPassword) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (MECH_CRYPT.equals(mech)) {
            return UnixCrypt.crypt(newPassword);
        }
        if (MECH_SHA.equals(mech)) {
            return SHACrypt.makeSHAPasswd(newPassword);
        }
        if (MECH_BCRYPT.equals(mech)) {
            return BCrypt.hashpw((String)newPassword, (String)BCrypt.gensalt());
        }
        return null;
    }
}

