/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.writer;

import com.openexchange.exception.OXException;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.jslob.storage.JSlobStorage;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.fields.MailAccountGetSwitch;
import com.openexchange.session.Session;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MailAccountWriter
implements MailAccountFields {
    private static final EnumSet<Attribute> FULL_NAMES = EnumSet.of(Attribute.TRASH_FULLNAME_LITERAL, new Attribute[]{Attribute.SENT_FULLNAME_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL});

    private MailAccountWriter() {
    }

    public static JSONObject write(MailAccount account) throws JSONException {
        String replyTo;
        JSONObject json = new JSONObject(48);
        int accountId = account.getId();
        json.put("id", accountId);
        json.put("login", (Object)account.getLogin());
        json.put("mail_port", account.getMailPort());
        json.put("mail_protocol", (Object)account.getMailProtocol());
        json.put("mail_secure", account.isMailSecure());
        json.put("mail_server", (Object)account.getMailServer());
        json.put("mail_url", (Object)account.generateMailServerURL());
        json.put("transport_port", account.getTransportPort());
        json.put("transport_protocol", (Object)account.getTransportProtocol());
        json.put("transport_secure", account.isTransportSecure());
        json.put("transport_server", (Object)account.getTransportServer());
        json.put("transport_url", (Object)account.generateTransportServerURL());
        json.put("transport_login", (Object)account.getTransportLogin());
        json.put("name", (Object)account.getName());
        json.put("primary_address", (Object)account.getPrimaryAddress());
        json.put("personal", (Object)account.getPersonal());
        json.put("spam_handler", (Object)account.getSpamHandler());
        json.put("trash", (Object)account.getTrash());
        json.put("sent", (Object)account.getSent());
        json.put("drafts", (Object)account.getDrafts());
        json.put("spam", (Object)account.getSpam());
        json.put("confirmed_spam", (Object)account.getConfirmedSpam());
        json.put("confirmed_ham", (Object)account.getConfirmedHam());
        json.put("trash_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getTrashFullname()));
        json.put("sent_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSentFullname()));
        json.put("drafts_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getDraftsFullname()));
        json.put("spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getSpamFullname()));
        json.put("confirmed_spam_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedSpamFullname()));
        json.put("confirmed_ham_fullname", (Object)MailFolderUtility.prepareFullname(accountId, account.getConfirmedHamFullname()));
        json.put("unified_inbox_enabled", account.isUnifiedINBOXEnabled());
        Map<String, String> props = account.getProperties();
        if (props.containsKey("pop3.deletewt")) {
            json.put("pop3_delete_write_through", Boolean.parseBoolean(props.get("pop3.deletewt")));
        }
        if (props.containsKey("pop3.expunge")) {
            json.put("pop3_expunge_on_quit", Boolean.parseBoolean(props.get("pop3.expunge")));
        }
        if (props.containsKey("pop3.refreshrate")) {
            json.put("pop3_refresh_rate", (Object)props.get("pop3.refreshrate"));
        }
        if (props.containsKey("pop3.storage")) {
            json.put("pop3_storage", (Object)props.get("pop3.storage"));
        }
        if (props.containsKey("pop3.path")) {
            json.put("pop3_path", (Object)props.get("pop3.path"));
        }
        if (null == (replyTo = account.getReplyTo())) {
            if (props.containsKey("replyto")) {
                json.put("reply_to", (Object)props.get("replyto"));
            }
        } else {
            json.put("reply_to", (Object)replyTo);
        }
        if (props.containsKey("addresses")) {
            json.put("addresses", (Object)props.get("addresses"));
        }
        return json;
    }

    public static JSONArray writeArray(MailAccount[] mailAccounts, List<Attribute> attributes, Session session) throws OXException {
        JSONArray rows = new JSONArray(mailAccounts.length);
        JSlobStorage jSlobStorage = AbstractMailAccountAction.getStorage();
        for (MailAccount account : mailAccounts) {
            MailAccountGetSwitch getter = new MailAccountGetSwitch(account);
            JSONArray row = new JSONArray(64);
            for (Attribute attribute : attributes) {
                Object value;
                if (Attribute.PASSWORD_LITERAL == attribute || Attribute.TRANSPORT_PASSWORD_LITERAL == attribute) {
                    row.put(JSONObject.NULL);
                    continue;
                }
                if (Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL == attribute || Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL == attribute) {
                    row.put(Boolean.parseBoolean(String.valueOf(attribute.doSwitch(getter))));
                    continue;
                }
                if (FULL_NAMES.contains((Object)attribute)) {
                    value = attribute.doSwitch(getter);
                    if (null == value) {
                        row.put(JSONObject.NULL);
                        continue;
                    }
                    row.put((Object)MailFolderUtility.prepareFullname(account.getId(), value.toString()));
                    continue;
                }
                if (Attribute.META == attribute) {
                    JSlobId jSlobId = new JSlobId("com.openexchange.mailaccount", Integer.toString(account.getId()), session.getUserId(), session.getContextId());
                    JSlob jSlob = jSlobStorage.opt(jSlobId);
                    if (null != jSlob) {
                        row.put((Object)jSlob.getJsonObject());
                        continue;
                    }
                    row.put(JSONObject.NULL);
                    continue;
                }
                value = attribute.doSwitch(getter);
                row.put(value == null ? JSONObject.NULL : value);
            }
            rows.put((Object)row);
        }
        return rows;
    }
}

