/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountTreeAction;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.net.URITools;
import com.openexchange.tools.session.ServerSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="validate", description="Validate a mail account (which shall be created)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="tree", optional=true, description="An optional boolean parameter which indicates whether on successful validation the folder tree shall be returned (NULL on failure) or if set to \"false\" or missing only a boolean is returned which indicates validation result.")}, requestBody="A JSON object describing the new account to validate. See mail account data.", responseDescription="Dependent on optional \"tree\" parameter a JSON folder object or a boolean value indicating the validation result.")
public final class ValidateAction
extends AbstractMailAccountTreeAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ValidateAction.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String ACTION = "validate";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        if (!session.getUserConfiguration().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        MailAccountParser.getInstance().parse(accountDescription, jData.toObject());
        if (accountDescription.getId() >= 0 && null == accountDescription.getPassword()) {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            String password = storageService.getMailAccount(accountDescription.getId(), session.getUserId(), session.getContextId()).getPassword();
            accountDescription.setPassword(MailPasswordUtil.decrypt(password, session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer()));
        }
        ValidateAction.checkNeededFields(accountDescription);
        if (ValidateAction.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.VALIDATION_FAILED.create();
        }
        String tmp = requestData.getParameter("tree");
        boolean tree = Boolean.parseBoolean(tmp);
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        if (tree) {
            return new AJAXRequestResult(ValidateAction.actionValidateTree(accountDescription, session, warnings)).addWarnings(warnings);
        }
        return new AJAXRequestResult(ValidateAction.actionValidateBoolean(accountDescription, session, warnings)).addWarnings(warnings);
    }

    private static Object actionValidateTree(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings) throws JSONException, OXException {
        if (!ValidateAction.actionValidateBoolean(accountDescription, session, warnings).booleanValue()) {
            return null;
        }
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = ValidateAction.getMailAccess(accountDescription, session, warnings);
        if (null == mailAccess) {
            return JSONObject.NULL;
        }
        return ValidateAction.actionValidateTree0(mailAccess, session);
    }

    public static Boolean actionValidateBoolean(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings) throws OXException {
        boolean validated = ValidateAction.checkMailServerURL(accountDescription, session, warnings);
        if (!validated) {
            return Boolean.FALSE;
        }
        if (!ValidateAction.isEmpty(accountDescription.getTransportServer())) {
            validated = ValidateAction.checkTransportServerURL(accountDescription, session, warnings);
        }
        return validated;
    }

    static boolean checkMailServerURL(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
        int accountId = accountDescription.getId();
        if (accountId > 0) {
            String password = accountDescription.getPassword();
            String login = accountDescription.getLogin();
            if (ValidateAction.isEmpty(password) || ValidateAction.isEmpty(login)) {
                MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                MailAccount mailAccount = storageService.getMailAccount(accountId, session.getUserId(), session.getContextId());
                if (ValidateAction.isEmpty(password)) {
                    accountDescription.setPassword(mailAccount.getPassword());
                }
                if (ValidateAction.isEmpty(login)) {
                    accountDescription.setLogin(mailAccount.getLogin());
                }
            }
        }
        if (null == (mailAccess = ValidateAction.getMailAccess(accountDescription, session, warnings))) {
            return false;
        }
        boolean success = mailAccess.ping();
        if (success) {
            warnings.addAll(mailAccess.getWarnings());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkTransportServerURL(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings) throws OXException {
        URI uri;
        if (ValidateAction.isEmpty(accountDescription.getTransportServer())) {
            return true;
        }
        String transportServerURL = accountDescription.generateTransportServerURL();
        TransportProvider transportProvider = TransportProviderRegistry.getTransportProviderByURL(transportServerURL);
        if (null == transportProvider) {
            if (DEBUG) {
                LOG.debug((Object)("Validating mail account failed. No transport provider found for URL: " + transportServerURL));
            }
            return false;
        }
        MailTransport mailTransport = transportProvider.createNewMailTransport(session);
        TransportConfig transportConfig = mailTransport.getTransportConfig();
        String login = accountDescription.getTransportLogin();
        if (null == login) {
            login = accountDescription.getLogin();
        }
        transportConfig.setLogin(login);
        String password = accountDescription.getTransportPassword();
        if (null == password) {
            password = accountDescription.getPassword();
        }
        transportConfig.setPassword(password);
        try {
            uri = URIParser.parse(transportServerURL, URIDefaults.SMTP);
        }
        catch (URISyntaxException e) {
            throw MailExceptionCode.URI_PARSE_FAILED.create(e, transportServerURL);
        }
        transportConfig.setServer(URITools.getHost(uri));
        transportConfig.setPort(uri.getPort());
        transportConfig.setSecure(accountDescription.isTransportSecure());
        boolean validated = true;
        boolean close = false;
        try {
            mailTransport.ping();
            close = true;
        }
        catch (OXException e) {
            Throwable cause;
            if (DEBUG) {
                LOG.debug((Object)"Validating transport account failed.", (Throwable)e);
            }
            for (cause = e.getCause(); null != cause && cause instanceof OXException; cause = cause.getCause()) {
            }
            if (null != cause) {
                warnings.add(MailAccountExceptionCodes.VALIDATE_FAILED_TRANSPORT.create(cause, transportConfig.getServer(), transportConfig.getLogin()));
            } else {
                e.setCategory(Category.CATEGORY_WARNING);
                warnings.add(e);
            }
            validated = false;
        }
        finally {
            if (close) {
                mailTransport.close();
            }
        }
        return validated;
    }
}

