/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;

public class DumperMessageHandler
implements MailMessageHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DumperMessageHandler.class));
    private final boolean bodyOnly;
    private final StringBuilder strBuilder = new StringBuilder(32768);

    public DumperMessageHandler(boolean bodyOnly) {
        this.bodyOnly = bodyOnly;
    }

    public String getString() {
        return this.strBuilder.toString();
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleAttachment:\n");
        this.strBuilder.append("isInline=").append(isInline).append('\n');
        this.strBuilder.append("ContentType=").append(baseContentType).append('\n');
        this.strBuilder.append("fileName=").append(fileName).append('\n');
        this.strBuilder.append("sequenceId=").append(id).append('\n');
        try {
            this.strBuilder.append("Content:\n").append(MessageUtility.readMailPart(part, "US-ASCII"));
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleBccRecipient:\n");
        this.strBuilder.append("Bcc=").append(Arrays.toString(recipientAddrs)).append('\n');
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleCcRecipient:\n");
        this.strBuilder.append("Cc=").append(Arrays.toString(recipientAddrs)).append('\n');
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleColorLabel:\n");
        this.strBuilder.append("ColorLabel=").append(colorLabel).append('\n');
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleContentId:\n");
        this.strBuilder.append("Content-ID=").append(contentId).append('\n');
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleFrom:\n");
        this.strBuilder.append("From=").append(Arrays.toString(fromAddrs)).append('\n');
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleHeaders:\n");
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, String> e = iter.next();
            this.strBuilder.append(e.getKey()).append('=').append(e.getValue()).append('\n');
        }
        return true;
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleImagePart:\n");
        this.strBuilder.append("ContentType=").append(baseContentType).append('\n');
        this.strBuilder.append("Content-ID=").append(imageCID).append('\n');
        this.strBuilder.append("isInline=").append(isInline).append('\n');
        this.strBuilder.append("fileName=").append(fileName).append('\n');
        this.strBuilder.append("sequenceId=").append(id).append('\n');
        try {
            this.strBuilder.append("Content:\n").append(MessageUtility.readStream(part.getInputStream(), "US-ASCII"));
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        this.strBuilder.append('\n').append("handleInlineHtml:\n");
        this.strBuilder.append("ContentType=").append(contentType).append('\n');
        this.strBuilder.append("Size=").append(size).append('\n');
        this.strBuilder.append("Filename=").append(fileName).append('\n');
        this.strBuilder.append("sequenceId=").append(id).append('\n');
        this.strBuilder.append("Content:\n").append(htmlContent);
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        this.strBuilder.append('\n').append("handleInlinePlainText:\n");
        this.strBuilder.append("ContentType=").append(contentType).append('\n');
        this.strBuilder.append("Size=").append(size).append('\n');
        this.strBuilder.append("Filename=").append(fileName).append('\n');
        this.strBuilder.append("sequenceId=").append(id).append('\n');
        this.strBuilder.append("Content:\n").append(plainTextContent);
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public void handleMessageEnd(MailMessage msg) throws OXException {
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        MailMessage nestedMail;
        Object content = mailPart.getContent();
        if (content instanceof MailMessage) {
            nestedMail = (MailMessage)content;
        } else if (content instanceof InputStream) {
            try {
                nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
        } else {
            LOG.error((Object)("Ignoring nested message. Cannot handle part's content which should be a RFC822 message according to its content type: " + (null == content ? "null" : content.getClass().getSimpleName())));
            return true;
        }
        DumperMessageHandler handler = new DumperMessageHandler(this.bodyOnly);
        new MailMessageParser().parseMailMessage(nestedMail, handler, id);
        this.strBuilder.append(handler.getString());
        return true;
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handlePriority:\n");
        this.strBuilder.append("Priority=").append(priority).append('\n');
        return true;
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleMsgRef:\n");
        this.strBuilder.append("MsgRef=").append(msgRef).append('\n');
        return true;
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleDispositionNotification:\n");
        this.strBuilder.append("DispositionNotificationTo=").append(dispositionNotificationTo.toUnicodeString()).append('\n');
        return true;
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleReceivedDate:\n");
        this.strBuilder.append("ReceivedDate=").append(receivedDate).append('\n');
        return true;
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleSentDate:\n");
        this.strBuilder.append("SentDate=").append(sentDate).append('\n');
        return true;
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleSpecialPart:\n");
        this.strBuilder.append("ContentType=").append(baseContentType).append('\n');
        this.strBuilder.append("filename=").append(fileName).append('\n');
        this.strBuilder.append("sequenceId=").append(id).append('\n');
        try {
            this.strBuilder.append("Content:\n").append(MessageUtility.readStream(part.getInputStream(), "US-ASCII"));
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        this.strBuilder.append('\n').append("handleSubject:\n");
        this.strBuilder.append("Subject=").append(subject).append('\n');
        return true;
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleSystemFlags:\n");
        this.strBuilder.append("Flags=").append(flags).append('\n');
        return true;
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleToRecipient:\n");
        this.strBuilder.append("To=").append(Arrays.toString(recipientAddrs)).append('\n');
        return true;
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        if (this.bodyOnly) {
            return true;
        }
        this.strBuilder.append('\n').append("handleUserFlags:\n");
        this.strBuilder.append("UserFlags=").append(Arrays.toString(userFlags)).append('\n');
        return true;
    }
}

