/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.MailProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class MailProviderProxyGenerator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailProviderProxyGenerator.class));

    public static MailProvider newMailProviderProxy(ServiceReference mailProviderServiceReference, BundleContext context) {
        try {
            return (MailProvider)Proxy.newProxyInstance(MailProvider.class.getClassLoader(), new Class[]{MailProvider.class}, (InvocationHandler)new MailProviderInvocationHandler(mailProviderServiceReference, context));
        }
        catch (ClassCastException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private MailProviderProxyGenerator() {
    }

    private static final class MailProviderInvocationHandler
    implements InvocationHandler {
        private final BundleContext context;
        private final ServiceReference mailProviderServiceReference;

        private MailProviderInvocationHandler(ServiceReference mailProviderServiceReference, BundleContext context) {
            this.mailProviderServiceReference = mailProviderServiceReference;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                MailProvider provider = (MailProvider)this.context.getService(this.mailProviderServiceReference);
                try {
                    result = method.invoke((Object)provider, args);
                }
                finally {
                    this.context.ungetService(this.mailProviderServiceReference);
                }
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage(), e);
            }
            return result;
        }
    }
}

