/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="update", description="Update/move mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="message_id", description="(Preliminary) The value of \"Message-Id\" header of the requested mail. This parameter is a substitute for \"id\" parameter."), @Parameter(name="folder", description="Object ID of the folder.")}, requestBody="A JSON object which carries the new values that ought to be applied to mail as described in Update mail or Update mail extended (available with SP6 v6.10).", responseDescription="A JSON object containing the Object ID of the updated mail and its folder.")
public final class UpdateAction
extends AbstractMailAction {
    public UpdateAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            String sourceFolder = req.checkParameter("folder");
            JSONObject bodyObj = (JSONObject)req.getRequest().getData();
            String destFolder = bodyObj.hasAndNotNull("folder_id") ? bodyObj.getString("folder_id") : null;
            Integer colorLabel = bodyObj.hasAndNotNull("color_label") ? Integer.valueOf(bodyObj.getInt("color_label")) : null;
            Integer flagBits = bodyObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) ? Integer.valueOf(bodyObj.getInt(MailJSONField.FLAGS.getKey())) : null;
            boolean flagVal = false;
            if (flagBits != null) {
                flagVal = bodyObj.has(MailJSONField.VALUE.getKey()) && !bodyObj.isNull(MailJSONField.VALUE.getKey()) ? bodyObj.getBoolean(MailJSONField.VALUE.getKey()) : false;
            }
            Integer setFlags = bodyObj.hasAndNotNull("set_flags") ? Integer.valueOf(bodyObj.getInt("set_flags")) : null;
            Integer clearFlags = bodyObj.hasAndNotNull("clear_flags") ? Integer.valueOf(bodyObj.getInt("clear_flags")) : null;
            MailServletInterface mailInterface = this.getMailInterface(req);
            OXJSONWriter jsonWriter = new OXJSONWriter();
            jsonWriter.object();
            String tmp = req.getParameter("id");
            Object uid = null == tmp ? (null == (tmp = req.getParameter("message_id")) ? null : mailInterface.getMailIDByMessageID(sourceFolder, tmp)) : tmp;
            String folderId = sourceFolder;
            String mailId = uid;
            if (colorLabel != null) {
                String[] stringArray;
                if (uid == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = uid;
                }
                mailInterface.updateMessageColorLabel(sourceFolder, stringArray, colorLabel);
            }
            if (flagBits != null) {
                String[] stringArray;
                if (uid == null) {
                    stringArray = null;
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = uid;
                }
                mailInterface.updateMessageFlags(sourceFolder, stringArray, flagBits, flagVal);
            }
            if (setFlags != null) {
                String[] stringArray;
                if (uid == null) {
                    stringArray = null;
                } else {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = uid;
                }
                mailInterface.updateMessageFlags(sourceFolder, stringArray, setFlags, true);
            }
            if (clearFlags != null) {
                String[] stringArray;
                if (uid == null) {
                    stringArray = null;
                } else {
                    String[] stringArray5 = new String[1];
                    stringArray = stringArray5;
                    stringArray5[0] = uid;
                }
                mailInterface.updateMessageFlags(sourceFolder, stringArray, clearFlags, false);
            }
            if (destFolder != null) {
                mailId = mailInterface.copyMessages(sourceFolder, destFolder, new String[]{uid}, true)[0];
                folderId = destFolder;
            }
            jsonWriter.key("folder_id").value((Object)folderId);
            jsonWriter.key("id").value((Object)mailId);
            jsonWriter.endObject();
            return new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

