/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.mail.permission.MailPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MailFolderDescription {
    private static final MailPermission[] EMPTY_PERMS = new MailPermission[0];
    private boolean b_exists;
    private boolean b_fullname;
    private boolean b_name;
    private boolean b_parentFullname;
    private boolean b_permissions;
    private boolean b_separator;
    private boolean b_subscribed;
    private boolean exists;
    private String fullname;
    private int accountId = 0;
    private String name;
    private String parentFullname;
    private int parentAccountId = 0;
    private List<MailPermission> permissions;
    private char separator;
    private boolean subscribed;

    public void addPermission(MailPermission permission) {
        if (null == permission) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>();
            this.b_permissions = true;
        }
        this.permissions.add(permission);
    }

    public void addPermissions(MailPermission[] permissions) {
        if (null == permissions || permissions.length == 0) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>(permissions.length);
            this.b_permissions = true;
        }
        this.permissions.addAll(Arrays.asList(permissions));
    }

    public void addPermissions(Collection<? extends MailPermission> permissions) {
        if (null == permissions || permissions.isEmpty()) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>(permissions.size());
            this.b_permissions = true;
        }
        this.permissions.addAll(permissions);
    }

    public boolean containsExists() {
        return this.b_exists;
    }

    public boolean containsFullname() {
        return this.b_fullname;
    }

    public boolean containsName() {
        return this.b_name;
    }

    public boolean containsParentFullname() {
        return this.b_parentFullname;
    }

    public boolean containsPermissions() {
        return this.b_permissions;
    }

    public boolean containsSeparator() {
        return this.b_separator;
    }

    public boolean containsSubscribed() {
        return this.b_subscribed;
    }

    public boolean exists() {
        return this.exists;
    }

    public String getFullname() {
        return this.fullname;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getParentFullname() {
        return this.parentFullname;
    }

    public int getParentAccountId() {
        return this.parentAccountId;
    }

    public MailPermission[] getPermissions() {
        if (null == this.permissions) {
            return EMPTY_PERMS;
        }
        return this.permissions.toArray(new MailPermission[this.permissions.size()]);
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void removeExists() {
        this.exists = false;
        this.b_exists = false;
    }

    public void removeFullname() {
        this.fullname = null;
        this.b_fullname = false;
    }

    public void removeName() {
        this.name = null;
        this.b_name = false;
    }

    public void removeParentFullname() {
        this.parentFullname = null;
        this.b_parentFullname = false;
    }

    public void removePermissions() {
        this.permissions = null;
        this.b_permissions = false;
    }

    public void removeSeparator() {
        this.separator = '\u0000';
        this.b_separator = false;
    }

    public void removeSubscribed() {
        this.subscribed = false;
        this.b_subscribed = false;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
        this.b_exists = true;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
        this.b_fullname = true;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public void setName(String name) {
        this.name = name;
        this.b_name = true;
    }

    public void setParentFullname(String parentFullname) {
        this.parentFullname = parentFullname;
        this.b_parentFullname = true;
    }

    public void setParentAccountId(int parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
        this.b_separator = true;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
        this.b_subscribed = true;
    }
}

