/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.mail.permission.MailPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MailFolder
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8203697938992090309L;
    private DefaultFolderType defaulFolderType = DefaultFolderType.NONE;
    private boolean b_defaulFolderType;
    private String name;
    private boolean b_name;
    private String fullname;
    private boolean b_fullname;
    private String parentFullname;
    private boolean b_parentFullname;
    private boolean subscribed;
    private boolean b_subscribed;
    private boolean hasSubfolders;
    private boolean b_hasSubfolders;
    private boolean hasSubscribedSubfolders;
    private boolean b_hasSubscribedSubfolders;
    private boolean exists;
    private boolean b_exists;
    private boolean holdsMessages;
    private boolean b_holdsMessages;
    private boolean holdsFolders;
    private boolean b_holdsFolders;
    private int messageCount;
    private boolean b_messageCount;
    private int newMessageCount;
    private boolean b_newMessageCount;
    private int unreadMessageCount;
    private boolean b_unreadMessageCount;
    private int deletedMessageCount;
    private boolean b_deletedMessageCount;
    private char separator;
    private boolean b_separator;
    private MailPermission ownPermission;
    private boolean b_ownPermission;
    private boolean supportsUserFlags;
    private boolean b_supportsUserFlags;
    private boolean rootFolder;
    private boolean b_rootFolder;
    private boolean defaultFolder;
    private boolean b_defaultFolder;
    private List<MailPermission> permissions;
    private boolean b_permissions;
    private boolean shared;
    private boolean b_shared;
    private String owner;
    private boolean b_owner;
    private boolean isPublic;
    private boolean b_public;
    private final ConcurrentMap<String, Object> properties = new ConcurrentHashMap<String, Object>(4);
    public static final String DEFAULT_FOLDER_NAME = "E-Mail";
    public static final String DEFAULT_FOLDER_ID = "default";
    private static final MailPermission[] EMPTY_PERMS = new MailPermission[0];

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (null == value) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public Object setPropertyIfAbsent(String name, Object value) {
        return this.properties.putIfAbsent(name, value);
    }

    public Object clone() {
        try {
            List<MailPermission> thisPerms;
            MailFolder clone = (MailFolder)super.clone();
            MailPermission thisOwnPerm = this.ownPermission;
            if (thisOwnPerm != null) {
                clone.ownPermission = (MailPermission)thisOwnPerm.clone();
            }
            if ((thisPerms = this.permissions) != null) {
                ArrayList<MailPermission> l = new ArrayList<MailPermission>(thisPerms.size());
                for (MailPermission mailPermission : thisPerms) {
                    l.add((MailPermission)mailPermission.clone());
                }
                clone.permissions = l;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Clone failed although Cloneable is implemented.");
        }
    }

    public String getFullname() {
        return this.fullname;
    }

    public boolean containsFullname() {
        return this.b_fullname;
    }

    public void removeFullname() {
        this.fullname = null;
        this.b_fullname = false;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
        this.b_fullname = true;
    }

    public boolean hasSubfolders() {
        return this.hasSubfolders;
    }

    public boolean containsSubfolders() {
        return this.b_hasSubfolders;
    }

    public void removeSubfolders() {
        this.hasSubfolders = false;
        this.b_hasSubfolders = false;
    }

    public void setSubfolders(boolean hasSubfolders) {
        this.hasSubfolders = hasSubfolders;
        this.b_hasSubfolders = true;
    }

    public boolean hasSubscribedSubfolders() {
        return this.hasSubscribedSubfolders;
    }

    public boolean containsSubscribedSubfolders() {
        return this.b_hasSubscribedSubfolders;
    }

    public void removeSubscribedSubfolders() {
        this.hasSubscribedSubfolders = false;
        this.b_hasSubscribedSubfolders = false;
    }

    public void setSubscribedSubfolders(boolean hasSubscribedSubfolders) {
        this.hasSubscribedSubfolders = hasSubscribedSubfolders;
        this.b_hasSubscribedSubfolders = true;
    }

    public DefaultFolderType getDefaultFolderType() {
        return this.defaulFolderType;
    }

    public boolean isInbox() {
        return DefaultFolderType.INBOX.equals((Object)this.defaulFolderType);
    }

    public boolean isDrafts() {
        return DefaultFolderType.DRAFTS.equals((Object)this.defaulFolderType);
    }

    public boolean isSent() {
        return DefaultFolderType.SENT.equals((Object)this.defaulFolderType);
    }

    public boolean isSpam() {
        return DefaultFolderType.SPAM.equals((Object)this.defaulFolderType);
    }

    public boolean isTrash() {
        return DefaultFolderType.TRASH.equals((Object)this.defaulFolderType);
    }

    public boolean isConfirmedSpam() {
        return DefaultFolderType.CONFIRMED_SPAM.equals((Object)this.defaulFolderType);
    }

    public boolean isConfirmedHam() {
        return DefaultFolderType.CONFIRMED_HAM.equals((Object)this.defaulFolderType);
    }

    public boolean containsDefaultFolderType() {
        return this.b_defaulFolderType;
    }

    public void removeDefaultFolderType() {
        this.defaulFolderType = DefaultFolderType.NONE;
        this.b_defaulFolderType = false;
    }

    public void setDefaultFolderType(DefaultFolderType defaulFolderType) {
        this.defaulFolderType = defaulFolderType;
        this.b_defaulFolderType = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsName() {
        return this.b_name;
    }

    public void removeName() {
        this.name = null;
        this.b_name = false;
    }

    public void setName(String name) {
        this.name = name;
        this.b_name = true;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public boolean containsSubscribed() {
        return this.b_subscribed;
    }

    public void removeSubscribed() {
        this.subscribed = false;
        this.b_subscribed = false;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
        this.b_subscribed = true;
    }

    public int getDeletedMessageCount() {
        return this.deletedMessageCount;
    }

    public boolean containsDeletedMessageCount() {
        return this.b_deletedMessageCount;
    }

    public void removeDeletedMessageCount() {
        this.deletedMessageCount = 0;
        this.b_deletedMessageCount = false;
    }

    public void setDeletedMessageCount(int deletedMessageCount) {
        this.deletedMessageCount = deletedMessageCount;
        this.b_deletedMessageCount = true;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean containsExists() {
        return this.b_exists;
    }

    public void removeExists() {
        this.exists = false;
        this.b_exists = false;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
        this.b_exists = true;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public boolean containsMessageCount() {
        return this.b_messageCount;
    }

    public void removeMessageCount() {
        this.messageCount = 0;
        this.b_messageCount = false;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        this.b_messageCount = true;
    }

    public int getNewMessageCount() {
        return this.newMessageCount;
    }

    public boolean containsNewMessageCount() {
        return this.b_newMessageCount;
    }

    public void removeNewMessageCount() {
        this.newMessageCount = 0;
        this.b_newMessageCount = false;
    }

    public void setNewMessageCount(int newMessageCount) {
        this.newMessageCount = newMessageCount;
        this.b_newMessageCount = true;
    }

    public int getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public boolean containsUnreadMessageCount() {
        return this.b_unreadMessageCount;
    }

    public void removeUnreadMessageCount() {
        this.unreadMessageCount = 0;
        this.b_unreadMessageCount = false;
    }

    public void setUnreadMessageCount(int unreadMessageCount) {
        this.unreadMessageCount = unreadMessageCount;
        this.b_unreadMessageCount = true;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean containsSeparator() {
        return this.b_separator;
    }

    public void removeSeparator() {
        this.separator = (char)48;
        this.b_separator = false;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
        this.b_separator = true;
    }

    public String getParentFullname() {
        return this.parentFullname;
    }

    public boolean containsParentFullname() {
        return this.b_parentFullname;
    }

    public void removeParentFullname() {
        this.parentFullname = null;
        this.b_parentFullname = false;
    }

    public void setParentFullname(String parentFullname) {
        this.parentFullname = parentFullname;
        this.b_parentFullname = true;
    }

    public boolean isHoldsMessages() {
        return this.holdsMessages;
    }

    public boolean containsHoldsMessages() {
        return this.b_holdsMessages;
    }

    public void removeHoldsMessages() {
        this.holdsMessages = false;
        this.b_holdsMessages = false;
    }

    public void setHoldsMessages(boolean holdsMessages) {
        this.holdsMessages = holdsMessages;
        this.b_holdsMessages = true;
    }

    public boolean isHoldsFolders() {
        return this.holdsFolders;
    }

    public boolean containsHoldsFolders() {
        return this.b_holdsFolders;
    }

    public void removeHoldsFolders() {
        this.holdsFolders = false;
        this.b_holdsFolders = false;
    }

    public void setHoldsFolders(boolean holdsFolders) {
        this.holdsFolders = holdsFolders;
        this.b_holdsFolders = true;
    }

    public MailPermission getOwnPermission() {
        return this.ownPermission;
    }

    public boolean containsOwnPermission() {
        return this.b_ownPermission;
    }

    public void removeOwnPermission() {
        this.ownPermission = null;
        this.b_ownPermission = false;
    }

    public void setOwnPermission(MailPermission ownPermission) {
        this.ownPermission = ownPermission;
        this.b_ownPermission = true;
    }

    public boolean isRootFolder() {
        return this.rootFolder;
    }

    public boolean containsRootFolder() {
        return this.b_rootFolder;
    }

    public void removeRootFolder() {
        this.rootFolder = false;
        this.b_rootFolder = false;
    }

    public void setRootFolder(boolean rootFolder) {
        this.rootFolder = rootFolder;
        this.b_rootFolder = true;
    }

    public boolean isDefaultFolder() {
        return this.defaultFolder;
    }

    public boolean containsDefaultFolder() {
        return this.b_defaultFolder;
    }

    public void removeDefaultFolder() {
        this.defaultFolder = false;
        this.b_defaultFolder = false;
    }

    public void setDefaultFolder(boolean defaultFolder) {
        this.defaultFolder = defaultFolder;
        this.b_defaultFolder = true;
    }

    public void addPermission(MailPermission permission) {
        if (null == permission) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>();
            this.b_permissions = true;
        }
        this.permissions.add(permission);
    }

    public void addPermissions(MailPermission[] permissions) {
        if (null == permissions || permissions.length == 0) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>(permissions.length);
            this.b_permissions = true;
        }
        this.permissions.addAll(Arrays.asList(permissions));
    }

    public void addPermissions(Collection<? extends MailPermission> permissions) {
        if (null == permissions || permissions.isEmpty()) {
            return;
        }
        if (null == this.permissions) {
            this.permissions = new ArrayList<MailPermission>(permissions.size());
            this.b_permissions = true;
        }
        this.permissions.addAll(permissions);
    }

    public boolean containsPermissions() {
        return this.b_permissions;
    }

    public void removePermissions() {
        this.permissions = null;
        this.b_permissions = false;
    }

    public MailPermission[] getPermissions() {
        if (null == this.permissions) {
            return EMPTY_PERMS;
        }
        return this.permissions.toArray(new MailPermission[this.permissions.size()]);
    }

    public String toString() {
        return this.containsFullname() ? this.getFullname() : "[no fullname]";
    }

    public boolean isSupportsUserFlags() {
        return this.supportsUserFlags;
    }

    public boolean containsSupportsUserFlags() {
        return this.b_supportsUserFlags;
    }

    public void removeSupportsUserFlags() {
        this.supportsUserFlags = false;
        this.b_supportsUserFlags = false;
    }

    public void setSupportsUserFlags(boolean supportsUserFlags) {
        this.supportsUserFlags = supportsUserFlags;
        this.b_supportsUserFlags = true;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean containsShared() {
        return this.b_shared;
    }

    public void removeShared() {
        this.shared = false;
        this.b_shared = false;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
        this.b_shared = true;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean containsPublic() {
        return this.b_public;
    }

    public void removePublic() {
        this.isPublic = false;
        this.b_public = false;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
        this.b_public = true;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean containsOwner() {
        return this.b_owner;
    }

    public void removeOwne() {
        this.owner = null;
        this.b_owner = false;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.b_owner = true;
    }

    public static enum DefaultFolderType {
        NONE,
        INBOX,
        DRAFTS,
        SENT,
        SPAM,
        TRASH,
        CONFIRMED_SPAM,
        CONFIRMED_HAM;

    }
}

