/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.contact.ContactService;
import com.openexchange.dataretention.DataRetentionService;
import com.openexchange.dataretention.RetentionData;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.MailImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.Quota;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageBatch;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.ISimplifiedThreadStructure;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.processing.MimeForward;
import com.openexchange.mail.mime.utils.MimeStorageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.NonInlineForwardPartHandler;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.HeaderTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchUtility;
import com.openexchange.mail.search.service.SearchTermMapper;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MailMessageComparator;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.SearchStrings;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.user.UserService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

final class MailServletInterfaceImpl
extends MailServletInterface {
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final MailField[] FIELDS_ID_INFO = new MailField[]{MailField.ID, MailField.FOLDER_ID};
    private static final MailField[] HEADERS = new MailField[]{MailField.ID, MailField.HEADERS};
    private static final String LAST_SEND_TIME = "com.openexchange.mail.lastSendTimestamp";
    private static final String[] STR_ARR = new String[0];
    private static final String INBOX_ID = "INBOX";
    private static final int MAX_NUMBER_OF_MESSAGES_2_CACHE = 50;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailServletInterfaceImpl.class));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private final Context ctx;
    private final int contextId;
    private boolean init;
    private MailConfig mailConfig;
    private MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
    private int accountId;
    final Session session;
    private final UserSettingMail usm;
    private Locale locale;
    private User user;
    private final Collection<OXException> warnings = new ArrayList<OXException>(2);
    private final ArrayList<MailImportResult> mailImportResults = new ArrayList();
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final int SPAM_HAM = -1;
    private static final int SPAM_NOOP = 0;
    private static final int SPAM_SPAM = 1;
    private static final MailMessageComparator COMPARATOR = new MailMessageComparator(MailSortField.RECEIVED_DATE, true, null);
    private static final int MAX_FORWARD_COUNT = 8;
    private static final MailListField[] FIELDS_FLAGS = new MailListField[]{MailListField.FLAGS};
    private static final transient Object[] ARGS_FLAG_SEEN_SET = new Object[]{32};
    private static final transient Object[] ARGS_FLAG_SEEN_UNSET = new Object[]{-32};
    private static final String INVALID = "<>";
    private static final MailListField[] FIELDS_COLOR_LABEL = new MailListField[]{MailListField.COLOR_LABEL};
    private static final Map<String, Object> MORE_PROPS_UPDATE_LABEL;
    private static final Map<String, Object> MORE_PROPS_UPDATE_FLAGS;

    MailServletInterfaceImpl(Session session) throws OXException {
        if (session instanceof ServerSession) {
            ServerSession serverSession = (ServerSession)session;
            this.ctx = serverSession.getContext();
            this.usm = serverSession.getUserSettingMail();
            if (!serverSession.getUserConfiguration().hasWebMail()) {
                throw MailExceptionCode.NO_MAIL_ACCESS.create();
            }
            this.user = serverSession.getUser();
        } else {
            this.ctx = ContextStorage.getInstance().getContext(session.getContextId());
            this.usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), this.ctx);
            if (!UserConfigurationStorage.getInstance().getUserConfiguration(session.getUserId(), this.ctx).hasWebMail()) {
                throw MailExceptionCode.NO_MAIL_ACCESS.create();
            }
        }
        this.session = session;
        this.contextId = session.getContextId();
    }

    private User getUser() {
        if (null == this.user) {
            this.user = UserStorage.getStorageUser(this.session.getUserId(), this.session.getContextId());
        }
        return this.user;
    }

    private Locale getUserLocale() {
        if (null == this.locale) {
            UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
            if (null == userService) {
                return Locale.ENGLISH;
            }
            try {
                this.locale = userService.getUser(this.session.getUserId(), this.ctx).getLocale();
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
                return Locale.ENGLISH;
            }
        }
        return this.locale;
    }

    @Override
    public Collection<OXException> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    @Override
    public boolean expungeFolder(String folder, boolean hardDelete) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            ((IMailFolderStorageEnhanced)folderStorage).expungeFolder(fullName, hardDelete);
        } else {
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            MailMessage[] messages = messageStorage.searchMessages(fullName, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new FlagTerm(2, true), FIELDS_ID);
            ArrayList<String> mailIds = new ArrayList<String>(messages.length);
            for (int i = 0; i < messages.length; ++i) {
                MailMessage mailMessage = messages[i];
                if (null == mailMessage) continue;
                mailIds.add(mailMessage.getMailId());
            }
            if (hardDelete) {
                messageStorage.deleteMessages(fullName, mailIds.toArray(new String[0]), true);
            } else {
                String trashFolder = folderStorage.getTrashFolder();
                if (fullName.equals(trashFolder)) {
                    messageStorage.deleteMessages(fullName, mailIds.toArray(new String[0]), true);
                } else {
                    messageStorage.moveMessages(fullName, trashFolder, mailIds.toArray(new String[0]), true);
                }
            }
        }
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (!hardDelete) {
            this.postEvent(accountId, trashFullname, true);
        }
        return true;
    }

    @Override
    public boolean clearFolder(String folder) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        boolean backup = !UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() && !fullName.startsWith(this.mailAccess.getFolderStorage().getTrashFolder());
        this.mailAccess.getFolderStorage().clearFolder(fullName, !backup);
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (backup) {
            this.postEvent(accountId, trashFullname, true);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (fullName.startsWith(trashFullname)) {
            MailFolder[] subf = this.mailAccess.getFolderStorage().getSubfolders(fullName, true);
            for (int i = 0; i < subf.length; ++i) {
                String subFullname = subf[i].getFullname();
                this.mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                this.postEvent(accountId, subFullname, false);
            }
            this.postEvent(accountId, trashFullname, false);
        }
        return true;
    }

    @Override
    public boolean clearFolder(String folder, boolean hardDelete) throws OXException {
        FullnameArgument fullnameArgument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = fullnameArgument.getAccountId();
        this.initConnection(accountId);
        String fullName = fullnameArgument.getFullname();
        boolean backup = hardDelete ? false : !UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() && !fullName.startsWith(this.mailAccess.getFolderStorage().getTrashFolder());
        this.mailAccess.getFolderStorage().clearFolder(fullName, !backup);
        this.postEvent(accountId, fullName, true);
        String trashFullname = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)).getFullname();
        if (backup) {
            this.postEvent(accountId, trashFullname, true);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (fullName.startsWith(trashFullname)) {
            MailFolder[] subf = this.mailAccess.getFolderStorage().getSubfolders(fullName, true);
            for (int i = 0; i < subf.length; ++i) {
                String subFullname = subf[i].getFullname();
                this.mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                this.postEvent(accountId, subFullname, false);
            }
            this.postEvent(accountId, trashFullname, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean putIntoCache) throws OXException {
        try {
            if (this.mailAccess != null) {
                this.mailAccess.close(putIntoCache);
            }
        }
        finally {
            this.mailAccess = null;
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] copyMessages(String sourceFolder, String destFolder, String[] msgUIDs, boolean move) throws OXException {
        FullnameArgument source = MailFolderUtility.prepareMailFolderParam(sourceFolder);
        FullnameArgument dest = MailFolderUtility.prepareMailFolderParam(destFolder);
        String sourceFullname = source.getFullname();
        String destFullname = dest.getFullname();
        int sourceAccountId = source.getAccountId();
        this.initConnection(sourceAccountId);
        int destAccountId = dest.getAccountId();
        if (sourceAccountId == destAccountId) {
            String[] maildIds;
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            MailMessage[] flagInfo = null;
            if (move) {
                String spamFullname = this.mailAccess.getFolderStorage().getSpamFolder();
                int spamAction = this.usm.isSpamEnabled() ? (spamFullname.equals(sourceFullname) ? -1 : (spamFullname.equals(destFullname) ? 1 : 0)) : 0;
                if (spamAction != 0) {
                    if (spamAction == 1) {
                        flagInfo = messageStorage.getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                    } else {
                        flagInfo = messageStorage.getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                        SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                    }
                }
            }
            if (move) {
                maildIds = messageStorage.moveMessages(sourceFullname, destFullname, msgUIDs, false);
                this.postEvent(sourceAccountId, sourceFullname, true);
            } else {
                maildIds = messageStorage.copyMessages(sourceFullname, destFullname, msgUIDs, false);
            }
            if (null != flagInfo) {
                ArrayList<String> list = new ArrayList<String>(maildIds.length >> 1);
                for (int i = 0; i < maildIds.length; ++i) {
                    if (flagInfo[i].isSeen()) continue;
                    list.add(maildIds[i]);
                }
                messageStorage.updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
            }
            this.postEvent(sourceAccountId, destFullname, true);
            try {
                if (move) {
                    MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                }
                MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return maildIds;
        }
        MailAccess<?, ?> destAccess = this.initMailAccess(destAccountId);
        try {
            MailMessage[] flagInfo = null;
            if (move) {
                int spamActionSource = 0;
                boolean spamActionDest = false;
                if (this.usm.isSpamEnabled()) {
                    if (sourceFullname.equals(this.mailAccess.getFolderStorage().getSpamFolder())) {
                        spamActionSource = -1;
                    }
                    if (destFullname.equals(destAccess.getFolderStorage().getSpamFolder())) {
                        spamActionDest = true;
                    }
                }
                if (-1 == spamActionSource) {
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleHam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                }
                if (spamActionDest) {
                    flagInfo = this.mailAccess.getMessageStorage().getMessages(sourceFullname, msgUIDs, new MailField[]{MailField.FLAGS});
                    SpamHandlerRegistry.getSpamHandlerBySession(this.session, this.accountId).handleSpam(this.accountId, sourceFullname, msgUIDs, false, this.session);
                }
            }
            MailMessage[] messages = this.mailAccess.getMessageStorage().getMessages(sourceFullname, msgUIDs, FIELDS_FULL);
            String[] maildIds = destAccess.getMessageStorage().appendMessages(destFullname, messages);
            if (move) {
                this.mailAccess.getMessageStorage().deleteMessages(sourceFullname, MailServletInterfaceImpl.messages2ids(messages), true);
                this.postEvent(sourceAccountId, sourceFullname, true);
            }
            if (null != flagInfo) {
                ArrayList<String> list = new ArrayList<String>(maildIds.length >> 1);
                for (int i = 0; i < maildIds.length; ++i) {
                    if (flagInfo[i].isSeen()) continue;
                    list.add(maildIds[i]);
                }
                destAccess.getMessageStorage().updateMessageFlags(destFullname, list.toArray(new String[list.size()]), 32, false);
            }
            this.postEvent(destAccountId, destFullname, true);
            try {
                if (move) {
                    MailMessageCache.getInstance().removeFolderMessages(sourceAccountId, sourceFullname, this.session.getUserId(), this.contextId);
                }
                MailMessageCache.getInstance().removeFolderMessages(destAccountId, destFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            String[] stringArray = maildIds;
            return stringArray;
        }
        finally {
            destAccess.close(true);
        }
    }

    @Override
    public String deleteFolder(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        String trashFullname = folderStorage.getTrashFolder();
        boolean hardDelete = fullName.startsWith(trashFullname);
        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
        String retval = MailFolderUtility.prepareFullname(accountId, folderStorage.deleteFolder(fullName, hardDelete));
        this.postEvent(accountId, fullName, false, true, false);
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!hardDelete) {
            this.postEvent(accountId, trashFullname, false);
        }
        this.postEvent4Subfolders(accountId, subfolders);
        return retval;
    }

    private void postEvent4Subfolders(int accountId, Map<String, Map<?, ?>> subfolders) {
        int size = subfolders.size();
        Iterator<Map.Entry<String, Map<?, ?>>> iter = subfolders.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Map<?, ?>> entry = iter.next();
            Map<String, Map<?, ?>> m = entry.getValue();
            if (!m.isEmpty()) {
                this.postEvent4Subfolders(accountId, m);
            }
            this.postEvent(accountId, entry.getKey(), false);
        }
    }

    private Map<String, Map<?, ?>> subfolders(String fullName) throws OXException {
        HashMap m = new HashMap();
        this.subfoldersRecursively(fullName, m);
        return m;
    }

    private void subfoldersRecursively(String parent, Map<String, Map<?, ?>> m) throws OXException {
        MailFolder[] mailFolders = this.mailAccess.getFolderStorage().getSubfolders(parent, true);
        if (null == mailFolders || 0 == mailFolders.length) {
            Map emptyMap = Collections.emptyMap();
            m.put(parent, emptyMap);
        } else {
            HashMap subMap = new HashMap();
            int size = mailFolders.length;
            for (int i = 0; i < size; ++i) {
                String fullName = mailFolders[i].getFullname();
                this.subfoldersRecursively(fullName, subMap);
            }
            m.put(parent, subMap);
        }
    }

    @Override
    public boolean deleteMessages(String folder, String[] msgUIDs, boolean hardDelete) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        String trashFullname = this.mailAccess.getFolderStorage().getTrashFolder();
        boolean hd = hardDelete || UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isHardDeleteMsgs() || null != trashFullname && fullName.startsWith(trashFullname);
        this.mailAccess.getMessageStorage().deleteMessages(fullName, msgUIDs, hd);
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.postEvent(accountId, fullName, true, true, false);
        if (!hd) {
            this.postEvent(accountId, trashFullname, true, true, false);
        }
        return true;
    }

    @Override
    public int[] getAllMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        MailFolder f = folderStorage.getFolder(fullName);
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            IMailFolderStorageEnhanced storageEnhanced = (IMailFolderStorageEnhanced)folderStorage;
            int totalCounter = storageEnhanced.getTotalCounter(fullName);
            int unreadCounter = storageEnhanced.getUnreadCounter(fullName);
            int newCounter = storageEnhanced.getNewCounter(fullName);
            return new int[]{totalCounter, newCounter, unreadCounter, f.getDeletedMessageCount()};
        }
        int totalCounter = this.mailAccess.getMessageStorage().searchMessages(fullName, IndexRange.NULL, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID).length;
        int unreadCounter = this.mailAccess.getMessageStorage().getUnreadMessages(fullName, MailSortField.RECEIVED_DATE, OrderDirection.DESC, FIELDS_ID, -1).length;
        return new int[]{totalCounter, f.getNewMessageCount(), unreadCounter, f.getDeletedMessageCount()};
    }

    @Override
    public SearchIterator<MailMessage> getAllMessages(String folder, int sortCol, int order, int[] fields, int[] fromToIndices) throws OXException {
        return this.getMessages(folder, fromToIndices, sortCol, order, null, null, false, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<MailMessage>> getAllSimpleThreadStructuredMessages(String folder, boolean includeSent, boolean cache, int sortCol, int order, int[] fields, int[] fromToIndices, long max) throws OXException {
        SearchIterator<MailMessage> searchIterator;
        MailCapabilities capabilities;
        block18: {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
            int accountId = argument.getAccountId();
            this.initConnection(accountId);
            String fullName = argument.getFullname();
            boolean mergeWithSent = includeSent && !this.mailAccess.getFolderStorage().getSentFolder().equals(fullName);
            IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
            if (messageStorage instanceof ISimplifiedThreadStructure) {
                ISimplifiedThreadStructure simplifiedThreadStructure = (ISimplifiedThreadStructure)((Object)messageStorage);
                MailFields mailFields = new MailFields(MailField.getFields(fields));
                mailFields.add(MailField.toField(MailListField.getField(sortCol)));
                try {
                    return simplifiedThreadStructure.getThreadSortedMessages(fullName, mergeWithSent, cache, null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]), max, MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), mailFields.toArray());
                }
                catch (OXException e) {
                    if (2046 == e.getCode() && ("MSG".equals(e.getPrefix()) || "IMAP".equals(e.getPrefix())) || MailExceptionCode.UNSUPPORTED_OPERATION.equals(e)) break block18;
                    throw e;
                }
            }
        }
        boolean retry = !(capabilities = this.mailAccess.getMailConfig().getCapabilities()).hasThreadReferences();
        try {
            int allSort = MailSortField.RECEIVED_DATE.getField();
            int allOrder = OrderDirection.DESC.getOrder();
            searchIterator = this.getAllThreadedMessages(folder, allSort, allOrder, fields, null);
        }
        catch (OXException e) {
            if (!retry) {
                throw e;
            }
            searchIterator = this.getAllMessages(folder, sortCol, order, fields, null);
        }
        try {
            MailSortField effectiveSortField;
            List<List<MailMessage>> list = new LinkedList<List<MailMessage>>();
            LinkedList<MailMessage> current = new LinkedList<MailMessage>();
            int size = searchIterator.size();
            for (int i = 0; i < size; ++i) {
                MailMessage mail = (MailMessage)searchIterator.next();
                int threadLevel = mail.getThreadLevel();
                if (0 == threadLevel) {
                    list.add(current);
                    current = new LinkedList();
                }
                current.add(mail);
            }
            list.add(current);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List mails = (List)iterator.next();
                if (null == mails || mails.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                Collections.sort(mails, COMPARATOR);
            }
            boolean descending = OrderDirection.DESC.equals((Object)OrderDirection.getOrderDirection(order));
            MailSortField mailSortField = effectiveSortField = sortCol <= 0 ? MailSortField.RECEIVED_DATE : MailSortField.getField(sortCol);
            if (null == effectiveSortField) {
                effectiveSortField = MailSortField.RECEIVED_DATE;
            }
            final MailMessageComparator comparator = new MailMessageComparator(effectiveSortField, descending, null);
            Comparator<List<MailMessage>> listComparator = new Comparator<List<MailMessage>>(){

                @Override
                public int compare(List<MailMessage> o1, List<MailMessage> o2) {
                    return comparator.compare(o1.get(0), o2.get(0));
                }
            };
            Collections.sort(list, listComparator);
            if (null != fromToIndices) {
                int fromIndex = fromToIndices[0];
                int toIndex = fromToIndices[1];
                int lsize = list.size();
                if (fromIndex > lsize) {
                    List<List<MailMessage>> list2 = Collections.emptyList();
                    return list2;
                }
                if (toIndex >= lsize) {
                    toIndex = lsize;
                }
                list = list.subList(fromIndex, toIndex);
            }
            LinkedList<List<MailMessage>> linkedList = list;
            return linkedList;
        }
        finally {
            searchIterator.close();
        }
    }

    @Override
    public SearchIterator<MailMessage> getAllThreadedMessages(String folder, int sortCol, int order, int[] fields, int[] fromToIndices) throws OXException {
        return this.getThreadedMessages(folder, fromToIndices, sortCol, order, null, null, false, fields);
    }

    @Override
    public SearchIterator<MailFolder> getChildFolders(String parentFolder, boolean all) throws OXException {
        String[] names;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentFolder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String parentFullname = argument.getFullname();
        ArrayList<MailFolder> children = new ArrayList<MailFolder>(Arrays.asList(this.mailAccess.getFolderStorage().getSubfolders(parentFullname, all)));
        if (children.isEmpty()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
            Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(this.session);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                MailFolder mailFolder = (MailFolder)it.next();
                if (!pop3StorageFolders.contains(mailFolder.getFullname())) continue;
                it.remove();
            }
        }
        if (!"default".equals(parentFullname) && !INBOX_ID.equals(parentFullname)) {
            Collections.sort(children, new SimpleMailFolderComparator(this.getUserLocale()));
            return new SearchIteratorDelegator(children.iterator(), children.size());
        }
        if (this.isDefaultFoldersChecked(accountId)) {
            names = this.getSortedDefaultMailFolders(accountId);
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(this.getInboxFolder(accountId));
            if (null != fa) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getDraftsFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getSentFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getSpamFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            if (null != (fa = MailFolderUtility.prepareMailFolderParam(this.getTrashFolder(accountId)))) {
                tmp.add(fa.getFullname());
            }
            names = tmp.toArray(new String[tmp.size()]);
        }
        Collections.sort(children, new MailFolderComparator(names, this.getUserLocale()));
        return new SearchIteratorDelegator(children.iterator(), children.size());
    }

    @Override
    public String getConfirmedHamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(5, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getConfirmedHamFolder());
    }

    @Override
    public String getConfirmedSpamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(4, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getConfirmedSpamFolder());
    }

    private String getDefaultMailFolder(int index, int accountId) {
        String[] arr = (String[])MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        return arr == null ? null : arr[index];
    }

    private String[] getSortedDefaultMailFolders(int accountId) {
        String[] arr = (String[])MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        if (arr == null) {
            return STR_ARR;
        }
        return new String[]{INBOX_ID, arr[0], arr[1], arr[2], arr[3]};
    }

    @Override
    public int getDeletedMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName).getDeletedMessageCount();
    }

    @Override
    public String getDraftsFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(0, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getDraftsFolder());
    }

    @Override
    public MailFolder getFolder(String folder, boolean checkFolder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        this.initConnection(argument.getAccountId());
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailMessage getForwardMessageForDisplay(String[] folders2, String[] fowardMsgUIDs, UserSettingMail usm) throws OXException {
        if (null == folders2 || null == fowardMsgUIDs || folders2.length != fowardMsgUIDs.length) {
            throw new IllegalArgumentException("Illegal arguments");
        }
        if (folders2.length > 8) {
            throw MailExceptionCode.TOO_MANY_FORWARD_MAILS.create(8);
        }
        FullnameArgument[] arguments = new FullnameArgument[folders2.length];
        for (int i = 0; i < folders2.length; ++i) {
            arguments[i] = MailFolderUtility.prepareMailFolderParam(folders2[i]);
        }
        boolean sameAccount = true;
        int accountId = arguments[0].getAccountId();
        for (int i = 1; sameAccount && i < arguments.length; ++i) {
            sameAccount = accountId == arguments[i].getAccountId();
        }
        TransportProperties transportProperties = TransportProperties.getInstance();
        MailUploadQuotaChecker checker = new MailUploadQuotaChecker(usm);
        long maxPerMsg = checker.getFileQuotaMax();
        long max = checker.getQuotaMax();
        if (sameAccount) {
            this.initConnection(accountId);
            MailMessage[] originalMails = new MailMessage[folders2.length];
            if (transportProperties.isPublishOnExceededQuota() && (!transportProperties.isPublishPrimaryAccountOnly() || 0 == accountId)) {
                for (int i = 0; i < arguments.length; ++i) {
                    MailMessage origMail = this.mailAccess.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    originalMails[i] = origMail;
                }
            } else {
                long total = 0L;
                for (int i = 0; i < arguments.length; ++i) {
                    MailMessage origMail = this.mailAccess.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    long size = origMail.getSize();
                    if (size <= 0L) {
                        size = 2048L;
                    }
                    if (maxPerMsg > 0L && size > maxPerMsg) {
                        String fileName = origMail.getSubject();
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(maxPerMsg, null == fileName ? "" : fileName, size);
                    }
                    if (max > 0L && (total += size) > max) {
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(max);
                    }
                    originalMails[i] = origMail;
                }
            }
            return this.mailAccess.getLogicTools().getFowardMessage(originalMails, usm);
        }
        MailMessage[] originalMails = new MailMessage[folders2.length];
        if (transportProperties.isPublishOnExceededQuota() && (!transportProperties.isPublishPrimaryAccountOnly() || 0 == accountId)) {
            for (int i = 0; i < arguments.length && sameAccount; ++i) {
                MailAccess<?, ?> ma = this.initMailAccess(arguments[i].getAccountId());
                try {
                    MailMessage origMail = ma.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    originalMails[i] = origMail;
                    origMail.loadContent();
                    continue;
                }
                finally {
                    ma.close(true);
                }
            }
        } else {
            long total = 0L;
            for (int i = 0; i < arguments.length && sameAccount; ++i) {
                MailAccess<?, ?> ma = this.initMailAccess(arguments[i].getAccountId());
                try {
                    MailMessage origMail = ma.getMessageStorage().getMessage(arguments[i].getFullname(), fowardMsgUIDs[i], false);
                    if (null == origMail) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(fowardMsgUIDs[i], arguments[i].getFullname());
                    }
                    long size = origMail.getSize();
                    if (size <= 0L) {
                        size = 2048L;
                    }
                    if (maxPerMsg > 0L && size > maxPerMsg) {
                        String fileName = origMail.getSubject();
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(maxPerMsg, null == fileName ? "" : fileName, size);
                    }
                    if (max > 0L && (total += size) > max) {
                        throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(max);
                    }
                    originalMails[i] = origMail;
                    origMail.loadContent();
                    continue;
                }
                finally {
                    ma.close(true);
                }
            }
        }
        int[] accountIDs = new int[originalMails.length];
        for (int i = 0; i < accountIDs.length; ++i) {
            accountIDs[i] = arguments[i].getAccountId();
        }
        return MimeForward.getFowardMail(originalMails, this.session, accountIDs, usm);
    }

    @Override
    public String getInboxFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, INBOX_ID);
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getFolder(INBOX_ID).getFullname());
    }

    @Override
    public MailConfig getMailConfig() throws OXException {
        return this.mailConfig;
    }

    @Override
    public int getAccountID() {
        return this.accountId;
    }

    @Override
    public MailMessage getMessage(String folder, String msgUID, boolean markAsSeen) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        if ("default".equals(folder)) {
            throw MailExceptionCode.FOLDER_DOES_NOT_HOLD_MESSAGES.create("default");
        }
        String fullName = argument.getFullname();
        MailMessage mail = this.mailAccess.getMessageStorage().getMessage(fullName, msgUID, markAsSeen);
        if (mail != null) {
            if (!mail.containsAccountId() || mail.getAccountId() < 0) {
                mail.setAccountId(accountId);
            }
            if (mail.containsPrevSeen() && !mail.isPrevSeen()) {
                this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true);
            }
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(new String[]{mail.getMailId()}, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, mail.isSeen() ? ARGS_FLAG_SEEN_SET : ARGS_FLAG_SEEN_UNSET);
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return mail;
    }

    @Override
    public MailPart getMessageAttachment(String folder, String msgUID, String attachmentPosition, boolean displayVersion) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getAttachment(fullName, msgUID, attachmentPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedFile getMessages(String folder, String[] msgIds) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] mails = new MailMessage[msgIds.length];
        for (int i = 0; i < msgIds.length; ++i) {
            mails[i] = this.mailAccess.getMessageStorage().getMessage(fullName, msgIds[i], false);
        }
        ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
        ManagedFile[] files = new ManagedFile[mails.length];
        try {
            UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream(8192);
            for (int i = 0; i < files.length; ++i) {
                MailMessage mail = mails[i];
                if (null == mail) {
                    files[i] = null;
                    continue;
                }
                bout.reset();
                mail.writeTo((OutputStream)bout);
                files[i] = mfm.createManagedFile(bout.toByteArray());
            }
            try {
                File tempFile = mfm.newTempFile();
                ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tempFile));
                zipOutput.setEncoding("UTF-8");
                zipOutput.setUseLanguageEncodingFlag(true);
                try {
                    byte[] buf = new byte[8192];
                    HashSet<String> names = new HashSet<String>(files.length);
                    for (int i = 0; i < files.length; ++i) {
                        File tmpFile;
                        ManagedFile file = files[i];
                        File file2 = tmpFile = null == file ? null : file.getFile();
                        if (null == tmpFile) continue;
                        FileInputStream in = new FileInputStream(tmpFile);
                        try {
                            int len;
                            ZipArchiveEntry entry;
                            String subject = mails[i].getSubject();
                            String ext = ".eml";
                            String name = (MailServletInterfaceImpl.isEmpty(subject) ? "mail" + (i + 1) : MailServletInterfaceImpl.saneForFileName(subject)) + ".eml";
                            int reslen = name.lastIndexOf(46);
                            int count = 1;
                            while (!names.add(name)) {
                                name = name.substring(0, reslen);
                                name = new StringAllocator(name).append("_(").append(count++).append(')').append(".eml").toString();
                            }
                            int num = 1;
                            while (true) {
                                try {
                                    int pos = name.indexOf(".eml");
                                    String entryName = name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + ".eml";
                                    entry = new ZipArchiveEntry(entryName);
                                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                                }
                                catch (ZipException e) {
                                    String message = e.getMessage();
                                    if (message == null || !message.startsWith("duplicate entry")) {
                                        throw e;
                                    }
                                    ++num;
                                    continue;
                                }
                                break;
                            }
                            long size = 0L;
                            while ((len = in.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                                size += (long)len;
                            }
                            entry.setSize(size);
                            zipOutput.closeArchiveEntry();
                            continue;
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    try {
                        zipOutput.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                ManagedFile managedFile = mfm.createManagedFile(tempFile);
                return managedFile;
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        finally {
            for (int i = 0; i < files.length; ++i) {
                ManagedFile file = files[i];
                if (null == file) continue;
                file.delete();
            }
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static String saneForFileName(String fileName) {
        if (MailServletInterfaceImpl.isEmpty(fileName)) {
            return fileName;
        }
        int len = fileName.length();
        StringAllocator sb = new StringAllocator(len);
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (Character.isWhitespace(c)) {
                if (prev == '_') continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('/' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('\\' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            prev = '\u0000';
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedFile getMessageAttachments(String folder, String msgUID, String[] attachmentPositions) throws OXException {
        ManagedFile file;
        int i;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailPart[] parts = new MailPart[attachmentPositions.length];
        for (int i2 = 0; i2 < parts.length; ++i2) {
            parts[i2] = this.mailAccess.getMessageStorage().getAttachment(fullName, msgUID, attachmentPositions[i2]);
        }
        ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
        ManagedFile[] files = new ManagedFile[parts.length];
        try {
            for (int i3 = 0; i3 < files.length; ++i3) {
                MailPart part = parts[i3];
                files[i3] = null == part ? null : mfm.createManagedFile(part.getInputStream());
            }
            try {
                File tempFile = mfm.newTempFile();
                ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tempFile));
                zipOutput.setEncoding("UTF-8");
                zipOutput.setUseLanguageEncodingFlag(true);
                try {
                    byte[] buf = new byte[8192];
                    for (i = 0; i < files.length; ++i) {
                        File tmpFile;
                        file = files[i];
                        File file2 = tmpFile = null == file ? null : file.getFile();
                        if (null == tmpFile) continue;
                        FileInputStream in = new FileInputStream(tmpFile);
                        try {
                            int len;
                            ZipArchiveEntry entry;
                            String name = parts[i].getFileName();
                            if (null == name) {
                                List<String> extensions = MimeType2ExtMap.getFileExtensions(parts[i].getContentType().getBaseType());
                                name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + extensions.get(0);
                            }
                            int num = 1;
                            while (true) {
                                try {
                                    int pos = name.indexOf(46);
                                    String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                                    entry = new ZipArchiveEntry(entryName);
                                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                                }
                                catch (ZipException e) {
                                    String message = e.getMessage();
                                    if (message == null || !message.startsWith("duplicate entry")) {
                                        throw e;
                                    }
                                    ++num;
                                    continue;
                                }
                                break;
                            }
                            long size = 0L;
                            while ((len = in.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                                size += (long)len;
                            }
                            entry.setSize(size);
                            zipOutput.closeArchiveEntry();
                            continue;
                        }
                        finally {
                            Streams.close((Closeable)in);
                        }
                    }
                }
                finally {
                    Streams.close((Closeable)zipOutput);
                }
                ManagedFile managedFile = mfm.createManagedFile(tempFile);
                return managedFile;
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
        finally {
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                if (null == file) continue;
                file.delete();
            }
        }
    }

    @Override
    public int getMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailFolderStorage folderStorage = this.mailAccess.getFolderStorage();
        if (folderStorage instanceof IMailFolderStorageEnhanced) {
            return ((IMailFolderStorageEnhanced)folderStorage).getTotalCounter(fullName);
        }
        return folderStorage.getFolder(fullName).getMessageCount();
    }

    @Override
    public MailPart getMessageImage(String folder, String msgUID, String cid) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getImageAttachment(fullName, msgUID, cid);
    }

    @Override
    public MailMessage[] getMessageList(String folder, String[] uids, int[] fields, String[] headerFields) throws OXException {
        MailMessage[] mails;
        boolean loadHeaders;
        String fullName;
        int accountId;
        block16: {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
            accountId = argument.getAccountId();
            fullName = argument.getFullname();
            loadHeaders = null != headerFields && 0 < headerFields.length;
            try {
                mails = MailMessageCache.getInstance().getMessages(uids, accountId, fullName, this.session.getUserId(), this.contextId);
                if (null == mails) break block16;
                this.accountId = accountId;
                if (loadHeaders) {
                    ArrayList<String> loadMe = new ArrayList<String>(mails.length);
                    HashMap<String, MailMessage> finder = new HashMap<String, MailMessage>(mails.length);
                    for (MailMessage mail : mails) {
                        String mailId = mail.getMailId();
                        finder.put(mailId, mail);
                        if (mail.hasHeaders(headerFields)) continue;
                        loadMe.add(mailId);
                    }
                    if (!loadMe.isEmpty()) {
                        this.initConnection(accountId);
                        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
                        if (messageStorage instanceof IMailMessageStorageExt) {
                            IMailMessageStorageExt messageStorageExt = (IMailMessageStorageExt)messageStorage;
                            for (MailMessage header : messageStorageExt.getMessages(fullName, loadMe.toArray(STR_ARR), FIELDS_ID_INFO, headerFields)) {
                                MailMessage mailMessage;
                                if (null == header || null == (mailMessage = (MailMessage)finder.get(header.getMailId()))) continue;
                                mailMessage.addHeaders(header.getHeaders());
                            }
                        } else {
                            for (MailMessage header : messageStorage.getMessages(fullName, loadMe.toArray(STR_ARR), HEADERS)) {
                                MailMessage mailMessage;
                                if (null == header || null == (mailMessage = (MailMessage)finder.get(header.getMailId()))) continue;
                                mailMessage.addHeaders(header.getHeaders());
                            }
                        }
                    }
                }
                return mails;
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.initConnection(accountId);
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        if (messageStorage instanceof IMailMessageStorageExt) {
            mails = ((IMailMessageStorageExt)messageStorage).getMessages(fullName, uids, MailField.toFields(MailListField.getFields(fields)), headerFields);
        } else {
            MailField[] mailFields;
            if (loadHeaders) {
                MailFields col = new MailFields(MailField.toFields(MailListField.getFields(fields)));
                col.add(MailField.HEADERS);
                mailFields = col.toArray();
            } else {
                mailFields = MailField.toFields(MailListField.getFields(fields));
            }
            mails = messageStorage.getMessages(fullName, uids, mailFields);
        }
        try {
            if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                MailMessageCache.getInstance().putMessages(accountId, mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return mails;
    }

    @Override
    public SearchIterator<MailMessage> getMessages(String folder, int[] fromToIndices, int sortCol, int order, com.openexchange.search.SearchTerm<?> searchTerm, boolean linkSearchTermsWithOR, int[] fields) throws OXException {
        return this.getMessagesInternal(MailFolderUtility.prepareMailFolderParam(folder), SearchTermMapper.map(searchTerm), fromToIndices, sortCol, order, fields);
    }

    @Override
    public SearchIterator<MailMessage> getMessages(String folder, int[] fromToIndices, int sortCol, int order, int[] searchCols, String[] searchPatterns, boolean linkSearchTermsWithOR, int[] fields) throws OXException {
        this.checkPatternLength(searchPatterns);
        SearchTerm<?> searchTerm = searchCols == null || searchCols.length == 0 ? null : SearchUtility.parseFields(searchCols, searchPatterns, linkSearchTermsWithOR);
        return this.getMessagesInternal(MailFolderUtility.prepareMailFolderParam(folder), searchTerm, fromToIndices, sortCol, order, fields);
    }

    private SearchIterator<MailMessage> getMessagesInternal(FullnameArgument argument, SearchTerm<?> searchTerm, int[] fromToIndices, int sortCol, int order, int[] fields) throws OXException {
        int i;
        boolean onlyFolderAndID;
        MailField[] useFields;
        boolean cachable;
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] mails = this.mailAccess.getMessageStorage().searchMessages(fullName, null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]), MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), searchTerm, FIELDS_ID_INFO);
        if (mails == null || mails.length == 0) {
            return SearchIteratorAdapter.emptyIterator();
        }
        boolean bl = cachable = mails.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit();
        if (cachable) {
            useFields = MimeStorageUtility.getCacheFieldsArray();
            onlyFolderAndID = false;
        } else {
            useFields = MailField.getFields(fields);
            onlyFolderAndID = MailServletInterfaceImpl.onlyFolderAndID(useFields);
        }
        if (!onlyFolderAndID && !MailServletInterfaceImpl.containsAll(mails[0], useFields)) {
            String[] mailIds = new String[mails.length];
            for (i = 0; i < mailIds.length; ++i) {
                mailIds[i] = mails[i].getMailId();
            }
            mails = this.mailAccess.getMessageStorage().getMessages(fullName, mailIds, useFields);
            if (null == mails) {
                return SearchIteratorAdapter.emptyIterator();
            }
        }
        for (MailMessage mail : mails) {
            if (mail == null || mail.containsAccountId() && mail.getAccountId() >= 0) continue;
            mail.setAccountId(accountId);
        }
        try {
            MailMessageCache.getInstance().removeUserMessages(this.session.getUserId(), this.contextId);
            if (cachable && mails.length > 0) {
                MailMessageCache.getInstance().putMessages(accountId, mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        ArrayList<MailMessage> l = new ArrayList<MailMessage>(mails.length);
        for (i = 0; i < mails.length; ++i) {
            MailMessage mm = mails[i];
            if (null == mm) continue;
            l.add(mm);
        }
        return new SearchIteratorDelegator(l);
    }

    private static boolean containsAll(MailMessage candidate, MailField[] fields) {
        boolean contained = true;
        int length = fields.length;
        block19: for (int i = 0; contained && i < length; ++i) {
            MailField field = fields[i];
            switch (field) {
                case ACCOUNT_NAME: {
                    contained = candidate.containsAccountId() || candidate.containsAccountName();
                    continue block19;
                }
                case BCC: {
                    contained = candidate.containsBcc();
                    continue block19;
                }
                case CC: {
                    contained = candidate.containsCc();
                    continue block19;
                }
                case COLOR_LABEL: {
                    contained = candidate.containsColorLabel();
                    continue block19;
                }
                case CONTENT_TYPE: {
                    contained = candidate.containsContentType();
                    continue block19;
                }
                case DISPOSITION_NOTIFICATION_TO: {
                    contained = candidate.containsDispositionNotification();
                    continue block19;
                }
                case FLAGS: {
                    contained = candidate.containsFlags();
                    continue block19;
                }
                case FOLDER_ID: {
                    contained = true;
                    continue block19;
                }
                case FROM: {
                    contained = candidate.containsFrom();
                    continue block19;
                }
                case ID: {
                    contained = null != candidate.getMailId();
                    continue block19;
                }
                case PRIORITY: {
                    contained = candidate.containsPriority();
                    continue block19;
                }
                case RECEIVED_DATE: {
                    contained = candidate.containsReceivedDate();
                    continue block19;
                }
                case SENT_DATE: {
                    contained = candidate.containsSentDate();
                    continue block19;
                }
                case SIZE: {
                    contained = candidate.containsSize();
                    continue block19;
                }
                case SUBJECT: {
                    contained = candidate.containsSubject();
                    continue block19;
                }
                case THREAD_LEVEL: {
                    contained = candidate.containsThreadLevel();
                    continue block19;
                }
                case TO: {
                    contained = candidate.containsTo();
                    continue block19;
                }
                default: {
                    contained = false;
                }
            }
        }
        return contained;
    }

    private static boolean onlyFolderAndID(MailField[] fields) {
        if (fields.length != 2) {
            return false;
        }
        int i = 0;
        for (MailField field : fields) {
            if (MailField.ID.equals((Object)field)) {
                i |= 1;
                continue;
            }
            if (!MailField.FOLDER_ID.equals((Object)field)) continue;
            i |= 2;
        }
        return i == 3;
    }

    @Override
    public String[] appendMessages(String destFolder, MailMessage[] mails, boolean force) throws OXException {
        return this.appendMessages(destFolder, mails, force, false);
    }

    @Override
    public String[] importMessages(String destFolder, MailMessage[] mails, boolean force) throws OXException {
        return this.appendMessages(destFolder, mails, force, true);
    }

    public String[] appendMessages(String destFolder, MailMessage[] mails, boolean force, boolean isImport) throws OXException {
        if (mails == null || mails.length == 0) {
            return new String[0];
        }
        if (!force) {
            try {
                HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                if (this.usm.getSendAddr() != null && this.usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(this.usm.getSendAddr()));
                }
                User user = this.getUser();
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                String[] aliases = user.getAliases();
                for (String string : aliases) {
                    validAddrs.add(new QuotedInternetAddress(string));
                }
                for (MailMessage mailMessage : mails) {
                    Object[] from = mailMessage.getFrom();
                    List<InternetAddress> froms = Arrays.asList(from);
                    if (validAddrs.containsAll(froms)) continue;
                    throw MailExceptionCode.INVALID_SENDER.create(froms.size() == 1 ? froms.get(0).toString() : Arrays.toString(from));
                }
            }
            catch (AddressException e) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
        }
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(destFolder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        if (this.mailAccess.getFolderStorage().getDraftsFolder().equals(fullName)) {
            for (MailMessage mailMessage : mails) {
                mailMessage.setFlag(4, true);
            }
        }
        if (!isImport) {
            return this.mailAccess.getMessageStorage().appendMessages(fullName, mails);
        }
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        MailMessage[] tmp = new MailMessage[1];
        ArrayList<String> idList = new ArrayList<String>();
        for (MailMessage mail : mails) {
            MailImportResult mir = new MailImportResult();
            mir.setMail(mail);
            try {
                tmp[0] = mail;
                String[] idStr = messageStorage.appendMessages(fullName, tmp);
                mir.setId(idStr[0]);
                idList.add(idStr[0]);
            }
            catch (OXException e) {
                mir.setException(e);
            }
            this.mailImportResults.add(mir);
        }
        String[] stringArray = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            stringArray[i] = (String)idList.get(i);
        }
        return stringArray;
    }

    @Override
    public int getNewMessageCount(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getFolderStorage().getFolder(fullName).getNewMessageCount();
    }

    @Override
    public SearchIterator<MailMessage> getNewMessages(String folder, int sortCol, int order, int[] fields, int limit) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return SearchIteratorAdapter.createArrayIterator((Object[])this.mailAccess.getMessageStorage().getUnreadMessages(fullName, MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), MailField.toFields(MailListField.getFields(fields)), limit));
    }

    @Override
    public SearchIterator<MailFolder> getPathToDefaultFolder(String folder) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return SearchIteratorAdapter.createArrayIterator((Object[])this.mailAccess.getFolderStorage().getPath2DefaultFolder(fullName));
    }

    @Override
    public long[][] getQuotas(int[] types) throws OXException {
        this.initConnection(0);
        Quota.Type[] qtypes = new Quota.Type[types.length];
        for (int i = 0; i < qtypes.length; ++i) {
            qtypes[i] = MailServletInterfaceImpl.getType(types[i]);
        }
        Quota[] quotas = this.mailAccess.getFolderStorage().getQuotas(INBOX_ID, qtypes);
        long[][] retval = new long[quotas.length][];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = quotas[i].toLongArray();
        }
        return retval;
    }

    @Override
    public long getQuotaLimit(int type) throws OXException {
        this.initConnection(0);
        if (1 == type) {
            return this.mailAccess.getFolderStorage().getStorageQuota(INBOX_ID).getLimit();
        }
        if (2 == type) {
            return this.mailAccess.getFolderStorage().getMessageQuota(INBOX_ID).getLimit();
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    @Override
    public long getQuotaUsage(int type) throws OXException {
        this.initConnection(0);
        if (1 == type) {
            return this.mailAccess.getFolderStorage().getStorageQuota(INBOX_ID).getUsage();
        }
        if (2 == type) {
            return this.mailAccess.getFolderStorage().getMessageQuota(INBOX_ID).getUsage();
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    private static Quota.Type getType(int type) {
        if (1 == type) {
            return Quota.Type.STORAGE;
        }
        if (2 == type) {
            return Quota.Type.MESSAGE;
        }
        throw new IllegalArgumentException("Unknown quota resource type: " + type);
    }

    @Override
    public MailMessage getReplyMessageForDisplay(String folder, String replyMsgUID, boolean replyToAll, UserSettingMail usm) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage originalMail = this.mailAccess.getMessageStorage().getMessage(fullName, replyMsgUID, false);
        if (null == originalMail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(replyMsgUID, fullName);
        }
        return this.mailAccess.getLogicTools().getReplyMessage(originalMail, replyToAll, usm);
    }

    @Override
    public SearchIterator<MailFolder> getRootFolders() throws OXException {
        this.initConnection(0);
        return SearchIteratorAdapter.createArrayIterator((Object[])new MailFolder[]{this.mailAccess.getFolderStorage().getRootFolder()});
    }

    @Override
    public String getSentFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(1, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getSentFolder());
    }

    @Override
    public String getSpamFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(2, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getSpamFolder());
    }

    @Override
    public SearchIterator<MailMessage> getThreadedMessages(String folder, int[] fromToIndices, int sortCol, int order, int[] searchCols, String[] searchPatterns, boolean linkSearchTermsWithOR, int[] fields) throws OXException {
        boolean onlyFolderAndID;
        MailField[] useFields;
        this.checkPatternLength(searchPatterns);
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        SearchTerm<?> searchTerm = searchCols == null || searchCols.length == 0 ? null : SearchUtility.parseFields(searchCols, searchPatterns, linkSearchTermsWithOR);
        Object[] mails = this.mailAccess.getMessageStorage().getThreadSortedMessages(fullName, fromToIndices == null ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]), MailSortField.getField(sortCol), OrderDirection.getOrderDirection(order), searchTerm, FIELDS_ID_INFO);
        if (mails == null || mails.length == 0) {
            return SearchIteratorAdapter.emptyIterator();
        }
        if (mails.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit()) {
            useFields = MimeStorageUtility.getCacheFieldsArray();
            onlyFolderAndID = false;
        } else {
            useFields = MailField.toFields(MailListField.getFields(fields));
            onlyFolderAndID = MailServletInterfaceImpl.onlyFolderAndID(useFields);
        }
        if (!onlyFolderAndID) {
            String[] mailIds = new String[mails.length];
            for (int i = 0; i < mailIds.length; ++i) {
                mailIds[i] = mails[i].getMailId();
            }
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullName, mailIds, useFields);
            for (int i = 0; i < fetchedMails.length; ++i) {
                fetchedMails[i].setThreadLevel(((MailMessage)mails[i]).getThreadLevel());
            }
            mails = fetchedMails;
        }
        for (MailMessage mailMessage : mails) {
            if (mailMessage == null || mailMessage.containsAccountId() && mailMessage.getAccountId() >= 0) continue;
            mailMessage.setAccountId(accountId);
        }
        try {
            MailMessageCache.getInstance().removeFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId);
            if (mails.length > 0 && mails.length < this.mailAccess.getMailConfig().getMailProperties().getMailFetchLimit()) {
                MailMessageCache.getInstance().putMessages(accountId, (MailMessage[])mails, this.session.getUserId(), this.contextId);
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return SearchIteratorAdapter.createArrayIterator((Object[])mails);
    }

    private void checkPatternLength(String[] patterns) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters || null == patterns) {
            return;
        }
        for (String pattern : patterns) {
            if (null == pattern || SearchStrings.lengthWithoutWildcards(pattern) >= minimumSearchCharacters) continue;
            throw MailExceptionCode.PATTERN_TOO_SHORT.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    @Override
    public String getTrashFolder(int accountId) throws OXException {
        if (this.isDefaultFoldersChecked(accountId)) {
            return MailFolderUtility.prepareFullname(accountId, this.getDefaultMailFolder(3, accountId));
        }
        this.initConnection(accountId);
        return MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().getTrashFolder());
    }

    @Override
    public int getUnreadMessageCount(String folder) throws OXException {
        int retval;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        String fullName = argument.getFullname();
        if (!this.init) {
            this.mailAccess = MailAccess.getInstance(this.session, accountId);
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
            this.init = true;
        } else if (accountId != this.mailAccess.getAccountId()) {
            this.mailAccess.close(true);
            this.mailAccess = MailAccess.getInstance(this.session, accountId);
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
        } else {
            retval = this.mailAccess.getUnreadMessagesCount(fullName);
        }
        return retval;
    }

    private void initConnection(int accountId) throws OXException {
        if (!this.init) {
            this.mailAccess = this.initMailAccess(accountId);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
            this.init = true;
        } else if (accountId != this.mailAccess.getAccountId()) {
            this.mailAccess.close(true);
            this.mailAccess = this.initMailAccess(accountId);
            this.mailConfig = this.mailAccess.getMailConfig();
            this.accountId = accountId;
        }
    }

    private MailAccess<?, ?> initMailAccess(int accountId) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(this.session, accountId);
        if (!mailAccess.isConnected()) {
            long start = System.currentTimeMillis();
            try {
                mailAccess.connect();
                this.warnings.addAll(mailAccess.getWarnings());
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                MailServletInterface.mailInterfaceMonitor.changeNumSuccessfulLogins(true);
            }
            catch (OXException e) {
                if (MimeMailExceptionCode.LOGIN_FAILED.equals(e) || MimeMailExceptionCode.INVALID_CREDENTIALS.equals(e)) {
                    MailServletInterface.mailInterfaceMonitor.changeNumFailedLogins(true);
                }
                throw e;
            }
        }
        return mailAccess;
    }

    private boolean isDefaultFoldersChecked(int accountId) {
        Boolean b = (Boolean)MailSessionCache.getInstance(this.session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    @Override
    public String saveDraft(ComposedMailMessage draftMail, boolean autosave, int accountId) throws OXException {
        if (autosave) {
            return this.autosaveDraft(draftMail, accountId);
        }
        this.initConnection(accountId);
        String draftFullname = this.mailAccess.getFolderStorage().getDraftsFolder();
        MailMessage draftMessage = this.mailAccess.getMessageStorage().saveDraft(draftFullname, draftMail);
        if (null == draftMessage) {
            return null;
        }
        MailPath mailPath = draftMessage.getMailPath();
        if (null == mailPath) {
            return null;
        }
        String retval = mailPath.toString();
        this.postEvent(accountId, draftFullname, true);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String autosaveDraft(ComposedMailMessage draftMail, int accountId) throws OXException {
        this.initConnection(accountId);
        String draftFullname = this.mailAccess.getFolderStorage().getDraftsFolder();
        if (!draftMail.isDraft()) {
            draftMail.setFlag(4, true);
        }
        MailPath msgref = draftMail.getMsgref();
        MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = null;
        try {
            MailMessage m;
            MailMessage origMail;
            if (null == msgref || !draftFullname.equals(msgref.getFolder())) {
                origMail = null;
            } else {
                if (msgref.getAccountId() == accountId) {
                    origMail = this.mailAccess.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false);
                } else {
                    otherAccess = MailAccess.getInstance(this.session, msgref.getAccountId());
                    otherAccess.connect(true);
                    origMail = otherAccess.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false);
                }
                if (origMail != null) {
                    NonInlineForwardPartHandler handler = new NonInlineForwardPartHandler();
                    new MailMessageParser().parseMailMessage(origMail, handler);
                    List<MailPart> parts = handler.getNonInlineParts();
                    if (!parts.isEmpty()) {
                        TransportProvider tp = TransportProviderRegistry.getTransportProviderBySession(this.session, accountId);
                        for (MailPart mailPart : parts) {
                            draftMail.addEnclosedPart(tp.getNewReferencedPart(mailPart, this.session));
                        }
                    }
                }
            }
            MailMessage filledMail = MimeMessageConverter.fillComposedMailMessage(draftMail);
            filledMail.setFlag(4, true);
            String uid = this.mailAccess.getMessageStorage().appendMessages(draftFullname, new MailMessage[]{filledMail})[0];
            if (null == uid) {
                filledMail = null;
                return filledMail;
            }
            if (origMail != null) {
                if (origMail.isDraft() && null != msgref) {
                    if (msgref.getAccountId() == accountId) {
                        this.mailAccess.getMessageStorage().deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
                    } else if (null != otherAccess) {
                        otherAccess.getMessageStorage().deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
                    }
                }
                draftMail.setMsgref(null);
            }
            if (null == (m = this.mailAccess.getMessageStorage().getMessage(draftFullname, uid, true))) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(Long.valueOf(uid), draftFullname);
            }
            this.postEvent(accountId, draftFullname, true);
            String string = m.getMailPath().toString();
            return string;
        }
        finally {
            if (null != otherAccess) {
                otherAccess.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveFolder(MailFolderDescription mailFolder) throws OXException {
        if (!mailFolder.containsExists() && !mailFolder.containsFullname()) {
            throw MailExceptionCode.INSUFFICIENT_FOLDER_ATTR.create();
        }
        String name = mailFolder.getName();
        if (null != name) {
            MailServletInterfaceImpl.checkFolderName(name);
        }
        if (mailFolder.containsExists() && mailFolder.exists() || mailFolder.getFullname() != null && this.mailAccess.getFolderStorage().exists(mailFolder.getFullname())) {
            String newName;
            String oldName;
            String oldParent;
            int accountId = mailFolder.getAccountId();
            String fullName = mailFolder.getFullname();
            this.initConnection(accountId);
            char separator = mailFolder.getSeparator();
            int pos = fullName.lastIndexOf(separator);
            if (pos == -1) {
                oldParent = "";
                oldName = fullName;
            } else {
                oldParent = fullName.substring(0, pos);
                oldName = fullName.substring(pos + 1);
            }
            boolean movePerformed = false;
            if (mailFolder.containsParentFullname()) {
                int parentAccountID = mailFolder.getParentAccountId();
                if (accountId == parentAccountID) {
                    String newParent = mailFolder.getParentFullname();
                    StringAllocator newFullname = new StringAllocator(newParent).append(mailFolder.getSeparator());
                    if (mailFolder.containsName()) {
                        newFullname.append(mailFolder.getName());
                    } else {
                        newFullname.append(oldName);
                    }
                    if (!newParent.equals(oldParent)) {
                        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
                        fullName = this.mailAccess.getFolderStorage().moveFolder(fullName, newFullname.toString());
                        movePerformed = true;
                        this.postEvent4Subfolders(accountId, subfolders);
                        this.postEvent(accountId, newParent, false);
                    }
                } else {
                    MailAccess<?, ?> otherAccess = this.initMailAccess(parentAccountID);
                    try {
                        String newParent = mailFolder.getParentFullname();
                        MailFolder p = otherAccess.getFolderStorage().getFolder(newParent);
                        MailPermission ownPermission = p.getOwnPermission();
                        if (!ownPermission.canCreateSubfolders()) {
                            throw MailExceptionCode.NO_CREATE_ACCESS.create(newParent);
                        }
                        MailFolder[] tmp = otherAccess.getFolderStorage().getSubfolders(newParent, true);
                        String lookFor = mailFolder.containsName() ? mailFolder.getName() : oldName;
                        for (MailFolder sub : tmp) {
                            if (!sub.getName().equals(lookFor)) continue;
                            throw MailExceptionCode.DUPLICATE_FOLDER.create(lookFor);
                        }
                        String destFullname = MailServletInterfaceImpl.fullCopy(this.mailAccess, fullName, otherAccess, newParent, p.getSeparator(), this.session.getUserId(), otherAccess.getMailConfig().getCapabilities().hasPermissions());
                        this.postEvent(parentAccountID, newParent, false);
                        Map<String, Map<?, ?>> subfolders = this.subfolders(fullName);
                        this.mailAccess.getFolderStorage().deleteFolder(fullName, true);
                        String prepareFullname = MailFolderUtility.prepareFullname(parentAccountID, otherAccess.getFolderStorage().updateFolder(destFullname, mailFolder));
                        this.postEvent4Subfolders(accountId, subfolders);
                        String string = prepareFullname;
                        return string;
                    }
                    finally {
                        otherAccess.close(true);
                    }
                }
            }
            if (!movePerformed && mailFolder.containsName() && !(newName = mailFolder.getName()).equals(oldName)) {
                fullName = this.mailAccess.getFolderStorage().renameFolder(fullName, newName);
                this.postEvent(accountId, fullName, false);
            }
            String prepareFullname = MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().updateFolder(fullName, mailFolder));
            this.postEvent(accountId, fullName, false, true);
            return prepareFullname;
        }
        int accountId = mailFolder.getParentAccountId();
        this.initConnection(accountId);
        String prepareFullname = MailFolderUtility.prepareFullname(accountId, this.mailAccess.getFolderStorage().createFolder(mailFolder));
        this.postEvent(accountId, mailFolder.getParentFullname(), false, true);
        return prepareFullname;
    }

    private static String fullCopy(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> srcAccess, String srcFullname, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> destAccess, String destParent, char destSeparator, int user, boolean hasPermissions) throws OXException {
        MailFolder source = srcAccess.getFolderStorage().getFolder(srcFullname);
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setName(source.getName());
        mfd.setParentFullname(destParent);
        mfd.setSeparator(destSeparator);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            MailPermission[] perms = source.getPermissions();
            try {
                for (int i = 0; i < perms.length; ++i) {
                    mfd.addPermission((MailPermission)perms[i].clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        String destFullname = destAccess.getFolderStorage().createFolder(mfd);
        MailMessage[] msgs = srcAccess.getMessageStorage().getAllMessages(srcFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, FIELDS_FULL);
        IMailMessageStorage destMessageStorage = destAccess.getMessageStorage();
        destMessageStorage.appendMessages(destFullname, msgs);
        MailFolder[] tmp = srcAccess.getFolderStorage().getSubfolders(srcFullname, true);
        for (int i = 0; i < tmp.length; ++i) {
            MailServletInterfaceImpl.fullCopy(srcAccess, tmp[i].getFullname(), destAccess, destFullname, destSeparator, user, hasPermissions);
        }
        return destFullname;
    }

    private static void checkFolderName(String name) throws OXException {
        if (MailServletInterfaceImpl.isEmpty(name)) {
            throw MailExceptionCode.INVALID_FOLDER_NAME_EMPTY.create();
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if (INVALID.indexOf(name.charAt(i)) < 0) continue;
            throw MailExceptionCode.INVALID_FOLDER_NAME2.create(name);
        }
    }

    @Override
    public void sendFormMail(ComposedMailMessage composedMail, int groupId, int accountId) throws OXException {
        this.initConnection(accountId);
        MailTransport transport = MailTransport.getInstance(this.session, accountId);
        try {
            GroupStorage gs = GroupStorage.getInstance();
            Group group = gs.getGroup(groupId, this.ctx);
            int[] members = group.getMember();
            UserStorage us = UserStorage.getInstance();
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            String content = (String)composedMail.getContent();
            StringBuilder builder = new StringBuilder(content.length() + 64);
            TransportProvider provider = TransportProviderRegistry.getTransportProviderBySession(this.session, accountId);
            HashMap<Locale, String> greetings = new HashMap<Locale, String>(4);
            for (int userId : members) {
                User user = us.getUser(userId, this.ctx);
                Contact contact = contactService.getUser(this.session, userId, new ContactField[]{ContactField.SUR_NAME, ContactField.GIVEN_NAME});
                Locale locale = user.getLocale();
                String greeting = (String)greetings.get(locale);
                if (null == greeting) {
                    greeting = StringHelper.valueOf(locale).getString("Dear Sir or Madam");
                    greetings.put(locale, greeting);
                }
                builder.setLength(0);
                builder.append(greeting).append(' ');
                builder.append(contact.getGivenName()).append(' ').append(contact.getSurName());
                builder.append("<br><br>").append(content);
                TextBodyMailPart part = provider.getNewTextBodyPart(builder.toString());
                composedMail.setBodyPart(part);
                composedMail.removeTo();
                composedMail.removeBcc();
                composedMail.removeCc();
                composedMail.addTo(new QuotedInternetAddress(user.getMail()));
                MailProperties properties = MailProperties.getInstance();
                if (properties.getRateLimitPrimaryOnly() && 0 == accountId || !properties.getRateLimitPrimaryOnly()) {
                    int rateLimit = properties.getRateLimit();
                    this.rateLimitChecks(composedMail, rateLimit, properties.getMaxToCcBcc());
                    transport.sendMailMessage(composedMail, ComposeType.NEW);
                    this.setRateLimitTime(rateLimit);
                    continue;
                }
                transport.sendMailMessage(composedMail, ComposeType.NEW);
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        finally {
            transport.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendMessage(ComposedMailMessage composedMail, ComposeType type, int accountId) throws OXException {
        this.initConnection(accountId);
        MailTransport transport = MailTransport.getInstance(this.session, accountId);
        boolean mailSent = false;
        try {
            String string;
            MailMessage sentMail;
            block31: {
                long startTransport = System.currentTimeMillis();
                MailProperties properties = MailProperties.getInstance();
                if (properties.getRateLimitPrimaryOnly() && 0 == accountId || !properties.getRateLimitPrimaryOnly()) {
                    int rateLimit = properties.getRateLimit();
                    this.rateLimitChecks(composedMail, rateLimit, properties.getMaxToCcBcc());
                    sentMail = transport.sendMailMessage(composedMail, type);
                    this.setRateLimitTime(rateLimit);
                } else {
                    sentMail = transport.sendMailMessage(composedMail, type);
                }
                mailSent = true;
                DataRetentionService retentionService = ServerServiceRegistry.getInstance().getService(DataRetentionService.class);
                if (null != retentionService) {
                    this.triggerDataRetention(transport, startTransport, sentMail, retentionService);
                }
                try {
                    if (ComposeType.REPLY.equals((Object)type)) {
                        this.setFlagReply(composedMail.getMsgref());
                        break block31;
                    }
                    if (ComposeType.FORWARD.equals((Object)type)) {
                        MailPath supPath = composedMail.getMsgref();
                        if (null == supPath) {
                            int count = composedMail.getEnclosedCount();
                            ArrayList<MailPath> paths = new ArrayList<MailPath>(count);
                            for (int i = 0; i < count; ++i) {
                                MailPart part = composedMail.getEnclosedMailPart(i);
                                MailPath path = part.getMsgref();
                                if (path == null || !part.getContentType().isMimeType("message/rfc822")) continue;
                                paths.add(path);
                            }
                            if (!paths.isEmpty()) {
                                this.setFlagMultipleForward(paths);
                            }
                        } else {
                            this.setFlagForward(supPath);
                        }
                        break block31;
                    }
                    if (ComposeType.DRAFT.equals((Object)type)) {
                        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
                        if (null == configViewFactory) break block31;
                        try {
                            ConfigView view = configViewFactory.getView(this.session.getUserId(), this.session.getContextId());
                            ComposedConfigProperty property = view.property("com.openexchange.mail.deleteDraftOnTransport", Boolean.TYPE);
                            if (property.isDefined() && ((Boolean)property.get()).booleanValue()) {
                                this.deleteDraft(composedMail.getMsgref());
                            }
                            break block31;
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Draft mail cannot be deleted.", (Throwable)e);
                        }
                        break block31;
                    }
                    if (ComposeType.DRAFT_DELETE_ON_TRANSPORT.equals((Object)type)) {
                        try {
                            this.deleteDraft(composedMail.getMsgref());
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Draft mail cannot be deleted.", (Throwable)e);
                        }
                    }
                }
                catch (OXException e) {
                    this.mailAccess.addWarnings(Collections.singletonList(MailExceptionCode.FLAG_FAIL.create(e, new Object[0])));
                }
            }
            if (UserSettingMailStorage.getInstance().getUserSettingMail(this.session.getUserId(), this.ctx).isNoCopyIntoStandardSentFolder()) {
                string = null;
                return string;
            }
            if (null != sentMail.getMailId() && null != sentMail.getFolder()) {
                string = new MailPath(accountId, sentMail.getFolder(), sentMail.getMailId()).toString();
                return string;
            }
            string = this.append2SentFolder(sentMail).toString();
            return string;
        }
        catch (OXException e) {
            if (!mailSent) {
                throw e;
            }
            e.setCategory(Category.CATEGORY_WARNING);
            this.warnings.add(e);
            String string = null;
            return string;
        }
        catch (RuntimeException e) {
            OXException oxe = MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            if (!mailSent) {
                throw oxe;
            }
            oxe.setCategory(Category.CATEGORY_WARNING);
            this.warnings.add(oxe);
            String string = null;
            return string;
        }
        finally {
            transport.close();
        }
    }

    private void triggerDataRetention(final MailTransport transport, final long startTransport, final MailMessage sentMail, final DataRetentionService retentionService) {
        final Session s = this.session;
        final org.apache.commons.logging.Log l = LOG;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    RetentionData retentionData = retentionService.newInstance();
                    retentionData.setStartTime(new Date(startTransport));
                    retentionData.setIdentifier(transport.getTransportConfig().getLogin());
                    retentionData.setIPAddress(s.getLocalIp());
                    retentionData.setSenderAddress(IDNA.toIDN((String)sentMail.getFrom()[0].getAddress()));
                    HashSet<InternetAddress> recipients = new HashSet<InternetAddress>(Arrays.asList(sentMail.getTo()));
                    recipients.addAll(Arrays.asList(sentMail.getCc()));
                    recipients.addAll(Arrays.asList(sentMail.getBcc()));
                    int size = recipients.size();
                    String[] recipientsArr = new String[size];
                    Iterator it = recipients.iterator();
                    for (int i = 0; i < size; ++i) {
                        recipientsArr[i] = IDNA.toIDN((String)((InternetAddress)it.next()).getAddress());
                    }
                    retentionData.setRecipientAddresses(recipientsArr);
                    retentionService.storeOnTransport(retentionData);
                }
                catch (OXException e) {
                    l.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            r.run();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), CallerRunsBehavior.getInstance());
        }
    }

    private MailPath append2SentFolder(MailMessage sentMail) throws OXException {
        String[] uidArr;
        long start = System.currentTimeMillis();
        String sentFullname = this.mailAccess.getFolderStorage().getSentFolder();
        try {
            uidArr = this.mailAccess.getMessageStorage().appendMessages(sentFullname, new MailMessage[]{sentMail});
            try {
                MailMessageCache.getInstance().removeFolderMessages(this.mailAccess.getAccountId(), sentFullname, this.session.getUserId(), this.contextId);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (OXException e) {
            if (e.getMessage().indexOf("quota") != -1) {
                throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
            }
            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
        }
        if (uidArr != null && uidArr[0] != null) {
            this.mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
        }
        MailPath retval = new MailPath(this.mailAccess.getAccountId(), sentFullname, uidArr[0]);
        if (DEBUG_ENABLED) {
            LOG.debug((Object)new StringAllocator(128).append("Mail copy (").append(retval.toString()).append(") appended in ").append(System.currentTimeMillis() - start).append("msec").toString());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagForward(MailPath path) throws OXException {
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().updateMessageFlags(fullName, uids, 256, true);
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(uids, this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(fullName, uids, 256, true);
                try {
                    if (MailMessageCache.getInstance().containsFolderMessages(otherAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                        MailMessageCache.getInstance().updateCachedMessages(uids, otherAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagMultipleForward(List<MailPath> paths) throws OXException {
        String[] ids = new String[1];
        for (MailPath path : paths) {
            ids[0] = path.getMailID();
            int pathAccount = path.getAccountId();
            if (this.mailAccess.getAccountId() == pathAccount) {
                this.mailAccess.getMessageStorage().updateMessageFlags(path.getFolder(), ids, 256, true);
                try {
                    if (!MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId)) continue;
                    MailMessageCache.getInstance().updateCachedMessages(ids, this.mailAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(path.getFolder(), ids, 256, true);
                try {
                    if (!MailMessageCache.getInstance().containsFolderMessages(otherAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId)) continue;
                    MailMessageCache.getInstance().updateCachedMessages(ids, otherAccess.getAccountId(), path.getFolder(), this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{256});
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDraft(MailPath path) throws OXException {
        if (null == path) {
            LOG.warn((Object)"Missing msgref on draft-delete. Corresponding draft mail cannot be deleted.", new Throwable());
            return;
        }
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().deleteMessages(fullName, uids, true);
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = null;
            try {
                otherAccess = MailAccess.getInstance(this.session, pathAccount);
                otherAccess.connect(true);
                otherAccess.getMessageStorage().deleteMessages(fullName, uids, true);
                try {
                    MailMessageCache.getInstance().removeMessages(uids, pathAccount, fullName, this.session.getUserId(), this.session.getContextId());
                }
                catch (OXException e) {
                    // empty catch block
                }
            }
            finally {
                if (null != otherAccess) {
                    otherAccess.close(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlagReply(MailPath path) throws OXException {
        if (null == path) {
            LOG.warn((Object)"Missing msgref on reply. Corresponding mail cannot be marked as answered.", new Throwable());
            return;
        }
        String fullName = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        int pathAccount = path.getAccountId();
        if (this.mailAccess.getAccountId() == pathAccount) {
            this.mailAccess.getMessageStorage().updateMessageFlags(fullName, uids, 1, true);
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(uids, this.mailAccess.getAccountId(), fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{1});
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = MailAccess.getInstance(this.session, pathAccount);
            otherAccess.connect(true);
            try {
                otherAccess.getMessageStorage().updateMessageFlags(fullName, uids, 1, true);
                try {
                    if (MailMessageCache.getInstance().containsFolderMessages(pathAccount, fullName, this.session.getUserId(), this.contextId)) {
                        MailMessageCache.getInstance().updateCachedMessages(uids, pathAccount, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{1});
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            finally {
                otherAccess.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V performSynchronized(Callable<V> task, Session session) throws Exception {
        Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
        if (null == lock) {
            lock = Session.EMPTY_LOCK;
        }
        lock.lock();
        try {
            V v = task.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private void setRateLimitTime(int rateLimit) {
        if (rateLimit > 0) {
            this.session.setParameter(LAST_SEND_TIME, (Object)System.currentTimeMillis());
        }
    }

    private void rateLimitChecks(MailMessage composedMail, int rateLimit, int maxToCcBcc) throws OXException {
        Long parameter;
        if (rateLimit > 0 && null != (parameter = (Long)this.session.getParameter(LAST_SEND_TIME)) && parameter + (long)rateLimit >= System.currentTimeMillis()) {
            NumberFormat numberInstance = NumberFormat.getNumberInstance(UserStorage.getStorageUser(this.session.getUserId(), this.session.getContextId()).getLocale());
            throw MailExceptionCode.SENT_QUOTA_EXCEEDED.create(numberInstance.format((double)rateLimit / 1000.0));
        }
        if (maxToCcBcc > 0) {
            InternetAddress[] addrs = composedMail.getTo();
            int count = addrs == null ? 0 : addrs.length;
            addrs = composedMail.getCc();
            count += addrs == null ? 0 : addrs.length;
            addrs = composedMail.getBcc();
            if ((count += addrs == null ? 0 : addrs.length) > maxToCcBcc) {
                throw MailExceptionCode.RECIPIENTS_EXCEEDED.create(maxToCcBcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendReceiptAck(String folder, String msgUID, String fromAddr) throws OXException {
        int acc;
        FullnameArgument argument;
        block12: {
            argument = MailFolderUtility.prepareMailFolderParam(folder);
            acc = argument.getAccountId();
            try {
                MailAccountStorageService ss = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
                MailAccount ma = ss.getMailAccount(acc, this.session.getUserId(), this.session.getContextId());
                if (ma.isDefaultAccount()) {
                    try {
                        String[] aliases;
                        HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                        if (this.usm.getSendAddr() != null && this.usm.getSendAddr().length() > 0) {
                            validAddrs.add(new QuotedInternetAddress(this.usm.getSendAddr()));
                        }
                        User user = this.getUser();
                        validAddrs.add(new QuotedInternetAddress(user.getMail()));
                        for (String alias : aliases = user.getAliases()) {
                            validAddrs.add(new QuotedInternetAddress(alias));
                        }
                        if (!validAddrs.contains((Object)new QuotedInternetAddress(fromAddr))) {
                            throw MailExceptionCode.INVALID_SENDER.create(fromAddr);
                        }
                        break block12;
                    }
                    catch (AddressException e) {
                        throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                    }
                }
                if (!new QuotedInternetAddress(ma.getPrimaryAddress()).equals((Object)new QuotedInternetAddress(fromAddr))) {
                    throw MailExceptionCode.INVALID_SENDER.create(fromAddr);
                }
            }
            catch (AddressException e) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
        }
        this.initConnection(acc);
        String fullName = argument.getFullname();
        MailTransport transport = MailTransport.getInstance(this.session);
        try {
            transport.sendReceiptAck(this.mailAccess.getMessageStorage().getMessage(fullName, msgUID, false), fromAddr);
        }
        finally {
            transport.close();
        }
        this.mailAccess.getMessageStorage().updateMessageFlags(fullName, new String[]{msgUID}, 512, true);
    }

    @Override
    public void updateMessageColorLabel(String folder, String[] mailIDs, int newColorLabel) throws OXException {
        String[] ids;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        if (null == mailIDs) {
            if (messageStorage instanceof IMailMessageStorageBatch) {
                IMailMessageStorageBatch batch = (IMailMessageStorageBatch)messageStorage;
                ids = null;
                batch.updateMessageColorLabel(fullName, newColorLabel);
            } else {
                ids = this.getAllMessageIDs(argument);
                messageStorage.updateMessageColorLabel(fullName, ids, newColorLabel);
            }
        } else {
            ids = mailIDs;
            messageStorage.updateMessageColorLabel(fullName, ids, newColorLabel);
        }
        this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true, false, MORE_PROPS_UPDATE_LABEL);
        try {
            if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                MailMessageCache.getInstance().updateCachedMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_COLOR_LABEL, new Object[]{newColorLabel});
            }
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMailIDByMessageID(String folder, String messageID) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] messages = this.mailAccess.getMessageStorage().searchMessages(fullName, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new HeaderTerm("Message-Id", messageID), FIELDS_ID_INFO);
        if (null == messages || 1 != messages.length) {
            throw MailExceptionCode.MAIL_NOT_FOUN_BY_MESSAGE_ID.create(fullName, messageID);
        }
        return messages[0].getMailId();
    }

    @Override
    public void updateMessageFlags(String folder, String[] mailIDs, int flagBits, boolean flagVal) throws OXException {
        boolean spamAction;
        String[] ids;
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        IMailMessageStorage messageStorage = this.mailAccess.getMessageStorage();
        if (null == mailIDs) {
            if (messageStorage instanceof IMailMessageStorageBatch) {
                IMailMessageStorageBatch batch = (IMailMessageStorageBatch)messageStorage;
                ids = null;
                batch.updateMessageFlags(fullName, flagBits, flagVal);
            } else {
                ids = this.getAllMessageIDs(argument);
                messageStorage.updateMessageFlags(fullName, ids, flagBits, flagVal);
            }
        } else {
            ids = mailIDs;
            messageStorage.updateMessageFlags(fullName, ids, flagBits, flagVal);
        }
        this.postEvent("com/openexchange/push/attributes", accountId, fullName, true, true, false, MORE_PROPS_UPDATE_FLAGS);
        boolean bl = spamAction = this.usm.isSpamEnabled() && (flagBits & 0x80) > 0;
        if (spamAction) {
            String spamFullname = this.mailAccess.getFolderStorage().getSpamFolder();
            this.postEvent("com/openexchange/push/attributes", accountId, spamFullname, true, true);
        }
        if (spamAction) {
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().removeMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId);
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                if (MailMessageCache.getInstance().containsFolderMessages(accountId, fullName, this.session.getUserId(), this.contextId)) {
                    MailMessageCache.getInstance().updateCachedMessages(ids, accountId, fullName, this.session.getUserId(), this.contextId, FIELDS_FLAGS, new Object[]{flagVal ? flagBits : flagBits * -1});
                }
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public MailMessage[] getUpdatedMessages(String folder, int[] fields) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getNewAndModifiedMessages(fullName, MailField.getFields(fields));
    }

    @Override
    public MailMessage[] getDeletedMessages(String folder, int[] fields) throws OXException {
        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder);
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        return this.mailAccess.getMessageStorage().getDeletedMessages(fullName, MailField.getFields(fields));
    }

    private static String[] messages2ids(MailMessage[] messages) {
        if (null == messages) {
            return null;
        }
        String[] retval = new String[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            retval[i] = messages[i].getMailId();
        }
        return retval;
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated) {
        this.postEvent(accountId, fullName, contentRelated, false);
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, this.session));
    }

    private void postEvent(int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, this.session).setAsync(async));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, this.session));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, this.session);
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    private void postEvent(String topic, int accountId, String fullName, boolean contentRelated, boolean immediateDelivery, boolean async, Map<String, Object> moreProperties) {
        if (0 != accountId) {
            return;
        }
        PooledEvent pooledEvent = new PooledEvent(topic, this.contextId, this.session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullName), contentRelated, immediateDelivery, this.session);
        if (null != moreProperties) {
            for (Map.Entry<String, Object> entry : moreProperties.entrySet()) {
                pooledEvent.putProperty(entry.getKey(), entry.getValue());
            }
        }
        EventPool.getInstance().put(pooledEvent.setAsync(async));
    }

    @Override
    public MailImportResult[] getMailImportResults() {
        MailImportResult[] mars = new MailImportResult[this.mailImportResults.size()];
        for (int i = 0; i < mars.length; ++i) {
            mars[i] = this.mailImportResults.get(i);
        }
        return mars;
    }

    private String[] getAllMessageIDs(FullnameArgument argument) throws OXException {
        int accountId = argument.getAccountId();
        this.initConnection(accountId);
        String fullName = argument.getFullname();
        MailMessage[] mails = this.mailAccess.getMessageStorage().searchMessages(fullName, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, null, FIELDS_ID_INFO);
        if (mails == null || mails.length == 0) {
            return new String[0];
        }
        String[] ret = new String[mails.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = mails[i].getMailId();
        }
        return ret;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>(1, 1.0f);
        m.put("operation", "updateMessageColorLabel");
        MORE_PROPS_UPDATE_LABEL = Collections.unmodifiableMap(m);
        m = new HashMap(1, 1.0f);
        m.put("operation", "updateMessageFlags");
        MORE_PROPS_UPDATE_FLAGS = Collections.unmodifiableMap(m);
    }

    private static final class SimpleMailFolderComparator
    implements Comparator<MailFolder> {
        private final Collator collator;

        public SimpleMailFolderComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class MailFolderComparator
    implements Comparator<MailFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        public MailFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getFullname()).compareTo(this.getNumberOf(o2.getFullname()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }
}

