/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.replacement.AbstractMultipleDateReplacement;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractFormatMultipleDateReplacement
extends AbstractMultipleDateReplacement {
    protected String format;
    protected String fallback;

    protected AbstractFormatMultipleDateReplacement(Date[] dates, String format) {
        super(dates);
        this.format = format;
    }

    public AbstractFormatMultipleDateReplacement(Date[] dates, String format, Locale locale, TimeZone timeZone) {
        super(dates, locale, timeZone);
        this.format = format;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public String getReplacement() {
        String result;
        String dateRepl = super.getReplacement();
        if ((this.dates == null || dateRepl.length() == 0) && this.fallback != null) {
            StringHelper sh = StringHelper.valueOf(this.locale == null ? Locale.ENGLISH : this.locale);
            result = String.format(sh.getString(this.format), sh.getString(this.fallback));
        } else {
            result = String.format(StringHelper.valueOf(this.locale == null ? Locale.ENGLISH : this.locale).getString(this.format), dateRepl);
        }
        if (this.changed) {
            return new StringBuilder("* ".length() + result.length()).append("* ").append(result).toString();
        }
        return result;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!AbstractFormatMultipleDateReplacement.class.isInstance(other)) {
            return false;
        }
        if (super.merge(other)) {
            AbstractFormatMultipleDateReplacement o = (AbstractFormatMultipleDateReplacement)other;
            this.format = o.format;
            this.fallback = o.fallback;
            return true;
        }
        return false;
    }
}

