/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public class CachingUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CachingUserConfigurationStorage.class));
    private static final String CACHE_REGION_NAME = "UserConfiguration";
    private final CacheAvailabilityListener cacheAvailabilityListener;
    private final transient UserConfigurationStorage delegateStorage;
    private final Lock cacheWriteLock = new ReentrantLock();
    private volatile Cache cache;
    private volatile UserConfigurationStorage fallback;

    public CachingUserConfigurationStorage() throws OXException {
        this.delegateStorage = new RdbUserConfigurationStorage();
        this.cacheAvailabilityListener = new CacheAvailabilityListener(){

            @Override
            public void handleAbsence() throws OXException {
                CachingUserConfigurationStorage.this.releaseCache();
            }

            @Override
            public void handleAvailability() throws OXException {
                CachingUserConfigurationStorage.this.initCache();
            }
        };
        this.initCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserConfigurationStorage getFallback() {
        UserConfigurationStorage fallback = this.fallback;
        if (null == fallback) {
            CachingUserConfigurationStorage cachingUserConfigurationStorage = this;
            synchronized (cachingUserConfigurationStorage) {
                fallback = this.fallback;
                if (null == fallback) {
                    this.fallback = fallback = new RdbUserConfigurationStorage();
                }
            }
        }
        return fallback;
    }

    @Override
    protected void startInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg && !reg.registerListener(this.cacheAvailabilityListener)) {
            LOG.error((Object)"Cache availability listener could not be registered", new Throwable());
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this.cacheAvailabilityListener);
        }
        this.releaseCache();
    }

    private static final CacheKey getKey(int userId, Context ctx, Cache cache) {
        return cache.newCacheKey(ctx.getContextId(), userId);
    }

    private static final CacheKey getKey(Cache cache, Context ctx, int userId, boolean extendedPermissions) {
        return cache.newCacheKey(ctx.getContextId(), new Serializable[]{Autoboxing.I((int)userId), Autoboxing.B((boolean)extendedPermissions)});
    }

    void initCache() throws OXException {
        if (this.cache != null) {
            return;
        }
        try {
            this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
    }

    void releaseCache() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CACHE_REGION_NAME);
            }
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx, boolean initExtendedPermissions) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(userId, groups, ctx, initExtendedPermissions);
        }
        UserConfiguration userConfig = initExtendedPermissions ? this.getUserConfiguration(cache, ctx, userId, groups) : this.getUserConfigurationWithoutExtended(cache, ctx, userId, groups);
        if (null == userConfig) {
            return this.getFallback().getUserConfiguration(userId, groups, ctx, initExtendedPermissions);
        }
        return userConfig;
    }

    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(ctx, users);
        }
        int[] userIds = new int[users.length];
        for (int i = 0; i < users.length; ++i) {
            userIds[i] = users[i].getId();
        }
        TIntObjectMap<UserConfiguration> map = CachingUserConfigurationStorage.getCachedUserConfiguration(cache, ctx, userIds, true);
        TIntArrayList toLoad = new TIntArrayList(users.length - map.size());
        ArrayList<int[]> groupsToLoad = new ArrayList<int[]>(users.length - map.size());
        for (User user : users) {
            if (map.containsKey(user.getId())) continue;
            toLoad.add(user.getId());
            groupsToLoad.add(user.getGroups());
        }
        this.loadUserConfiguration(cache, map, ctx, toLoad.toArray(), (int[][])groupsToLoad.toArray((T[])new int[groupsToLoad.size()][]), true);
        return CachingUserConfigurationStorage.convert(map, userIds);
    }

    @Override
    UserConfiguration[] getUserConfigurationWithoutExtended(Context ctx, int[] userIds, int[][] groups) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfigurationWithoutExtended(ctx, userIds, groups);
        }
        return this.getUserConfigurationWithoutExtended(cache, ctx, userIds, groups);
    }

    private UserConfiguration getUserConfiguration(Cache cache, Context ctx, int userId, int[] groups) throws OXException {
        return this.getUserConfiguration(cache, ctx, new int[]{userId}, new int[][]{groups})[0];
    }

    private UserConfiguration getUserConfigurationWithoutExtended(Cache cache, Context ctx, int userId, int[] groups) throws OXException {
        UserConfiguration[] ret = this.getUserConfigurationWithoutExtended(cache, ctx, new int[]{userId}, new int[][]{groups});
        return null == ret || 0 == ret.length ? null : ret[0];
    }

    private static TIntObjectMap<UserConfiguration> getCachedUserConfiguration(Cache cache, Context ctx, int[] userIds, boolean extendedPermissions) {
        TIntObjectHashMap map = new TIntObjectHashMap(userIds.length, 1.0f);
        for (int i = 0; i < userIds.length; ++i) {
            CacheKey key = extendedPermissions ? CachingUserConfigurationStorage.getKey(userIds[i], ctx, cache) : CachingUserConfigurationStorage.getKey(cache, ctx, userIds[i], false);
            UserConfiguration userConfig = (UserConfiguration)cache.get((Serializable)key);
            if (null == userConfig) continue;
            map.put(userIds[i], (Object)userConfig.clone());
        }
        return map;
    }

    private static UserConfiguration[] convert(TIntObjectMap<UserConfiguration> map, int[] userIds) {
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>(map.size());
        for (int userId : userIds) {
            UserConfiguration userConfiguration = (UserConfiguration)map.get(userId);
            if (null == userConfiguration) continue;
            retval.add(userConfiguration.clone());
        }
        return retval.toArray(new UserConfiguration[map.size()]);
    }

    private UserConfiguration[] getUserConfigurationWithoutExtended(Cache cache, Context ctx, int[] userIds, int[][] groups) throws OXException {
        TIntObjectMap<UserConfiguration> map = CachingUserConfigurationStorage.getCachedUserConfiguration(cache, ctx, userIds, false);
        TIntArrayList toLoad = new TIntArrayList(userIds.length - map.size());
        ArrayList<int[]> groupsToLoad = new ArrayList<int[]>(userIds.length - map.size());
        for (int i = 0; i < userIds.length; ++i) {
            if (map.containsKey(userIds[i])) continue;
            toLoad.add(userIds[i]);
            groupsToLoad.add(groups[i]);
        }
        this.loadUserConfiguration(cache, map, ctx, toLoad.toArray(), (int[][])groupsToLoad.toArray((T[])new int[groupsToLoad.size()][]), false);
        return CachingUserConfigurationStorage.convert(map, userIds);
    }

    private UserConfiguration[] getUserConfiguration(Cache cache, Context ctx, int[] userIds, int[][] groups) throws OXException {
        TIntObjectMap<UserConfiguration> map = CachingUserConfigurationStorage.getCachedUserConfiguration(cache, ctx, userIds, true);
        TIntArrayList toLoad = new TIntArrayList(userIds.length - map.size());
        ArrayList<int[]> groupsToLoad = new ArrayList<int[]>(userIds.length - map.size());
        for (int i = 0; i < userIds.length; ++i) {
            if (map.containsKey(userIds[i])) continue;
            toLoad.add(userIds[i]);
            groupsToLoad.add(groups[i]);
        }
        this.loadUserConfiguration(cache, map, ctx, toLoad.toArray(), (int[][])groupsToLoad.toArray((T[])new int[groupsToLoad.size()][]), true);
        return CachingUserConfigurationStorage.convert(map, userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserConfiguration(Cache cache, TIntObjectMap<UserConfiguration> map, Context ctx, int[] userIds, int[][] groups, boolean extendedPermissions) throws OXException {
        if (null == userIds || 0 == userIds.length) {
            return;
        }
        UserConfiguration[] loaded = extendedPermissions ? this.getUserConfigurationWithoutExtended(cache, ctx, userIds, groups) : this.delegateStorage.getUserConfigurationWithoutExtended(ctx, userIds, groups);
        if (null == loaded) {
            return;
        }
        for (UserConfiguration userConfig : loaded) {
            CacheKey key;
            int userId = userConfig.getUserId();
            if (extendedPermissions) {
                userConfig.setExtendedPermissions(userConfig.calcExtendedPermissions());
                key = CachingUserConfigurationStorage.getKey(userId, ctx, cache);
            } else {
                key = CachingUserConfigurationStorage.getKey(cache, ctx, userId, false);
            }
            this.cacheWriteLock.lock();
            try {
                cache.put((Serializable)key, (Serializable)userConfig, false);
            }
            catch (RuntimeException e) {
                LOG.warn((Object)("Failed to add user configuration for context " + ctx.getContextId() + " and user " + userId + " to cache."), (Throwable)e);
            }
            finally {
                this.cacheWriteLock.unlock();
            }
            map.put(userId, (Object)userConfig.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            cache.clear();
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserConfiguration(int userId, Context ctx) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        CacheKey key = CachingUserConfigurationStorage.getKey(userId, ctx, cache);
        CacheKey keyWithoutExtended = CachingUserConfigurationStorage.getKey(cache, ctx, userId, false);
        this.cacheWriteLock.lock();
        try {
            cache.remove((Serializable)key);
            cache.remove((Serializable)keyWithoutExtended);
        }
        catch (RuntimeException e) {
            LOG.warn((Object)("Failed to remove user configuration for context " + ctx.getContextId() + " and user " + userId + " to cache."), (Throwable)e);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    @Override
    public void saveUserConfiguration(int permissionBits, int userId, Context ctx) throws OXException {
        this.delegateStorage.saveUserConfiguration(permissionBits, userId, ctx);
        this.removeUserConfiguration(userId, ctx);
    }
}

