/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CreateSubscribeTableTask
implements UpdateTask {
    private final String CREATE_TABLE_SUBSCRIPTIONS = "CREATE TABLE subscriptions (cid INT4 UNSIGNED NOT NULL,id INT4 UNSIGNED NOT NULL,user_id INT4 UNSIGNED NOT NULL,configuration_id INT4 UNSIGNED NOT NULL,source_id VARCHAR(255) NOT NULL,folder_id VARCHAR(255) NOT NULL,last_update INT8 UNSIGNED NOT NULL,PRIMARY KEY (cid,id),FOREIGN KEY (cid,user_id) REFERENCES user(cid,id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private final String CREATE_TABEL_SEQUENCE_SUBSCRIPTIONS = "CREATE TABLE sequence_subscriptions (cid INT4 UNSIGNED NOT NULL,id INT4 UNSIGNED NOT NULL,PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    private final String INSERT_IN_SEQUENCE = "INSERT INTO sequence_subscriptions (cid, id) VALUES (?, 0)";

    @Override
    public int addedWithVersion() {
        return 46;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = null;
        try {
            con = Database.getNoTimeout(contextId, true);
            if (!Tools.tableExists(con, "subscriptions")) {
                Tools.exec(con, "CREATE TABLE subscriptions (cid INT4 UNSIGNED NOT NULL,id INT4 UNSIGNED NOT NULL,user_id INT4 UNSIGNED NOT NULL,configuration_id INT4 UNSIGNED NOT NULL,source_id VARCHAR(255) NOT NULL,folder_id VARCHAR(255) NOT NULL,last_update INT8 UNSIGNED NOT NULL,PRIMARY KEY (cid,id),FOREIGN KEY (cid,user_id) REFERENCES user(cid,id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci", new Object[0]);
            }
            if (!Tools.tableExists(con, "sequence_subscriptions")) {
                Tools.exec(con, "CREATE TABLE sequence_subscriptions (cid INT4 UNSIGNED NOT NULL,id INT4 UNSIGNED NOT NULL,PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;", new Object[0]);
            }
            for (int ctxId : Tools.getContextIDs(con)) {
                if (Tools.hasSequenceEntry("sequence_subscriptions", con, ctxId)) continue;
                Tools.exec(con, "INSERT INTO sequence_subscriptions (cid, id) VALUES (?, 0)", ctxId);
            }
        }
        catch (SQLException e) {
            throw CreateSubscribeTableTask.createSQLError(e);
        }
        finally {
            if (con != null) {
                Database.backNoTimeout(contextId, true, con);
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

