/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tools.iterator;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.caching.ElementAttributes;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.permissionLoader.PermissionLoaderService;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;

public class FolderObjectIterator
implements SearchIterator<FolderObject> {
    protected static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FolderObjectIterator.class));
    public static final FolderObjectIterator EMPTY_FOLDER_ITERATOR = new FolderObjectIterator(){

        @Override
        public boolean hasNext() throws OXException {
            return false;
        }

        @Override
        public FolderObject next() throws OXException {
            return null;
        }

        @Override
        public void close() throws OXException {
        }

        @Override
        public int size() {
            return -1;
        }

        @Override
        public boolean hasSize() {
            return true;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public OXException[] getWarnings() {
            return null;
        }

        @Override
        public void addWarning(OXException warning) {
        }
    };
    private final boolean dbGrouping = OXFolderProperties.isEnableDBGrouping();
    private FolderCacheManager cache;
    private final Queue<FolderObject> prefetchQueue;
    private boolean isClosed;
    private final boolean closeCon;
    private final TIntSet folderIds;
    private FolderObject next;
    private Statement stmt;
    private ResultSet rs;
    private Connection readCon;
    private final Context ctx;
    private ElementAttributes attribs;
    private final boolean resideInCache;
    private final boolean containsPermissions;
    private final HashMap<Integer, FolderObject> folders;
    private final List<OXException> warnings;
    private FolderObject future;
    private final PermissionLoaderService permissionLoader;
    private static final String[] selectFields = new String[]{"fuid", "parent", "fname", "module", "type", "creating_date", "created_from", "changing_date", "changed_from", "permission_flag", "subfolder_flag", "default_flag"};
    private static final String[] selectFieldsPerm = new String[]{"permission_id", "fp", "orp", "owp", "odp", "admin_flag", "group_flag", "system"};
    private static final String SQL_LOAD_P = "SELECT permission_id, fp, orp, owp, odp, admin_flag, group_flag, system FROM oxfolder_permissions WHERE cid = ? AND fuid = ?";
    private static final String SQL_LOAD_P_BACKUP = "SELECT permission_id, fp, orp, owp, odp, admin_flag, group_flag, system FROM del_oxfolder_permissions WHERE cid = ? AND fuid = ?";

    public static final String getFieldsForSQL(String tableAlias) {
        StringBuilder fields = new StringBuilder(128);
        String delim = ", ";
        if (tableAlias != null) {
            String prefix = fields.append(tableAlias).append('.').toString();
            fields.setLength(0);
            fields.append(prefix).append(selectFields[0]);
            for (int i = 1; i < selectFields.length; ++i) {
                fields.append(", ").append(prefix).append(selectFields[i]);
            }
        } else {
            fields.append(selectFields[0]);
            for (int i = 1; i < selectFields.length; ++i) {
                fields.append(", ").append(selectFields[i]);
            }
        }
        return fields.toString();
    }

    public static final String getFieldsForSQLWithPermissions(String folderAlias, String permAlias) {
        int i;
        StringBuilder fields = new StringBuilder(256);
        String delim = ", ";
        if (permAlias != null) {
            String prefix = fields.append(permAlias).append('.').toString();
            fields.setLength(0);
            fields.append(prefix).append(selectFieldsPerm[0]);
            for (i = 1; i < selectFieldsPerm.length; ++i) {
                fields.append(", ").append(prefix).append(selectFieldsPerm[i]);
            }
        } else {
            fields.append(selectFieldsPerm[0]);
            for (int i2 = 1; i2 < selectFieldsPerm.length; ++i2) {
                fields.append(", ").append(selectFieldsPerm[i2]);
            }
        }
        String permFields = fields.toString();
        fields.setLength(0);
        if (folderAlias != null) {
            String prefix = fields.append(folderAlias).append('.').toString();
            fields.setLength(0);
            fields.append(prefix).append(selectFields[0]);
            for (int i3 = 1; i3 < selectFields.length; ++i3) {
                fields.append(", ").append(prefix).append(selectFields[i3]);
            }
        } else {
            fields.append(selectFields[0]);
            for (i = 1; i < selectFields.length; ++i) {
                fields.append(", ").append(selectFields[i]);
            }
        }
        return fields.append(", ").append(permFields).toString();
    }

    FolderObjectIterator() {
        FolderCacheManager manager;
        try {
            manager = FolderCacheManager.isInitialized() ? FolderCacheManager.getInstance() : null;
        }
        catch (OXException e) {
            manager = null;
        }
        this.cache = manager;
        this.closeCon = false;
        this.resideInCache = false;
        this.containsPermissions = false;
        this.ctx = null;
        this.prefetchQueue = null;
        this.folderIds = null;
        this.folders = null;
        this.warnings = new ArrayList<OXException>(2);
        this.permissionLoader = null;
    }

    public FolderObjectIterator(Collection<FolderObject> col, boolean resideInCache) {
        FolderCacheManager manager;
        try {
            manager = FolderCacheManager.isInitialized() ? FolderCacheManager.getInstance() : null;
        }
        catch (OXException e) {
            manager = null;
        }
        this.cache = manager;
        this.folderIds = null;
        this.folders = null;
        this.warnings = new ArrayList<OXException>(2);
        this.rs = null;
        this.stmt = null;
        this.ctx = null;
        this.closeCon = false;
        this.containsPermissions = false;
        this.resideInCache = resideInCache;
        if (col == null || col.isEmpty()) {
            this.next = null;
            this.prefetchQueue = null;
        } else {
            this.prefetchQueue = new LinkedList<FolderObject>(col);
            this.next = this.prefetchQueue.poll();
        }
        this.permissionLoader = null;
    }

    public FolderObjectIterator(ResultSet rs, Statement stmt, boolean resideInCache, Context ctx, Connection readCon, boolean closeCon) throws OXException {
        this(rs, stmt, resideInCache, false, ctx, readCon, closeCon);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FolderObjectIterator(ResultSet rs, Statement stmt, boolean resideInCache, boolean containsPermissions, Context ctx, Connection readCon, boolean closeCon) throws OXException {
        FolderCacheManager manager;
        this.folderIds = this.dbGrouping ? null : new TIntHashSet();
        try {
            manager = FolderCacheManager.isInitialized() ? FolderCacheManager.getInstance() : null;
        }
        catch (OXException e) {
            manager = null;
        }
        this.cache = manager;
        this.folders = containsPermissions ? new LinkedHashMap(32) : null;
        this.warnings = new ArrayList<OXException>(2);
        this.rs = rs;
        this.stmt = stmt;
        this.readCon = readCon;
        this.ctx = ctx;
        this.closeCon = closeCon;
        this.resideInCache = resideInCache;
        this.containsPermissions = containsPermissions;
        this.permissionLoader = containsPermissions ? null : PermissionLoaderService.getInstance();
        boolean prefetchEnabled = ServerConfig.getBoolean(ServerConfig.Property.PrefetchEnabled);
        try {
            if (this.rs.next()) {
                this.next = this.createFolderObjectFromSelectedEntry(true);
            } else if (!prefetchEnabled) {
                this.closeResources();
            }
        }
        catch (SQLException e) {
            throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
        }
        if (prefetchEnabled) {
            this.prefetchQueue = new LinkedList<FolderObject>();
            try {
                TIntArrayList tmp = new TIntArrayList();
                while (this.rs.next()) {
                    FolderObject fo = this.createFolderObjectFromSelectedEntry(false);
                    while (fo == null && rs.next()) {
                        fo = this.createFolderObjectFromSelectedEntry(false);
                    }
                    if (null == fo) continue;
                    this.prefetchQueue.offer(fo);
                    tmp.add(fo.getObjectID());
                }
                this.permissionLoader.submitPermissionsFor(ctx.getContextId(), tmp.toArray());
                if (this.future == null) return;
                this.prefetchQueue.offer(this.future);
                this.future = null;
                return;
            }
            catch (SQLException e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
            }
            finally {
                this.closeResources();
            }
        } else {
            this.prefetchQueue = null;
        }
    }

    public FolderObjectIterator releaseCache() {
        this.cache = null;
        return this;
    }

    private final ElementAttributes getEternalAttributes() throws OXException {
        if (this.attribs == null) {
            this.attribs = this.cache.getDefaultFolderObjectAttributes();
            this.attribs.setIdleTime(-1L);
            this.attribs.setMaxLifeSeconds(-1L);
            this.attribs.setIsEternal(true);
        }
        return this.attribs.copy();
    }

    private final FolderObject createFolderObjectFromSelectedEntry(boolean submitPermissions) throws SQLException, OXException {
        FolderObject fo;
        int folderId = this.rs.getInt(1);
        if (this.containsPermissions) {
            Integer key = folderId;
            FolderObject current = this.folders.get(key);
            if (null == current) {
                current = this.createNewFolderObject(folderId);
                this.folders.put(key, current);
                this.addPermissions(folderId, current);
            } else {
                this.addPermissions(folderId, current);
            }
            fo = current;
        } else {
            FolderObject fld;
            if (!this.dbGrouping) {
                if (this.folderIds.contains(folderId)) {
                    return null;
                }
                this.folderIds.add(folderId);
            }
            if (null != this.cache && (fld = this.cache.getFolderObject(folderId, this.ctx)) != null) {
                return fld;
            }
            fo = this.createNewFolderObject(folderId);
            if (submitPermissions) {
                if (null == this.permissionLoader) {
                    fo.setPermissionsAsArray(FolderObjectIterator.loadFolderPermissions(folderId, this.ctx.getContextId(), this.readCon));
                } else {
                    this.permissionLoader.submitPermissionsFor(this.ctx.getContextId(), folderId);
                }
            }
        }
        return fo;
    }

    private FolderObject createNewFolderObject(int folderId) throws SQLException {
        FolderObject fo = new FolderObject(this.rs.getString(3), folderId, this.rs.getInt(4), this.rs.getInt(5), this.rs.getInt(7));
        fo.setParentFolderID(this.rs.getInt(2));
        long tStmp = this.rs.getLong(6);
        if (this.rs.wasNull()) {
            fo.setCreationDate(new Date());
        } else {
            fo.setCreationDate(new Date(tStmp));
        }
        fo.setCreatedBy(this.rs.getInt(7));
        tStmp = this.rs.getLong(8);
        if (this.rs.wasNull()) {
            fo.setLastModified(new Date());
        } else {
            fo.setLastModified(new Date(tStmp));
        }
        fo.setModifiedBy(this.rs.getInt(9));
        fo.setPermissionFlag(this.rs.getInt(10));
        int subfolder = this.rs.getInt(11);
        if (this.rs.wasNull()) {
            subfolder = 0;
        }
        fo.setSubfolderFlag(subfolder > 0);
        int defaultFolder = this.rs.getInt(12);
        if (this.rs.wasNull()) {
            defaultFolder = 0;
        }
        fo.setDefaultFolder(defaultFolder > 0);
        return fo;
    }

    private void addPermissions(int folderId, FolderObject current) throws SQLException {
        boolean hasNext;
        this.future = null;
        this.addNewPermission(current);
        while ((hasNext = this.rs.next()) && folderId == this.rs.getInt(1)) {
            this.addNewPermission(current);
        }
        if (hasNext) {
            int fuid = this.rs.getInt(1);
            this.future = this.createNewFolderObject(fuid);
            this.folders.put(fuid, this.future);
            this.addNewPermission(this.future);
        }
    }

    private void addNewPermission(FolderObject current) throws SQLException {
        OCLPermission p = new OCLPermission();
        p.setEntity(this.rs.getInt(13));
        p.setAllPermission(this.rs.getInt(14), this.rs.getInt(15), this.rs.getInt(16), this.rs.getInt(17));
        p.setFolderAdmin(this.rs.getInt(18) > 0);
        p.setGroupPermission(this.rs.getInt(19) > 0);
        p.setSystem(this.rs.getInt(20));
        current.addPermission(p);
    }

    private final void closeResources() throws OXException {
        OXException error = null;
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                error = SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
            }
            this.rs = null;
        }
        if (this.stmt != null) {
            block10: {
                try {
                    this.stmt.close();
                }
                catch (SQLException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (error != null) break block10;
                    error = SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
                }
            }
            this.stmt = null;
        }
        if (this.closeCon && this.readCon != null) {
            DBPool.push(this.ctx, this.readCon);
            this.readCon = null;
        }
        if (error != null) {
            throw error;
        }
    }

    public boolean hasNext() throws OXException {
        if (this.isClosed) {
            return false;
        }
        return this.next != null;
    }

    public FolderObject next() throws OXException, OXException {
        if (this.isClosed) {
            throw SearchIteratorExceptionCodes.CLOSED.create().setPrefix("FLD");
        }
        try {
            FolderObject retval = this.prepareFolderObject(this.next);
            this.next = null;
            if (this.prefetchQueue == null) {
                if (this.rs.next()) {
                    this.next = this.createFolderObjectFromSelectedEntry(true);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.createFolderObjectFromSelectedEntry(true);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.next = this.future;
                    this.close();
                }
            } else if (!this.prefetchQueue.isEmpty()) {
                this.next = this.prefetchQueue.poll();
                while (this.next == null && !this.prefetchQueue.isEmpty()) {
                    this.next = this.prefetchQueue.poll();
                }
            }
            return retval;
        }
        catch (SQLException e) {
            throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
        }
    }

    private FolderObject prepareFolderObject(FolderObject fo) throws OXException {
        if (null == fo) {
            return null;
        }
        int folderId = fo.getObjectID();
        if (!fo.containsPermissions()) {
            OCLPermission[] permissions = null == this.permissionLoader ? null : this.permissionLoader.pollPermissions(folderId, this.ctx.getContextId());
            fo.setPermissionsAsArray(null == permissions ? this.getFolderPermissions(folderId) : permissions);
        }
        if (null != this.ctx && null != this.cache) {
            try {
                this.cache.putIfAbsent(fo, this.ctx, this.resideInCache ? this.getEternalAttributes() : null);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCLPermission[] getFolderPermissions(int folderId) throws OXException {
        Connection con = this.readCon;
        if (null == con) {
            con = Database.get(this.ctx, false);
            try {
                OCLPermission[] oCLPermissionArray = FolderObjectIterator.loadFolderPermissions(folderId, this.ctx.getContextId(), con);
                return oCLPermissionArray;
            }
            finally {
                Database.back(this.ctx, false, con);
            }
        }
        return FolderObjectIterator.loadFolderPermissions(folderId, this.ctx.getContextId(), con);
    }

    public void close() throws OXException {
        if (this.isClosed) {
            return;
        }
        this.next = null;
        try {
            this.closeResources();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null != this.prefetchQueue) {
            this.prefetchQueue.clear();
        }
        if (null != this.folderIds) {
            this.folderIds.clear();
        }
        if (null != this.folders) {
            this.folders.clear();
        }
        this.isClosed = true;
    }

    public int size() {
        if (this.prefetchQueue != null) {
            return this.prefetchQueue.size() + (this.next == null ? 0 : 1);
        }
        return -1;
    }

    public boolean hasSize() {
        return this.prefetchQueue != null;
    }

    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public Queue<FolderObject> asQueue() throws OXException {
        return this.asLinkedList();
    }

    public List<FolderObject> asList() throws OXException {
        return this.asLinkedList();
    }

    private LinkedList<FolderObject> asLinkedList() throws OXException {
        LinkedList<FolderObject> retval = new LinkedList<FolderObject>();
        if (this.isClosed) {
            return retval;
        }
        try {
            Cloneable fo;
            if (this.next == null) {
                LinkedList<FolderObject> linkedList = retval;
                return linkedList;
            }
            retval.add(this.prepareFolderObject(this.next));
            if (this.prefetchQueue != null) {
                while (!this.prefetchQueue.isEmpty()) {
                    retval.add(this.prepareFolderObject(this.prefetchQueue.poll()));
                }
                LinkedList<FolderObject> linkedList = retval;
                return linkedList;
            }
            while (this.rs.next()) {
                fo = this.createFolderObjectFromSelectedEntry(true);
                while (fo == null && this.rs.next()) {
                    fo = this.createFolderObjectFromSelectedEntry(true);
                }
                if (fo == null) continue;
                retval.offer(this.prepareFolderObject((FolderObject)fo));
            }
            fo = retval;
            return fo;
        }
        catch (SQLException e) {
            throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
        }
        finally {
            this.next = null;
            try {
                this.closeResources();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (null != this.prefetchQueue) {
                this.prefetchQueue.clear();
            }
            if (null != this.folderIds) {
                this.folderIds.clear();
            }
            if (null != this.folders) {
                this.folders.clear();
            }
            this.isClosed = true;
        }
    }

    private static final OCLPermission[] loadFolderPermissions(int folderId, int cid, Connection con) throws OXException {
        OCLPermission[] oCLPermissionArray;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement(SQL_LOAD_P);
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = con.prepareStatement(SQL_LOAD_P_BACKUP);
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            OCLPermission[] oCLPermissionArray2 = new OCLPermission[]{};
            DBUtils.closeSQLStuff(rs, stmt);
            return oCLPermissionArray2;
        }
        try {
            ArrayList<OCLPermission> ret = new ArrayList<OCLPermission>(8);
            do {
                OCLPermission p = new OCLPermission();
                p.setEntity(rs.getInt(1));
                p.setAllPermission(rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5));
                p.setFolderAdmin(rs.getInt(6) > 0);
                p.setGroupPermission(rs.getInt(7) > 0);
                p.setSystem(rs.getInt(8));
                ret.add(p);
            } while (rs.next());
            oCLPermissionArray = ret.toArray(new OCLPermission[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()}).setPrefix("FLD");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return oCLPermissionArray;
    }
}

