/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class ActualCosts
implements Mapper<Float> {
    public static final ActualCosts SINGLETON = new ActualCosts();

    protected ActualCosts() {
    }

    @Override
    public int getId() {
        return 302;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsActualCosts();
    }

    @Override
    public String getDBColumnName() {
        return "actual_costs";
    }

    @Override
    public String getDisplayName() {
        return "Current costs";
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getActualCosts()) {
            stmt.setNull(pos, 6);
        } else {
            stmt.setDouble(pos, Autoboxing.f((Float)task.getActualCosts()));
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        float actualCosts = result.getFloat(pos);
        if (!result.wasNull()) {
            task.setActualCosts(Autoboxing.F((float)actualCosts));
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        if (task1.getActualCosts() == null) {
            return task2.getActualCosts() == null;
        }
        if (task2.getActualCosts() == null) {
            return task1.getActualCosts() == null;
        }
        return task1.getActualCosts().equals(task2.getActualCosts());
    }

    @Override
    public Float get(Task task) {
        return task.getActualCosts();
    }

    @Override
    public void set(Task task, Float value) {
        task.setActualCosts(value);
    }
}

