/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.calendar;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.session.Session;

public class DefaultStatusPublic
implements PreferencesItemService {
    private static final String[] PATH = new String[]{"modules", "calendar", "defaultStatusPublic"};

    @Override
    public String[] getPath() {
        return PATH;
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public int getId() {
                return -1;
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Integer value = ServerUserSetting.getInstance().getDefaultStatusPublic(ctx.getContextId(), user.getId());
                if (value == null) {
                    value = 0;
                }
                setting.setSingleValue(value);
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasCalendar();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                Integer value;
                try {
                    value = new Integer(String.valueOf(setting.getSingleValue()));
                }
                catch (NumberFormatException e) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(e, setting.getSingleValue());
                }
                if (value < 0 || value > 3) {
                    throw SettingExceptionCodes.INVALID_VALUE.create(setting.getSingleValue());
                }
                ServerUserSetting.getInstance().setDefaultStatusPublic(ctx.getContextId(), user.getId(), value);
            }
        };
    }
}

