/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="delete", description="Delete Reminders", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An object with the field \"id\" or an array of objects with the field \"id\".", responseDescription="An JSON array with the ids that was not deleted.")
public final class DeleteAction
extends AbstractReminderAction {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DeleteAction.class));

    public DeleteAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        JSONArray response = new JSONArray();
        if (req.getData() instanceof JSONObject) {
            JSONObject jData = (JSONObject)req.getData();
            int id = DataParser.checkInt(jData, "id");
            TimeZone tz = req.getTimeZone();
            try {
                ReminderHandler reminderSql = new ReminderHandler(req.getSession().getContext());
                ReminderObject reminder = reminderSql.loadReminder(id);
                if (reminder.isRecurrenceAppointment()) {
                    ReminderObject nextReminder = DeleteAction.getNextRecurringReminder(req.getSession(), tz, reminder);
                    if (nextReminder != null) {
                        reminderSql.updateReminder(nextReminder);
                        response.put(nextReminder.getObjectId());
                    }
                    reminderSql.deleteReminder(reminder);
                }
                reminderSql.deleteReminder(reminder);
            }
            catch (OXException oxe) {
                LOG.debug((Object)oxe.getMessage(), (Throwable)oxe);
                if (ReminderExceptionCode.NOT_FOUND.equals(oxe)) {
                    response.put(id);
                    return new AJAXRequestResult((Object)response, "json");
                }
                throw oxe;
            }
        } else {
            JSONArray jsonArray = (JSONArray)req.getData();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jData = jsonArray.getJSONObject(i);
                int id = DataParser.checkInt(jData, "id");
                TimeZone tz = req.getTimeZone();
                try {
                    ReminderHandler reminderSql = new ReminderHandler(req.getSession().getContext());
                    ReminderObject reminder = reminderSql.loadReminder(id);
                    if (reminder.isRecurrenceAppointment()) {
                        ReminderObject nextReminder = DeleteAction.getNextRecurringReminder(req.getSession(), tz, reminder);
                        if (nextReminder != null) {
                            reminderSql.updateReminder(nextReminder);
                            response.put(nextReminder.getObjectId());
                            continue;
                        }
                        reminderSql.deleteReminder(reminder);
                        continue;
                    }
                    reminderSql.deleteReminder(reminder);
                    continue;
                }
                catch (OXException oxe) {
                    LOG.debug((Object)oxe.getMessage(), (Throwable)oxe);
                    if (ReminderExceptionCode.NOT_FOUND.equals(oxe)) {
                        response.put(id);
                        return new AJAXRequestResult((Object)response, "json");
                    }
                    throw oxe;
                }
            }
        }
        return new AJAXRequestResult((Object)response, "json");
    }
}

