/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.downgrade.DowngradeListener;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

public class InfostoreDowngrade
extends DowngradeListener {
    @Override
    public void downgradePerformed(DowngradeEvent event) throws OXException {
        UserConfiguration newUserConfiguration = event.getNewUserConfiguration();
        if (newUserConfiguration.hasInfostore()) {
            return;
        }
        StaticDBPoolProvider provider = new StaticDBPoolProvider(event.getWriteCon());
        ServerSession session = ServerSessionAdapter.valueOf(event.getSession(), event.getContext());
        InfostoreFacadeImpl infostore = new InfostoreFacadeImpl(provider);
        infostore.setTransactional(true);
        infostore.setCommitsTransaction(false);
        try {
            OXFolderAccess access = new OXFolderAccess(event.getContext());
            FolderObject fo = access.getDefaultFolder(newUserConfiguration.getUserId(), 8);
            int folderId = fo.getObjectID();
            infostore.startTransaction();
            infostore.removeDocument(folderId, Long.MAX_VALUE, session);
            infostore.commit();
        }
        catch (OXException e) {
            try {
                infostore.rollback();
            }
            catch (OXException e1) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                infostore.finish();
            }
            catch (OXException e) {}
        }
    }

    @Override
    public int getOrder() {
        return 2;
    }
}

