/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InfostoreConfig
extends AbstractConfig
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(InfostoreConfig.class));
    private static volatile InfostoreConfig singleton;
    private static final Lock INIT_LOCK;
    private static boolean loaded;

    private InfostoreConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InfostoreConfig getInstance() {
        InfostoreConfig ret = singleton;
        if (null != ret) return ret;
        Class<InfostoreConfig> clazz = InfostoreConfig.class;
        synchronized (InfostoreConfig.class) {
            ret = singleton;
            if (null != ret) return ret;
            singleton = ret = new InfostoreConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String filename;
        File file = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("infostore.properties");
        String string = filename = null == file ? null : file.getPath();
        if (null == filename) {
            throw new RuntimeException("Properties file 'infostore.properties' is not available.");
        }
        return filename;
    }

    public static String getProperty(String key) {
        InfostoreConfig singleton = InfostoreConfig.singleton;
        if (!loaded || singleton == null) {
            try {
                singleton = InfostoreConfig.getInstance();
                singleton.start();
            }
            catch (OXException e) {
                LOG.error((Object)"Can't init config:", (Throwable)e);
            }
        }
        return singleton.getPropertyInternal(key);
    }

    public static long getMaxUploadSize() {
        String sizeS = InfostoreConfig.getProperty(InfoProperty.MAX_UPLOAD_SIZE.name());
        if (null == sizeS) {
            return InfostoreConfig.sysconfMaxUpload();
        }
        long size = Long.parseLong(sizeS);
        if (-1L == size) {
            return InfostoreConfig.sysconfMaxUpload();
        }
        return size;
    }

    private static long sysconfMaxUpload() {
        String sizeS = ServerConfig.getProperty(ServerConfig.Property.MAX_UPLOAD_SIZE);
        if (null == sizeS) {
            return 0L;
        }
        return Long.parseLong(sizeS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OXException {
        if (!loaded || singleton == null) {
            INIT_LOCK.lock();
            try {
                InfostoreConfig.getInstance().loadPropertiesInternal();
                loaded = true;
            }
            finally {
                INIT_LOCK.unlock();
            }
        }
    }

    public void stop() throws OXException {
        singleton = null;
        loaded = false;
    }

    static {
        INIT_LOCK = new ReentrantLock();
        loaded = false;
    }

    public static enum InfoProperty {
        MAX_UPLOAD_SIZE;

    }
}

