/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.impl;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.FolderTreeUtil;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FolderTreeUtilImpl
implements FolderTreeUtil {
    private static volatile Mode MODE;

    public FolderTreeUtilImpl(DBProvider provider) {
        MODE = new CACHE_MODE(provider);
    }

    @Override
    public List<Integer> getPath(int folderid, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        ArrayList<Integer> path = new ArrayList<Integer>();
        try {
            FolderObject folder = this.getFolder(folderid, ctx);
            path.add(folder.getObjectID());
            while (folder != null) {
                if (folder.getParentFolderID() == 0) {
                    path.add(0);
                    folder = null;
                    continue;
                }
                folder = this.getFolder(folder.getParentFolderID(), ctx);
                path.add(folder.getObjectID());
            }
        }
        catch (Exception e) {
            throw new OXException((Throwable)e);
        }
        Collections.reverse(path);
        return path;
    }

    private FolderObject getFolder(int folderid, Context ctx) throws Exception {
        return MODE.getFolder(folderid, ctx);
    }

    private static final class NORMAL_MODE
    implements Mode {
        private NORMAL_MODE() {
        }

        @Override
        public FolderObject getFolder(int folderid, Context ctx) throws Exception {
            return FolderObject.loadFolderObjectFromDB(folderid, ctx);
        }
    }

    private static final class CACHE_MODE
    implements Mode {
        private final DBProvider provider;

        public CACHE_MODE(DBProvider provider) {
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FolderObject getFolder(int folderid, Context ctx) throws Exception {
            try {
                Connection readCon = null;
                try {
                    readCon = this.provider.getReadConnection(ctx);
                    if (FolderCacheManager.isEnabled()) {
                        FolderObject folderObject = FolderCacheManager.getInstance().getFolderObject(folderid, true, ctx, readCon);
                        return folderObject;
                    }
                    FolderObject folderObject = FolderObject.loadFolderObjectFromDB(folderid, ctx, readCon);
                    return folderObject;
                }
                finally {
                    this.provider.releaseReadConnection(ctx, readCon);
                }
            }
            catch (OXException e) {
                MODE = new NORMAL_MODE();
                return MODE.getFolder(folderid, ctx);
            }
        }
    }

    static interface Mode {
        public FolderObject getFolder(int var1, Context var2) throws Exception;
    }
}

