/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Change;
import com.openexchange.groupware.container.ConfirmationChange;
import com.openexchange.groupware.container.Differ;
import com.openexchange.groupware.container.Difference;
import com.openexchange.groupware.container.UserParticipant;
import edu.emory.mathcs.backport.java.util.Arrays;

public class UsersDiffer
extends Differ<CalendarObject> {
    @Override
    public Difference getDifference(CalendarObject original, CalendarObject update) {
        boolean found;
        if (!update.containsUserParticipants()) {
            return null;
        }
        if (!original.containsUserParticipants() && update.containsUserParticipants()) {
            Difference difference = new Difference(221);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getUsers()));
            return difference;
        }
        if (original.getUsers() == update.getUsers()) {
            return null;
        }
        if (original.getUsers() == null) {
            Difference difference = new Difference(221);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getUsers()));
            return difference;
        }
        boolean isDifferent = false;
        Difference difference = new Difference(221);
        if (original.getUsers() != null) {
            for (UserParticipant o : original.getUsers()) {
                found = false;
                if (update.getUsers() != null) {
                    for (UserParticipant u : update.getUsers()) {
                        if (o.getIdentifier() != u.getIdentifier()) continue;
                        found = true;
                        Change change = this.getChange(o, u);
                        if (change == null) break;
                        isDifferent = true;
                        difference.getChanged().add(change);
                        break;
                    }
                }
                if (found) continue;
                difference.getRemoved().add(o);
                isDifferent = true;
            }
        }
        if (update.getUsers() != null) {
            for (UserParticipant u : update.getUsers()) {
                found = false;
                if (original.getUsers() != null) {
                    for (UserParticipant o : original.getUsers()) {
                        if (u.getIdentifier() != o.getIdentifier()) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                difference.getAdded().add(u);
                isDifferent = true;
            }
        }
        return isDifferent ? difference : null;
    }

    private Change getChange(UserParticipant original, UserParticipant update) {
        boolean changed = false;
        ConfirmationChange change = new ConfirmationChange(Integer.toString(original.getIdentifier()));
        if (original.getConfirm() != update.getConfirm()) {
            changed = true;
            change.setStatus(original.getConfirm(), update.getConfirm());
        }
        if (original.getConfirmMessage() != update.getConfirmMessage() && (original.getConfirmMessage() == null && update.getConfirmMessage() != null || !original.getConfirmMessage().equals(update.getConfirmMessage()))) {
            changed = true;
            change.setMessage(original.getConfirmMessage(), update.getConfirmMessage());
        }
        return changed ? change : null;
    }

    @Override
    public int getColumn() {
        return 221;
    }
}

