/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.configuration;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.java.Streams;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public final class DirectoryService {
    private static final String PORT = "port";
    private static final String URI = "uri";
    private static final String HOST = "host";
    private static final String BASE = "base";
    private static final String BINDDN = "binddn";
    private static final String BINDPW = "bindpw";
    private static final String LDAP_CONF_FILENAME = "ldap.conf";
    private static final String WRITABLE_LDAP_CONF_FILENAME = "ldapwrite.conf";
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DirectoryService.class));
    private static volatile Properties props;
    private static String uri;
    private static String baseDN;
    private static String writableURI;
    private static String bindDN;
    private static String bindPW;
    private static boolean writeSameAsRead;

    private DirectoryService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getCustomization() {
        Properties tmp = props;
        if (null != tmp) return tmp;
        Class<DirectoryService> clazz = DirectoryService.class;
        synchronized (DirectoryService.class) {
            tmp = props;
            if (null != tmp) return tmp;
            File propfile = null;
            try {
                propfile = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("ldap.properties");
            }
            catch (NullPointerException e) {
                LOG.fatal((Object)"Config file ldap.properties is not set in ComfireConfig.");
            }
            tmp = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                tmp.load(fis);
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)"Cannot load properties for ldap!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Streams.close(fis);
                    throw throwable;
                }
                Streams.close((Closeable)fis);
            }
            Streams.close((Closeable)fis);
            props = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static String getBaseDN() {
        if (null == baseDN) {
            DirectoryService.loadLdapConf();
        }
        return baseDN;
    }

    public static String getURI() {
        if (null == uri) {
            DirectoryService.loadLdapConf();
        }
        return uri;
    }

    public static String getWritableURI() {
        if (null == writableURI) {
            DirectoryService.loadWritableLdapConf();
        }
        return writableURI;
    }

    public static String getBindDN() {
        if (null == bindDN && null == uri) {
            DirectoryService.loadLdapConf();
        }
        return bindDN;
    }

    public static String getBindPW() {
        if (null == bindPW && null == uri) {
            DirectoryService.loadLdapConf();
        }
        return bindPW;
    }

    public static boolean isWriteSameAsRead() {
        if (null == writableURI) {
            DirectoryService.loadWritableLdapConf();
        }
        return writeSameAsRead;
    }

    private static void loadLdapConf() {
        String configPath = SystemConfig.getProperty("openexchange.propdir");
        File ldapConfFile = new File(configPath, LDAP_CONF_FILENAME);
        if (ldapConfFile.exists()) {
            try {
                String[] confValues = DirectoryService.loadLdapConf(ldapConfFile);
                if (null != confValues[3]) {
                    uri = confValues[3];
                } else if (null == confValues[1]) {
                    LOG.error((Object)"Missing HOST and URI in directory service configuration.");
                } else {
                    uri = "ldap://" + confValues[1];
                    if (null != confValues[2]) {
                        uri = uri + ':' + confValues[2];
                    }
                }
                if (null != confValues[0]) {
                    baseDN = confValues[0];
                } else {
                    LOG.error((Object)"Missing BASE in directory service configuration.");
                }
                if (null != confValues[4] && null != confValues[5]) {
                    bindDN = confValues[4];
                    bindPW = confValues[5];
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading writable directory service configuration.", (Throwable)e);
            }
        } else {
            LOG.error((Object)("Cannot read directory service configuration file \"" + ldapConfFile.getAbsolutePath() + "\""));
        }
    }

    private static void loadWritableLdapConf() {
        String configPath = SystemConfig.getProperty("openexchange.propdir");
        File writableLdapConfFile = new File(configPath, WRITABLE_LDAP_CONF_FILENAME);
        if (writableLdapConfFile.exists()) {
            try {
                String[] confValues = DirectoryService.loadLdapConf(writableLdapConfFile);
                if (null != confValues[3]) {
                    writableURI = confValues[3];
                } else if (null == confValues[1]) {
                    LOG.error((Object)"Missing HOST and URI in directory service configuration.");
                } else {
                    writableURI = "ldap://" + confValues[1];
                    if (null != confValues[2]) {
                        writableURI = writableURI + ":" + confValues[2];
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading writable directory service configuration.", (Throwable)e);
            }
        } else {
            DirectoryService.loadLdapConf();
            writableURI = uri;
            writeSameAsRead = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] loadLdapConf(File ldapConfFile) throws IOException {
        String[] retval;
        BufferedReader br = new BufferedReader(new FileReader(ldapConfFile));
        try {
            String line = null;
            retval = new String[6];
            while ((line = br.readLine()) != null) {
                String detectable = line.trim().toLowerCase();
                if (detectable.startsWith(BASE)) {
                    retval[0] = line.substring(BASE.length()).trim();
                }
                if (detectable.startsWith(HOST)) {
                    retval[1] = line.substring(HOST.length()).trim();
                    if (retval[1].indexOf(32) != -1) {
                        retval[1] = retval[1].substring(0, retval[1].indexOf(32));
                    }
                }
                if (detectable.startsWith(URI)) {
                    retval[3] = line.substring(URI.length()).trim();
                }
                if (detectable.startsWith(PORT)) {
                    retval[2] = line.substring(PORT.length()).trim();
                }
                if (detectable.startsWith(BINDDN)) {
                    retval[4] = line.substring(BINDDN.length()).trim();
                }
                if (!detectable.startsWith(BINDPW)) continue;
                retval[5] = line.substring(BINDPW.length()).trim();
            }
        }
        finally {
            Streams.close((Closeable)br);
        }
        return retval;
    }

    static {
        uri = null;
        baseDN = null;
        writableURI = null;
        bindDN = null;
        bindPW = null;
        writeSameAsRead = false;
    }
}

