/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.RemoveAfterAccessFolder;
import com.openexchange.folderstorage.RemoveAfterAccessFolderWrapper;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.mail.ExternalMailAccountRootFolder;
import com.openexchange.folderstorage.mail.MailAccessFullnameProvider;
import com.openexchange.folderstorage.mail.MailFolderImpl;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.mail.MailId;
import com.openexchange.folderstorage.mail.MailServiceRegistry;
import com.openexchange.folderstorage.mail.RemoveAfterAccessExtRootFolder;
import com.openexchange.folderstorage.mail.contentType.DraftsContentType;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.mail.contentType.SentContentType;
import com.openexchange.folderstorage.mail.contentType.SpamContentType;
import com.openexchange.folderstorage.mail.contentType.TrashContentType;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class MailFolderStorage
implements FolderStorage {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailFolderStorage.class));
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private final TObjectProcedure<MailAccess<?, ?>> procedure;
    private final MailFolderType folderType = MailFolderType.getInstance();
    private final String paramAccessFast = "__accessFast";
    private static final Set<String> IGNORABLES = RemoveAfterAccessFolder.IGNORABLES;
    private static final String INVALID = "<>";

    public MailFolderStorage() {
        this.procedure = new TObjectProcedure<MailAccess<?, ?>>(){

            public boolean execute(MailAccess<?, ?> mailAccess) {
                MailFolderStorage.closeMailAccess(mailAccess);
                return true;
            }
        };
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{MailContentType.getInstance(), DraftsContentType.getInstance(), SentContentType.getInstance(), SpamContentType.getInstance(), TrashContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return MailContentType.getInstance();
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!MailType.getInstance().equals(type) && !PrivateType.getInstance().equals(type)) {
            return new SortableId[0];
        }
        if (!MailContentType.getInstance().toString().equals(((Object)contentType).toString())) {
            return new SortableId[0];
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            boolean accountId = false;
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, 0);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            ArrayList<MailFolder> folders2 = new ArrayList<MailFolder>(32);
            MailFolder rootFolder = mailAccess.getRootFolder();
            folders2.add(rootFolder);
            MailFolderStorage.addSubfolders("default", folders2, mailAccess.getFolderStorage());
            Collections.sort(folders2, new SimpleMailFolderComparator(storageParameters.getUser().getLocale()));
            int size = folders2.size();
            ArrayList<MailId> list = new ArrayList<MailId>(size);
            FolderServiceDecorator decorator = storageParameters.getDecorator();
            if (null == decorator) {
                for (int j = 0; j < size; ++j) {
                    MailFolder mf = (MailFolder)folders2.get(j);
                    list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mf.getFullname()), j).setName(mf.getName()));
                }
            } else {
                List accountList;
                Object property = decorator.getProperty("mailRootFolders");
                if (property != null && Boolean.parseBoolean(property.toString()) && session.getUserConfiguration().isMultipleMailAccounts()) {
                    MailAccountStorageService mass = (MailAccountStorageService)MailServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class, true);
                    MailAccount[] accounts = mass.getUserMailAccounts(storageParameters.getUserId(), storageParameters.getContextId());
                    accountList = new ArrayList(accounts.length);
                    for (MailAccount mailAccount : accounts) {
                        if (mailAccount.isDefaultAccount()) continue;
                        accountList.add(mailAccount);
                    }
                    Collections.sort(accountList, new MailAccountComparator(session.getUser().getLocale()));
                    if (!accountList.isEmpty() && UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(((MailAccount)accountList.get(0)).getMailProtocol())) {
                        UnifiedInboxManagement uim = (UnifiedInboxManagement)MailServiceRegistry.getServiceRegistry().getService(UnifiedInboxManagement.class);
                        if (null == uim || !uim.isEnabled(session.getUserId(), session.getContextId())) {
                            accountList.remove(0);
                        } else {
                            MailAccount unifiedMailAccount = (MailAccount)accountList.remove(0);
                            list.add(0, new MailId(MailFolderUtility.prepareFullname(unifiedMailAccount.getId(), "default"), 0).setName("E-Mail"));
                        }
                    }
                } else {
                    accountList = Collections.emptyList();
                }
                int start = list.size();
                for (int j = 0; j < size; ++j) {
                    MailFolder mf = (MailFolder)folders2.get(j);
                    list.add(new MailId(MailFolderUtility.prepareFullname(mailAccess.getAccountId(), mf.getFullname()), start++).setName(mf.getName()));
                }
                int sz = accountList.size();
                for (int j = 0; j < sz; ++j) {
                    list.add(new MailId(MailFolderUtility.prepareFullname(((MailAccount)accountList.get(j)).getId(), "default"), start++).setName("E-Mail"));
                }
            }
            SortableId[] sortableIdArray = list.toArray(new SortableId[list.size()]);
            return sortableIdArray;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    private static void addSubfolders(String fullname, List<MailFolder> folders2, IMailFolderStorage folderStorage) throws OXException {
        MailFolder[] subfolders;
        for (MailFolder subfolder : subfolders = folderStorage.getSubfolders(fullname, false)) {
            folders2.add(subfolder);
            MailFolderStorage.addSubfolders(subfolder.getFullname(), folders2, folderStorage);
        }
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            if ("default".equals(fullname)) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create();
            }
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect(false);
            if (!mailAccess.getFolderStorage().exists(fullname)) {
                MailFolderStorage.recreateMailFolder(accountId, fullname, session, mailAccess);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            MailPermission[] mailPermissions;
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folder.getParentID());
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect(false);
            MailFolderDescription mfd = new MailFolderDescription();
            mfd.setExists(false);
            String parentFullName = arg.getFullname();
            mfd.setParentFullname(parentFullName);
            mfd.setParentAccountId(accountId);
            mfd.setSeparator(mailAccess.getFolderStorage().getFolder(arg.getFullname()).getSeparator());
            String name = folder.getName();
            MailFolderStorage.checkFolderName(name);
            mfd.setName(name);
            mfd.setSubscribed(folder.isSubscribed());
            Permission[] permissions = folder.getPermissions();
            if (null != permissions && permissions.length > 0) {
                mailPermissions = new MailPermission[permissions.length];
                MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                for (int i = 0; i < permissions.length; ++i) {
                    Permission permission = permissions[i];
                    MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                    mailPerm.setEntity(permission.getEntity());
                    mailPerm.setAllPermission(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                    mailPerm.setFolderAdmin(permission.isAdmin());
                    mailPerm.setGroupPermission(permission.isGroup());
                    mailPermissions[i] = mailPerm;
                }
                mfd.addPermissions(mailPermissions);
            } else if ("default".equals(parentFullName)) {
                mailPermissions = new MailPermission[1];
                MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                mailPerm.setEntity(session.getUserId());
                mailPerm.setAllPermission(128, 128, 128, 128);
                mailPerm.setFolderAdmin(true);
                mailPerm.setGroupPermission(false);
                mailPermissions[0] = mailPerm;
                mfd.addPermissions(mailPermissions);
            } else {
                MailFolder parent = mailAccess.getFolderStorage().getFolder(parentFullName);
                MailPermission[] parentPermissions = parent.getPermissions();
                MailPermission[] mailPermissions2 = new MailPermission[1];
                MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                for (int i = 0; i < parentPermissions.length; ++i) {
                    MailPermission parentPerm = parentPermissions[i];
                    MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                    mailPerm.setEntity(parentPerm.getEntity());
                    mailPerm.setAllPermission(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                    mailPerm.setFolderAdmin(parentPerm.isFolderAdmin());
                    mailPerm.setGroupPermission(parentPerm.isGroupPermission());
                    mailPermissions2[i] = mailPerm;
                }
                mfd.addPermissions(mailPermissions2);
            }
            String fullname = mailAccess.getFolderStorage().createFolder(mfd);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
            MailFolderStorage.postEvent(accountId, mfd.getParentFullname(), false, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            String fullname = arg.getFullname();
            String trashFullname = mailAccess.getFolderStorage().getTrashFolder();
            boolean hardDelete = fullname.startsWith(trashFullname);
            mailAccess.getFolderStorage().clearFolder(fullname, hardDelete);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            MailFolderStorage.postEvent(accountId, fullname, true, storageParameters);
            if (!hardDelete) {
                MailFolderStorage.postEvent(accountId, trashFullname, true, storageParameters);
            }
            try {
                MailMessageCache.getInstance().removeFolderMessages(accountId, fullname, storageParameters.getUserId(), storageParameters.getContextId());
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (fullname.startsWith(trashFullname)) {
                MailFolder[] subf = mailAccess.getFolderStorage().getSubfolders(fullname, true);
                for (int i = 0; i < subf.length; ++i) {
                    String subFullname = subf[i].getFullname();
                    mailAccess.getFolderStorage().deleteFolder(subFullname, true);
                    MailFolderStorage.postEvent(accountId, subFullname, false, storageParameters);
                }
                MailFolderStorage.postEvent(accountId, trashFullname, false, storageParameters);
            }
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = arg.getAccountId();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            String fullname = arg.getFullname();
            String trashFullname = mailAccess.getFolderStorage().getTrashFolder();
            boolean hardDelete = fullname.startsWith(trashFullname);
            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullname, mailAccess);
            mailAccess.getFolderStorage().deleteFolder(fullname, hardDelete);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            MailFolderStorage.postEvent(accountId, fullname, false, true, false, storageParameters);
            try {
                MailMessageCache.getInstance().removeFolderMessages(accountId, fullname, storageParameters.getUserId(), storageParameters.getContextId());
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!hardDelete) {
                MailFolderStorage.postEvent(accountId, trashFullname, false, storageParameters);
            }
            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, storageParameters);
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof MailContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(((Object)contentType).toString());
        }
        if (MailContentType.getInstance().equals(contentType)) {
            return MailFolderUtility.prepareFullname(0, "INBOX");
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, 0);
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            if (DraftsContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getDraftsFolder());
                return string;
            }
            if (SentContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getSentFolder());
                return string;
            }
            if (SpamContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getSpamFolder());
                return string;
            }
            if (TrashContentType.getInstance().equals(contentType)) {
                String string = MailFolderUtility.prepareFullname(0, mailAccess.getFolderStorage().getTrashFolder());
                return string;
            }
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(((Object)contentType).toString());
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return MailType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect(false);
            if (!"default".equals(fullname) && !mailAccess.getFolderStorage().exists(fullname)) {
                throw MailExceptionCode.FOLDER_NOT_FOUND.create(fullname);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            boolean bl = false;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, accountId);
            if ("default".equals(fullname)) {
                boolean bl = true;
                return bl;
            }
            mailAccess.connect(false);
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            if (folderStorage instanceof IMailFolderStorageEnhanced) {
                boolean bl = ((IMailFolderStorageEnhanced)folderStorage).getTotalCounter(fullname) > 0;
                return bl;
            }
            boolean bl = 0 == mailAccess.getMessageStorage().searchMessages(fullname, new IndexRange(0, 1), MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, new MailField[]{MailField.ID}).length;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        TIntObjectHashMap accesses = new TIntObjectHashMap(2);
        try {
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            TIntObjectHashMap accounts = new TIntObjectHashMap(2);
            ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
            for (String folderId : folderIds) {
                MailAccount mailAccount;
                FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
                int accountId = argument.getAccountId();
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(accountId);
                if (null == mailAccess) {
                    mailAccess = MailAccess.getInstance(session, accountId);
                    accesses.put(accountId, mailAccess);
                }
                if (null == (mailAccount = (MailAccount)accounts.get(argument.getAccountId()))) {
                    MailAccountStorageService storageService = (MailAccountStorageService)MailServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class, true);
                    mailAccount = storageService.getMailAccount(accountId, storageParameters.getUserId(), storageParameters.getContextId());
                    accounts.put(accountId, (Object)mailAccount);
                }
                ret.add(this.getFolder(treeId, argument, storageParameters, mailAccess, session, mailAccount));
            }
            ArrayList<Folder> arrayList = ret;
            return arrayList;
        }
        finally {
            accesses.forEachValue(this.procedure);
        }
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            MailAccountStorageService storageService = (MailAccountStorageService)MailServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class, true);
            MailAccount mailAccount = storageService.getMailAccount(argument.getAccountId(), storageParameters.getUserId(), storageParameters.getContextId());
            mailAccess = MailAccess.getInstance(session, argument.getAccountId());
            Folder folder = this.getFolder(treeId, argument, storageParameters, mailAccess, session, mailAccount);
            return folder;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    private Folder getFolder(String treeId, FullnameArgument argument, StorageParameters storageParameters, MailAccess<?, ?> mailAccess, ServerSession session, MailAccount mailAccount) throws OXException {
        Folder retval;
        int accountId = argument.getAccountId();
        String fullname = argument.getFullname();
        if ("default".equals(fullname)) {
            if (0 == accountId) {
                MailFolder rootFolder = mailAccess.getRootFolder();
                retval = new MailFolderImpl(rootFolder, accountId, mailAccess.getMailConfig(), storageParameters, null);
                MailFolderStorage.addWarnings(mailAccess, storageParameters);
                boolean hasSubfolders = rootFolder.hasSubfolders();
                retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
            } else {
                retval = IGNORABLES.contains(mailAccount.getMailProtocol()) ? new ExternalMailAccountRootFolder(mailAccount, mailAccess.getMailConfig(), session) : new RemoveAfterAccessExtRootFolder(mailAccount, mailAccess.getMailConfig(), session);
                retval.setSubfolderIDs(null);
            }
        } else {
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            MailFolder mailFolder = MailFolderStorage.getMailFolder(treeId, accountId, fullname, true, session, mailAccess);
            MailFolderImpl mailFolderImpl = new MailFolderImpl(mailFolder, accountId, mailAccess.getMailConfig(), storageParameters, new MailAccessFullnameProvider(mailAccess));
            retval = 0 == accountId || IGNORABLES.contains(mailAccount.getMailProtocol()) ? mailFolderImpl : new RemoveAfterAccessFolderWrapper(mailFolderImpl, false, session.getUserId(), session.getContextId());
            boolean hasSubfolders = mailFolder.hasSubfolders();
            if ("INBOX".equals(fullname)) {
                retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
            } else {
                ArrayList<MailFolder> children = new ArrayList<MailFolder>(Arrays.asList(mailAccess.getFolderStorage().getSubfolders(fullname, true)));
                if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                    MailFolderStorage.filterPOP3StorageFolders(children, session);
                }
                Collections.sort(children, new SimpleMailFolderComparator(storageParameters.getUser().getLocale()));
                String[] subfolderIds = new String[children.size()];
                int i = 0;
                for (MailFolder child : children) {
                    subfolderIds[i++] = MailFolderUtility.prepareFullname(accountId, child.getFullname());
                }
                retval.setSubfolderIDs(subfolderIds);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
        }
        retval.setTreeID(treeId);
        return retval;
    }

    private static void filterPOP3StorageFolders(List<MailFolder> folders2, ServerSession session) throws OXException {
        Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(session);
        Iterator<MailFolder> it = folders2.iterator();
        while (it.hasNext()) {
            MailFolder mf = it.next();
            if (!pop3StorageFolders.contains(mf.getFullname())) continue;
            it.remove();
        }
    }

    private static ServerSession getServerSession(StorageParameters storageParameters) throws OXException, OXException {
        Session s = storageParameters.getSession();
        if (null == s) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        if (s instanceof ServerSession) {
            return (ServerSession)s;
        }
        return ServerSessionAdapter.valueOf(s);
    }

    private static MailFolder getMailFolder(String treeId, int accountId, String fullname, boolean createIfAbsent, Session session, MailAccess<?, ?> mailAccess) throws OXException {
        try {
            return mailAccess.getFolderStorage().getFolder(fullname);
        }
        catch (OXException e) {
            if (!createIfAbsent) {
                throw e;
            }
            if (!e.isPrefix("MSG") || MailExceptionCode.FOLDER_NOT_FOUND.getNumber() != e.getCode() || FolderStorage.REAL_TREE_ID.equals(treeId)) {
                throw e;
            }
            return MailFolderStorage.recreateMailFolder(accountId, fullname, session, mailAccess);
        }
    }

    private static MailFolder recreateMailFolder(int accountId, String fullname, Session session, MailAccess<?, ?> mailAccess) throws OXException {
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setExists(false);
        mfd.setAccountId(accountId);
        mfd.setParentAccountId(accountId);
        char separator = mailAccess.getFolderStorage().getFolder("INBOX").getSeparator();
        String[] parentAndName = MailFolderStorage.splitBySeperator(fullname, separator);
        mfd.setParentFullname(parentAndName[0]);
        mfd.setName(parentAndName[1]);
        mfd.setSeparator(separator);
        MailPermission mailPerm = MailProviderRegistry.getMailProviderBySession(session, accountId).createNewMailPermission(session, accountId);
        mailPerm.setEntity(session.getUserId());
        mailPerm.setGroupPermission(false);
        mailPerm.setFolderAdmin(true);
        int max = 128;
        mailPerm.setAllPermission(128, 128, 128, 128);
        mfd.addPermission(mailPerm);
        mfd.setSubscribed(true);
        String id = mailAccess.getFolderStorage().createFolder(mfd);
        return mailAccess.getFolderStorage().getFolder(id);
    }

    private static String[] splitBySeperator(String fullname, char sep) {
        int pos = fullname.lastIndexOf(sep);
        if (pos < 0) {
            return new String[]{"default", fullname};
        }
        return new String[]{fullname.substring(0, pos), fullname.substring(pos + 1)};
    }

    private boolean isDefaultFoldersChecked(int accountId, Session session) {
        Boolean b = (Boolean)MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    private String[] getSortedDefaultMailFolders(int accountId, Session session) {
        String[] arr = (String[])MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
        if (arr == null) {
            return new String[0];
        }
        return new String[]{"INBOX", arr[0], arr[1], arr[2], arr[3]};
    }

    @Override
    public FolderType getFolderType() {
        return this.folderType;
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return this.getSubfolders(parentId, storageParameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortableId[] getSubfolders(String parentId, StorageParameters storageParameters, MailAccess<?, ?> mailAccessArg) throws OXException {
        MailAccess<Object, Object> mailAccess = null;
        boolean closeAccess = true;
        try {
            ServerSession session = MailFolderStorage.getServerSession(storageParameters);
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            if (PRIVATE_FOLDER_ID.equals(parentId)) {
                UnifiedInboxManagement uim;
                ArrayList<MailAccount> accounts;
                MailAccountStorageService storageService;
                ServiceRegistry serviceRegistry = MailServiceRegistry.getServiceRegistry();
                if (session.getUserConfiguration().isMultipleMailAccounts()) {
                    storageService = (MailAccountStorageService)serviceRegistry.getService(MailAccountStorageService.class, true);
                    MailAccount[] accountsArr = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
                    ArrayList<MailAccount> tmp = new ArrayList<MailAccount>(accountsArr.length);
                    tmp.addAll(Arrays.asList(accountsArr));
                    Collections.sort(tmp, new MailAccountComparator(session.getUser().getLocale()));
                    accounts = tmp;
                } else {
                    accounts = new ArrayList<MailAccount>(1);
                    storageService = (MailAccountStorageService)serviceRegistry.getService(MailAccountStorageService.class, true);
                    accounts.add(storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()));
                }
                if (!(accounts.isEmpty() || !UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(((MailAccount)accounts.get(0)).getMailProtocol()) || null != (uim = (UnifiedInboxManagement)serviceRegistry.getService(UnifiedInboxManagement.class)) && uim.isEnabled(session.getUserId(), session.getContextId()))) {
                    accounts.remove(0);
                }
                int size = accounts.size();
                ArrayList<MailId> list = new ArrayList<MailId>(size);
                for (int j = 0; j < size; ++j) {
                    list.add(new MailId(MailFolderUtility.prepareFullname(((MailAccount)accounts.get(j)).getId(), "default"), j).setName("E-Mail"));
                }
                SortableId[] j = list.toArray(new SortableId[list.size()]);
                return j;
            }
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentId);
            int accountId = argument.getAccountId();
            String fullname = argument.getFullname();
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            if (null == mailAccessArg) {
                mailAccess = MailAccess.getInstance(session, accountId);
                mailAccess.connect(null == accessFast ? true : accessFast == false);
            } else {
                mailAccess = mailAccessArg;
                if (mailAccess.isConnected()) {
                    closeAccess = false;
                } else {
                    mailAccess.connect(null == accessFast ? true : accessFast == false);
                }
            }
            List<MailFolder> children = new ArrayList<MailFolder>(Arrays.asList(mailAccess.getFolderStorage().getSubfolders(fullname, true)));
            if (0 == accountId && MailProperties.getInstance().isHidePOP3StorageFolders()) {
                MailFolderStorage.filterPOP3StorageFolders(children, session);
            }
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            if (Boolean.TRUE.equals(accessFast) || !"default".equals(fullname) && !"INBOX".equals(fullname)) {
                Collections.sort(children, new SimpleMailFolderComparator(storageParameters.getUser().getLocale()));
            } else {
                String[] names;
                if (this.isDefaultFoldersChecked(accountId, storageParameters.getSession())) {
                    names = this.getSortedDefaultMailFolders(accountId, storageParameters.getSession());
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add("INBOX");
                    Object folderStorage = mailAccess.getFolderStorage();
                    String fn = folderStorage.getDraftsFolder();
                    if (null != fn) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage.getSentFolder())) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage.getSpamFolder())) {
                        tmp.add(fn);
                    }
                    if (null != (fn = folderStorage.getTrashFolder())) {
                        tmp.add(fn);
                    }
                    names = tmp.toArray(new String[tmp.size()]);
                }
                Locale locale = storageParameters.getUser().getLocale();
                children = MailFolderStorage.stripNullElementsFrom(children);
                Collections.sort(children, new MailFolderComparator(names, locale));
                block13: for (MailFolder child : children) {
                    Object folderStorage;
                    if ("INBOX".equals(child.getFullname())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.INBOX));
                        continue;
                    }
                    if (child.containsDefaultFolderType()) {
                        switch (child.getDefaultFolderType()) {
                            case TRASH: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.TRASH));
                                continue block13;
                            }
                            case SENT: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.SENT));
                                continue block13;
                            }
                            case SPAM: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.SPAM));
                                continue block13;
                            }
                            case DRAFTS: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.DRAFTS));
                                continue block13;
                            }
                            case CONFIRMED_SPAM: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_SPAM));
                                continue block13;
                            }
                            case CONFIRMED_HAM: {
                                child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_HAM));
                                continue block13;
                            }
                        }
                        continue;
                    }
                    String fullName = child.getFullname();
                    if (fullName.equals((folderStorage = mailAccess.getFolderStorage()).getDraftsFolder())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.DRAFTS));
                        continue;
                    }
                    if (fullName.equals(folderStorage.getSentFolder())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.SENT));
                        continue;
                    }
                    if (fullName.equals(folderStorage.getSpamFolder())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.SPAM));
                        continue;
                    }
                    if (fullName.equals(folderStorage.getTrashFolder())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.TRASH));
                        continue;
                    }
                    if (fullName.equals(folderStorage.getConfirmedSpamFolder())) {
                        child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_SPAM));
                        continue;
                    }
                    if (!fullName.equals(folderStorage.getConfirmedHamFolder())) continue;
                    child.setName(StringHelper.valueOf(locale).getString(MailStrings.CONFIRMED_HAM));
                }
            }
            int size = children.size();
            ArrayList<MailId> list = new ArrayList<MailId>(size);
            for (int j = 0; j < size; ++j) {
                MailFolder tmp = (MailFolder)children.get(j);
                list.add(new MailId(MailFolderUtility.prepareFullname(accountId, tmp.getFullname()), j).setName(tmp.getName()));
            }
            SortableId[] sortableIdArray = list.toArray(new SortableId[list.size()]);
            return sortableIdArray;
        }
        finally {
            if (closeAccess) {
                MailFolderStorage.closeMailAccess(mailAccess);
            }
        }
    }

    @Override
    public void rollback(StorageParameters params) {
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        return false;
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
            String fullname = argument.getFullname();
            if ("default".equals(fullname)) {
                boolean bl = true;
                return bl;
            }
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            mailAccess = MailAccess.getInstance(session, argument.getAccountId());
            Boolean accessFast = (Boolean)storageParameters.getParameter(this.folderType, "__accessFast");
            mailAccess.connect(null == accessFast ? true : accessFast == false);
            boolean exists = mailAccess.getFolderStorage().exists(fullname);
            MailFolderStorage.addWarnings(mailAccess, storageParameters);
            boolean bl = exists;
            return bl;
        }
        finally {
            MailFolderStorage.closeMailAccess(mailAccess);
        }
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(treeId, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        String fullname;
        int accountId;
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess;
        block24: {
            MailPermission[] mailPermissions;
            MailFolderDescription mfd;
            block23: {
                String newName;
                String oldName;
                String oldParent;
                char separator;
                int pos;
                mailAccess = null;
                FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder.getID());
                accountId = argument.getAccountId();
                fullname = argument.getFullname();
                Session session = storageParameters.getSession();
                if (null == session) {
                    throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
                }
                mailAccess = MailAccess.getInstance(session, accountId);
                mailAccess.connect(false);
                mfd = new MailFolderDescription();
                mfd.setExists(true);
                mfd.setFullname(fullname);
                mfd.setAccountId(accountId);
                if (null != folder.getParentID()) {
                    FullnameArgument parentArg = MailFolderUtility.prepareMailFolderParam(folder.getParentID());
                    mfd.setParentFullname(parentArg.getFullname());
                    mfd.setParentAccountId(parentArg.getAccountId());
                }
                MailFolder mf = mailAccess.getFolderStorage().getFolder(fullname);
                mfd.setSeparator(mf.getSeparator());
                String name = folder.getName();
                if (null != name) {
                    MailFolderStorage.checkFolderName(name);
                    mfd.setName(name);
                }
                mfd.setSubscribed(folder.isSubscribed());
                mailPermissions = null;
                Permission[] permissions = folder.getPermissions();
                if (null != permissions && permissions.length > 0) {
                    mailPermissions = new MailPermission[permissions.length];
                    MailProvider provider = MailProviderRegistry.getMailProviderBySession(session, accountId);
                    for (int i = 0; i < permissions.length; ++i) {
                        Permission permission = permissions[i];
                        MailPermission mailPerm = provider.createNewMailPermission(session, accountId);
                        mailPerm.setEntity(permission.getEntity());
                        mailPerm.setAllPermission(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                        mailPerm.setFolderAdmin(permission.isAdmin());
                        mailPerm.setGroupPermission(permission.isGroup());
                        mailPermissions[i] = mailPerm;
                    }
                    mfd.addPermissions(mailPermissions);
                }
                if ((pos = fullname.lastIndexOf(separator = mfd.getSeparator())) == -1) {
                    oldParent = "";
                    oldName = fullname;
                } else {
                    oldParent = fullname.substring(0, pos);
                    oldName = fullname.substring(pos + 1);
                }
                boolean movePerformed = false;
                if (mfd.containsParentFullname()) {
                    int parentAccountID = mfd.getParentAccountId();
                    if (accountId == parentAccountID) {
                        String newParent = mfd.getParentFullname();
                        StringBuilder newFullname = new StringBuilder(16);
                        if (!"default".equals(newParent)) {
                            newFullname.append(newParent).append(mfd.getSeparator());
                        }
                        newFullname.append(mfd.containsName() ? mfd.getName() : oldName);
                        if (!newParent.equals(oldParent)) {
                            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullname, mailAccess);
                            String oldFullName = fullname;
                            fullname = mailAccess.getFolderStorage().moveFolder(fullname, newFullname.toString());
                            folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
                            MailFolderStorage.postChangedId(fullname, oldFullName, Character.toString(separator), session);
                            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, storageParameters);
                            MailFolderStorage.postEvent(accountId, newParent, false, storageParameters);
                            movePerformed = true;
                        }
                    } else {
                        MailAccess<IMailFolderStorage, IMailMessageStorage> otherAccess = null;
                        try {
                            otherAccess = MailAccess.getInstance(session, parentAccountID);
                            otherAccess.connect();
                            String newParent = mfd.getParentFullname();
                            MailFolder p = otherAccess.getFolderStorage().getFolder(newParent);
                            MailPermission ownPermission = p.getOwnPermission();
                            if (!ownPermission.canCreateSubfolders()) {
                                throw MailExceptionCode.NO_CREATE_ACCESS.create(newParent);
                            }
                            MailFolder[] tmp = otherAccess.getFolderStorage().getSubfolders(newParent, true);
                            String lookFor = mfd.containsName() ? mfd.getName() : oldName;
                            for (MailFolder sub : tmp) {
                                if (!sub.getName().equals(lookFor)) continue;
                                throw MailExceptionCode.DUPLICATE_FOLDER.create(lookFor);
                            }
                            String destFullname = MailFolderStorage.fullCopy(mailAccess, fullname, otherAccess, newParent, p.getSeparator(), storageParameters.getUserId(), otherAccess.getMailConfig().getCapabilities().hasPermissions());
                            MailFolderStorage.postEvent(parentAccountID, newParent, false, storageParameters);
                            Map<String, Map<?, ?>> subfolders = MailFolderStorage.subfolders(fullname, mailAccess);
                            mailAccess.getFolderStorage().deleteFolder(fullname, true);
                            otherAccess.getFolderStorage().updateFolder(destFullname, mfd);
                            MailFolderStorage.postEvent4Subfolders(accountId, subfolders, storageParameters);
                            folder.setID(MailFolderUtility.prepareFullname(parentAccountID, destFullname));
                            otherAccess.getFolderStorage().updateFolder(destFullname, mfd);
                            MailFolderStorage.addWarnings(otherAccess, storageParameters);
                            MailFolderStorage.postEvent(parentAccountID, destFullname, false, storageParameters);
                            return;
                        }
                        finally {
                            if (null != otherAccess) {
                                otherAccess.close(true);
                            }
                        }
                    }
                }
                if (movePerformed || !mfd.containsName() || (newName = mfd.getName()).equals(oldName)) break block23;
                String oldFullName = fullname;
                fullname = mailAccess.getFolderStorage().renameFolder(fullname, newName);
                folder.setID(MailFolderUtility.prepareFullname(accountId, fullname));
                MailFolderStorage.postChangedId(fullname, oldFullName, Character.toString(separator), session);
                MailFolderStorage.postEvent(accountId, fullname, false, storageParameters);
            }
            mailAccess.getFolderStorage().updateFolder(fullname, mfd);
            if (null != mailPermissions && StorageParametersUtility.isHandDownPermissions(storageParameters)) {
                MailFolderStorage.handDown(accountId, fullname, mailPermissions, mailAccess, storageParameters);
            }
            break block24;
            finally {
                MailFolderStorage.closeMailAccess(mailAccess);
            }
        }
        MailFolderStorage.addWarnings(mailAccess, storageParameters);
        MailFolderStorage.postEvent(accountId, fullname, false, storageParameters);
    }

    private static void handDown(int accountId, String parentFullName, MailPermission[] mailPermissions, MailAccess<?, ?> mailAccess, StorageParameters params) throws OXException {
        MailFolder[] subfolders;
        for (MailFolder mailFolder : subfolders = mailAccess.getFolderStorage().getSubfolders(parentFullName, true)) {
            MailFolderDescription mfd = new MailFolderDescription();
            mfd.setExists(true);
            String childFullName = mailFolder.getFullname();
            mfd.setFullname(childFullName);
            mfd.setAccountId(accountId);
            mfd.addPermissions(mailPermissions);
            mailAccess.getFolderStorage().updateFolder(childFullName, mfd);
            MailFolderStorage.postEvent(accountId, childFullName, false, params);
            MailFolderStorage.handDown(accountId, childFullName, mailPermissions, mailAccess, params);
        }
    }

    private static String fullCopy(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> srcAccess, String srcFullname, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> destAccess, String destParent, char destSeparator, int user, boolean hasPermissions) throws OXException {
        MailFolder[] tmp;
        MailFolder source = srcAccess.getFolderStorage().getFolder(srcFullname);
        MailFolderDescription mfd = new MailFolderDescription();
        mfd.setName(source.getName());
        mfd.setParentFullname(destParent);
        mfd.setSeparator(destSeparator);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            MailPermission[] perms = source.getPermissions();
            try {
                for (MailPermission perm : perms) {
                    mfd.addPermission((MailPermission)perm.clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        String destFullname = destAccess.getFolderStorage().createFolder(mfd);
        MailMessage[] msgs = srcAccess.getMessageStorage().getAllMessages(srcFullname, null, MailSortField.RECEIVED_DATE, OrderDirection.ASC, new MailField[]{MailField.FULL});
        IMailMessageStorage destMessageStorage = destAccess.getMessageStorage();
        destMessageStorage.appendMessages(destFullname, msgs);
        for (MailFolder element : tmp = srcAccess.getFolderStorage().getSubfolders(srcFullname, true)) {
            MailFolderStorage.fullCopy(srcAccess, element.getFullname(), destAccess, destFullname, destSeparator, user, hasPermissions);
        }
        return destFullname;
    }

    private static void postEvent4Subfolders(int accountId, Map<String, Map<?, ?>> subfolders, StorageParameters params) {
        int size = subfolders.size();
        Iterator<Map.Entry<String, Map<?, ?>>> iter = subfolders.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, Map<?, ?>> entry = iter.next();
            Map<String, Map<?, ?>> m = entry.getValue();
            if (!m.isEmpty()) {
                MailFolderStorage.postEvent4Subfolders(accountId, m, params);
            }
            MailFolderStorage.postEvent(accountId, entry.getKey(), false, true, false, params);
        }
    }

    private static Map<String, Map<?, ?>> subfolders(String fullname, MailAccess<?, ?> mailAccess) throws OXException {
        HashMap m = new HashMap();
        MailFolderStorage.subfoldersRecursively(fullname, m, mailAccess);
        return m;
    }

    private static void subfoldersRecursively(String parent, Map<String, Map<?, ?>> m, MailAccess<?, ?> mailAccess) throws OXException {
        MailFolder[] mailFolders = mailAccess.getFolderStorage().getSubfolders(parent, true);
        if (null == mailFolders || 0 == mailFolders.length) {
            Map emptyMap = Collections.emptyMap();
            m.put(parent, emptyMap);
        } else {
            HashMap subMap = new HashMap();
            int size = mailFolders.length;
            for (int i = 0; i < size; ++i) {
                String fullname = mailFolders[i].getFullname();
                MailFolderStorage.subfoldersRecursively(fullname, subMap, mailAccess);
            }
            m.put(parent, subMap);
        }
    }

    private static void postChangedId(String newId, String oldId, String delim, Session session) {
        EventAdmin eventAdmin = (EventAdmin)MailServiceRegistry.getServiceRegistry().getService(EventAdmin.class);
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(6);
            properties.put("com.openexchange.folderstorage.session", session);
            properties.put("com.openexchange.folderstorage.context", session.getContextId());
            properties.put("com.openexchange.folderstorage.user", session.getUserId());
            properties.put("com.openexchange.folderstorage.oldIdentifier", oldId);
            properties.put("com.openexchange.folderstorage.newIdentifier", newId);
            properties.put("com.openexchange.folderstorage.delimiter", delim);
            properties.put("com.openexchange.folderstorage.immediately", Boolean.TRUE);
            Event event = new Event("com/openexchange/folderstorage/identifiers", properties);
            eventAdmin.postEvent(event);
        }
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, StorageParameters params) {
        MailFolderStorage.postEvent(accountId, fullname, contentRelated, false, params);
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, params.getSession()));
    }

    private static void postEvent(String topic, int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(topic, params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, params.getSession()));
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, boolean async, StorageParameters params) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(params.getContextId(), params.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, params.getSession()).setAsync(async));
    }

    protected static void closeMailAccess(MailAccess<?, ?> mailAccess) {
        if (null != mailAccess) {
            mailAccess.close(true);
        }
    }

    private static void addWarnings(MailAccess<?, ?> mailAccess, StorageParameters storageParameters) {
        Collection<OXException> warnings = mailAccess.getWarnings();
        if (!warnings.isEmpty()) {
            for (OXException OXException2 : warnings) {
                storageParameters.addWarning(OXException2);
            }
        }
    }

    private static <E> List<E> stripNullElementsFrom(List<E> list) {
        if (null == list || list.isEmpty()) {
            return list;
        }
        ArrayList<E> ret = new ArrayList<E>(list.size());
        for (E element : list) {
            if (null == element) continue;
            ret.add(element);
        }
        return ret;
    }

    private static void checkFolderName(String name) throws OXException {
        if (MailFolderStorage.isEmpty(name)) {
            throw MailExceptionCode.INVALID_FOLDER_NAME_EMPTY.create();
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            if (INVALID.indexOf(name.charAt(i)) < 0) continue;
            throw MailExceptionCode.INVALID_FOLDER_NAME2.create(name);
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static final class MailFolderComparator
    implements Comparator<MailFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        public MailFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getFullname()).compareTo(this.getNumberOf(o2.getFullname()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class SimpleMailFolderComparator
    implements Comparator<MailFolder> {
        private final Collator collator;

        public SimpleMailFolderComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MailFolder o1, MailFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class MailAccountComparator
    implements Comparator<MailAccount> {
        private final Collator collator;

        public MailAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(MailAccount o1, MailAccount o2) {
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o1.getMailProtocol())) {
                if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                    return 0;
                }
                return -1;
            }
            if (UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(o2.getMailProtocol())) {
                return 1;
            }
            if (o1.isDefaultAccount()) {
                if (o2.isDefaultAccount()) {
                    return 0;
                }
                return -1;
            }
            if (o2.isDefaultAccount()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }
}

