/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.DatabasePermission;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.database.contentType.UnboundContentType;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.log.Log;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;

public class DatabaseFolder
extends AbstractFolder {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(DatabaseFolder.class);
    private static final long serialVersionUID = -4035221612481906228L;
    private boolean cacheable;
    protected boolean global;

    public DatabaseFolder(boolean cacheable) {
        this.cacheable = cacheable;
        this.global = true;
        this.subscribed = true;
    }

    public DatabaseFolder(FolderObject folderObject) {
        this(folderObject, true);
    }

    public DatabaseFolder(FolderObject folderObject, boolean cacheable) {
        this.cacheable = cacheable;
        this.global = true;
        this.id = String.valueOf(folderObject.getObjectID());
        this.name = folderObject.getFolderName();
        this.parent = String.valueOf(folderObject.getParentFolderID());
        this.type = DatabaseFolder.getType(folderObject.getType());
        this.contentType = DatabaseFolder.getContentType(folderObject.getModule());
        OCLPermission[] oclPermissions = folderObject.getPermissionsAsArray();
        this.permissions = new Permission[oclPermissions.length];
        for (int i = 0; i < oclPermissions.length; ++i) {
            this.permissions[i] = new DatabasePermission(oclPermissions[i]);
        }
        this.createdBy = folderObject.getCreatedBy();
        this.modifiedBy = folderObject.getModifiedBy();
        Date d = folderObject.getCreationDate();
        this.creationDate = null == d ? null : new Date(d.getTime());
        d = folderObject.getLastModified();
        this.lastModified = null == d ? null : new Date(d.getTime());
        this.subscribed = true;
        this.deefault = folderObject.isDefaultFolder();
        this.defaultType = this.deefault ? this.contentType.getModule() : 0;
    }

    @Override
    public Object clone() {
        DatabaseFolder clone = (DatabaseFolder)super.clone();
        clone.cacheable = this.cacheable;
        clone.global = this.global;
        return clone;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    private static Type getType(int type) {
        if (5 == type) {
            return SystemType.getInstance();
        }
        if (1 == type) {
            return PrivateType.getInstance();
        }
        if (2 == type) {
            return PublicType.getInstance();
        }
        if (5 == type) {
            return SystemType.getInstance();
        }
        return null;
    }

    private static ContentType getContentType(int module) {
        if (5 == module) {
            return SystemContentType.getInstance();
        }
        if (2 == module) {
            return CalendarContentType.getInstance();
        }
        if (3 == module) {
            return ContactContentType.getInstance();
        }
        if (1 == module) {
            return TaskContentType.getInstance();
        }
        if (8 == module) {
            return InfostoreContentType.getInstance();
        }
        if (4 == module) {
            return UnboundContentType.getInstance();
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unknown database folder content type: " + module));
        }
        return SystemContentType.getInstance();
    }

    @Override
    public boolean isGlobalID() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }
}

