/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.java.StringAllocator;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractFolder
implements Folder,
Serializable {
    private static final long serialVersionUID = 11110622220507954L;
    protected int createdBy = -1;
    protected int modifiedBy = -1;
    protected Date creationDate;
    protected Date lastModified;
    protected String treeId;
    protected String id;
    protected String newId;
    protected String name;
    protected String parent;
    protected Permission[] permissions;
    protected String[] subfolders;
    protected boolean subscribed;
    protected boolean subscribedSubfolders;
    protected ContentType contentType;
    protected Type type;
    protected String summary;
    protected int total = -1;
    protected int nu = -1;
    protected int unread = -1;
    protected int deleted = -1;
    protected int capabilities = -1;
    protected int bits = -1;
    protected boolean deefault;
    protected int defaultType = 0;

    protected AbstractFolder() {
    }

    public String toString() {
        return new StringAllocator(32).append("{ name=").append(this.getName()).append(", id=").append(this.getID()).append('}').toString();
    }

    @Override
    public Object clone() {
        try {
            int i;
            AbstractFolder clone = (AbstractFolder)super.clone();
            if (this.creationDate != null) {
                clone.creationDate = new Date(this.creationDate.getTime());
            }
            if (this.lastModified != null) {
                clone.lastModified = new Date(this.lastModified.getTime());
            }
            if (this.permissions != null) {
                Permission[] thisPermissions = this.permissions;
                Permission[] clonePermissions = new Permission[thisPermissions.length];
                for (i = 0; i < thisPermissions.length; ++i) {
                    clonePermissions[i] = (Permission)thisPermissions[i].clone();
                }
                clone.permissions = clonePermissions;
            }
            if (this.subfolders != null) {
                String[] thisSub = this.subfolders;
                String[] cloneSub = new String[thisSub.length];
                for (i = 0; i < cloneSub.length; ++i) {
                    cloneSub[i] = thisSub[i];
                }
                clone.subfolders = cloneSub;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public int getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public int getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate == null ? null : new Date(this.creationDate.getTime());
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = null == creationDate ? null : new Date(creationDate.getTime());
    }

    @Override
    public Date getLastModified() {
        return this.lastModified == null ? null : new Date(this.lastModified.getTime());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = null == lastModified ? null : new Date(lastModified.getTime());
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getNewID() {
        return this.newId;
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentID() {
        return this.parent;
    }

    @Override
    public Permission[] getPermissions() {
        return this.permissions;
    }

    @Override
    public String[] getSubfolderIDs() {
        return this.subfolders;
    }

    @Override
    public String getTreeID() {
        return this.treeId;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void setNewID(String newId) {
        this.newId = newId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParentID(String parentId) {
        this.parent = parentId;
    }

    @Override
    public void setPermissions(Permission[] permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setSubfolderIDs(String[] subfolderIds) {
        this.subfolders = subfolderIds;
    }

    @Override
    public void setTreeID(String id) {
        this.treeId = id;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscribed;
    }

    @Override
    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    @Override
    public boolean hasSubscribedSubfolders() {
        return this.subscribedSubfolders;
    }

    @Override
    public void setSubscribedSubfolders(boolean subscribedSubfolders) {
        this.subscribedSubfolders = subscribedSubfolders;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public int getNew() {
        return this.nu;
    }

    @Override
    public void setNew(int nu) {
        this.nu = nu;
    }

    @Override
    public int getUnread() {
        return this.unread;
    }

    @Override
    public void setUnread(int unread) {
        this.unread = unread;
    }

    @Override
    public int getDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isDefault() {
        return this.deefault;
    }

    @Override
    public void setDefault(boolean deefault) {
        this.deefault = deefault;
    }

    @Override
    public int getDefaultType() {
        return this.defaultType;
    }

    @Override
    public void setDefaultType(int defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public int getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void setCapabilities(int capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void setBits(int bits) {
        this.bits = bits;
    }
}

