/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.filemanagement.internal.FileRemovedListener;
import com.openexchange.filemanagement.internal.FileRemovedRegistry;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

final class CallbackInputStream
extends InputStream
implements FileRemovedListener {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CallbackInputStream.class));
    private final InputStream delegate;
    private final FileRemovedRegistry reg;
    private volatile boolean closed;

    CallbackInputStream(InputStream delegate, FileRemovedRegistry reg) {
        this.delegate = delegate;
        this.reg = reg;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed.");
        }
        this.reg.touch();
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed.");
        }
        this.reg.touch();
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed.");
        }
        this.reg.touch();
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed.");
        }
        this.reg.touch();
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        this.reg.touch();
        return this.delegate.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) {
        if (this.closed) {
            return;
        }
        this.delegate.mark(readAheadLimit);
        this.reg.touch();
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed.");
        }
        this.delegate.reset();
        this.reg.touch();
    }

    @Override
    public void close() throws IOException {
        this.reg.removeListener(this);
        this.close0();
    }

    @Override
    public void removePerformed(File file) {
        try {
            this.close0();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close0() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.delegate.close();
        }
        finally {
            this.closed = true;
        }
    }
}

