/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.Consistency;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import java.util.ArrayList;
import java.util.List;

public class OsgiOXConsistency
extends Consistency {
    private DatabaseImpl database;

    @Override
    protected Context getContext(int contextId) throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        return ctxstor.getContext(contextId);
    }

    @Override
    protected DatabaseImpl getDatabase() {
        if (this.database == null) {
            this.database = new DatabaseImpl(new DBPoolProvider());
        }
        return this.database;
    }

    @Override
    protected AttachmentBase getAttachments() {
        return Attachments.getInstance();
    }

    @Override
    protected FileStorage getFileStorage(Context ctx) throws OXException {
        return QuotaFileStorage.getInstance(FilestoreStorage.createURI(ctx), ctx);
    }

    @Override
    protected List<Context> getContextsForFilestore(final int filestoreId) throws OXException {
        return this.filter(this.getAllContexts(), new Filter(){

            @Override
            public boolean accepts(Context ctx) {
                return ctx.getFilestoreId() == filestoreId;
            }
        });
    }

    @Override
    protected List<Context> getContextsForDatabase(int databaseId) throws OXException {
        DatabaseService configDB = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        int[] contextIds = configDB.listContexts(databaseId);
        ArrayList<Integer> ctxIds = new ArrayList<Integer>(contextIds.length);
        for (int i = 0; i < contextIds.length; ++i) {
            ctxIds.add(Autoboxing.I((int)contextIds[i]));
        }
        return this.loadContexts(ctxIds);
    }

    private List<Context> filter(List<Context> contexts, Filter filter) {
        ArrayList<Context> filtered = new ArrayList<Context>();
        for (Context ctx : contexts) {
            if (!filter.accepts(ctx)) continue;
            filtered.add(ctx);
        }
        return filtered;
    }

    @Override
    protected List<Context> getAllContexts() throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        List<Integer> list = ctxstor.getAllContextIds();
        return this.loadContexts(list);
    }

    private List<Context> loadContexts(List<Integer> list) throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        ArrayList<Context> contexts = new ArrayList<Context>(list.size());
        for (int id : list) {
            contexts.add(ctxstor.getContext(id));
        }
        return contexts;
    }

    @Override
    protected User getAdmin(Context ctx) throws OXException {
        return UserStorage.getStorageUser(ctx.getMailadmin(), ctx);
    }

    private static interface Filter {
        public boolean accepts(Context var1);
    }
}

