/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXResultDecorator;
import com.openexchange.ajax.requesthandler.AJAXResultDecoratorRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class DecoratingAJAXActionCustomizer
implements AJAXActionCustomizer {
    static final AtomicReference<AJAXResultDecoratorRegistry> REGISTRY_REF = new AtomicReference();
    private static final DecoratingAJAXActionCustomizer INSTANCE = new DecoratingAJAXActionCustomizer();

    public static DecoratingAJAXActionCustomizer getInstance() {
        return INSTANCE;
    }

    private DecoratingAJAXActionCustomizer() {
    }

    @Override
    public AJAXRequestData incoming(AJAXRequestData requestData, ServerSession session) throws OXException {
        return requestData;
    }

    @Override
    public AJAXRequestResult outgoing(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        AJAXResultDecoratorRegistry registry = REGISTRY_REF.get();
        if (null == registry) {
            return result;
        }
        List<String> decoratorIds = requestData.getDecoratorIds();
        if (null == decoratorIds || decoratorIds.isEmpty()) {
            return result;
        }
        for (String decoratorId : decoratorIds) {
            AJAXResultDecorator decorator = registry.getDecorator(decoratorId);
            if (null == decorator || !decorator.getFormat().equals(result.getFormat())) continue;
            decorator.decorate(requestData, result, session);
        }
        return result;
    }
}

