/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.osgi;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.osgi.HousekeepingActivator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public abstract class AbstractServletActivator
extends HousekeepingActivator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbstractServletActivator.class));
    private final List<String> servlets = new ArrayList<String>();

    protected void registerServlet(String alias, HttpServlet servlet, HttpService httpService) {
        this.registerServlet(alias, servlet, null, httpService);
    }

    protected void registerServlet(String alias, HttpServlet servlet, Dictionary<String, String> params, HttpService httpService) {
        try {
            httpService.registerServlet(alias, (Servlet)servlet, params, null);
            this.servlets.add(alias);
        }
        catch (ServletException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamespaceException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void cleanUp() {
        this.unregisterServlets();
        super.cleanUp();
    }

    private void unregisterServlets() {
        HttpService httpService = (HttpService)this.getService(HttpService.class);
        if (null != httpService) {
            for (String servlet : this.servlets) {
                httpService.unregister(servlet);
            }
        }
    }

    protected void unregisterServlet(String alias) {
        HttpService httpService = (HttpService)this.getService(HttpService.class);
        if (null != httpService) {
            httpService.unregister(alias);
        }
        this.servlets.remove(alias);
    }
}

