/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.container.TmpFileFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ThresholdFileHolder
implements IFileHolder {
    public static final int DEFAULT_IN_MEMORY_THRESHOLD = 512000;
    private ByteArrayOutputStream buf;
    private long count = 0L;
    private File tempFile;
    private String name;
    private String contentType;
    private String disposition;
    private String delivery;
    private final int threshold;
    private final int initalCapacity;

    public ThresholdFileHolder() {
        this(-1, -1);
    }

    public ThresholdFileHolder(int threshold) {
        this(threshold, -1);
    }

    public ThresholdFileHolder(int threshold, int initalCapacity) {
        this.threshold = threshold > 0 ? threshold : 512000;
        this.contentType = "application/octet-stream";
        this.initalCapacity = initalCapacity > 0 ? initalCapacity : 2048;
    }

    public OutputStream asOutputStream() {
        return new TransferringOutStream(this);
    }

    public ThresholdFileHolder write(byte[] bytes, int off, int len) throws OXException {
        if (bytes == null) {
            return this;
        }
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        return this.write((InputStream)new UnsynchronizedByteArrayInputStream(bytes, off, len));
    }

    public ThresholdFileHolder write(byte[] bytes) throws OXException {
        block5: {
            File tempFile;
            if (bytes == null) {
                return this;
            }
            if (null != this.tempFile || null != this.buf || bytes.length <= this.threshold) break block5;
            this.tempFile = tempFile = TmpFileFileHolder.newTempFile();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                ((OutputStream)out).write(bytes, 0, bytes.length);
                out.flush();
            }
            catch (IOException e) {
                try {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    Streams.close(out);
                    throw throwable;
                }
            }
            Streams.close((Closeable)out);
            return this;
        }
        return this.write(Streams.newByteArrayInputStream((byte[])bytes));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThresholdFileHolder write(InputStream in) throws OXException {
        if (null == in) {
            return this;
        }
        OutputStream out = null;
        try {
            File tempFile = this.tempFile;
            long count = this.count;
            if (null == tempFile) {
                int len;
                ByteArrayOutputStream baos = this.buf;
                if (null == baos) {
                    this.buf = baos = Streams.newByteArrayOutputStream((int)this.initalCapacity);
                }
                out = baos;
                int inMemoryThreshold = this.threshold;
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = in.read(buffer, 0, 65535)) > 0) {
                    if (null == tempFile && (count += (long)len) > (long)inMemoryThreshold) {
                        this.tempFile = tempFile = TmpFileFileHolder.newTempFile();
                        out = new FileOutputStream(tempFile);
                        out.write(baos.toByteArray());
                        baos = null;
                        this.buf = null;
                    }
                    out.write(buffer, 0, len);
                }
                out.flush();
            } else {
                int len;
                out = new FileOutputStream(tempFile);
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = in.read(buffer, 0, 65535)) > 0) {
                    count += (long)len;
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            this.count = count;
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Streams.close((Closeable)in);
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close((Closeable)in);
        Streams.close((Closeable)out);
        return this;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public boolean repetitive() {
        return true;
    }

    @Override
    public void close() {
        File tempFile = this.tempFile;
        if (null != tempFile) {
            tempFile.delete();
            this.tempFile = null;
        }
        this.buf = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] toByteArray() throws OXException {
        byte[] byArray;
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return buf.toByteArray();
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            IOException e = new IOException("Already closed.");
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(tempFile);
            ByteArrayOutputStream baos = Streams.newByteArrayOutputStream((int)((InputStream)in).available());
            int buflen = 65535;
            byte[] buffer = new byte[65535];
            while ((len = ((InputStream)in).read(buffer, 0, 65535)) > 0) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(in);
                throw throwable;
            }
        }
        Streams.close((Closeable)in);
        return byArray;
    }

    @Override
    public InputStream getStream() throws OXException {
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return Streams.asInputStream((ByteArrayOutputStream)buf);
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            IOException e = new IOException("Already closed.");
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        try {
            return new FileInputStream(tempFile);
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public long getLength() {
        ByteArrayOutputStream buf = this.buf;
        if (null != buf) {
            return buf.size();
        }
        File tempFile = this.tempFile;
        if (null == tempFile) {
            throw new IllegalStateException("Already closed.");
        }
        return tempFile.length();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    private static final class TransferringOutStream
    extends OutputStream {
        private final ThresholdFileHolder fileHolder;

        TransferringOutStream(ThresholdFileHolder fileHolder) {
            this.fileHolder = fileHolder;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.fileHolder.write(new byte[]{(byte)b});
            }
            catch (OXException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fileHolder.write(b, off, len);
            }
            catch (OXException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }
    }
}

