/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.QuotaRequest;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONValue;

public class Quota
extends SessionServlet {
    private static final transient Log LOG = LogFactory.getLog(Quota.class);
    private static final long serialVersionUID = 6477434510302882905L;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSession session = Quota.getSessionObject((ServletRequest)req);
        Response response = new Response(session);
        try {
            String action = req.getParameter("action");
            if (null == action) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("action");
            }
            QuotaRequest fsReq = new QuotaRequest(session);
            JSONValue responseObj = fsReq.action(action);
            response.setData(responseObj);
        }
        catch (JSONException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        this.writeResponse(response, res, session);
    }
}

