/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.request.AttachmentRequest;
import com.openexchange.ajax.request.FolderRequest;
import com.openexchange.ajax.request.JSONSimpleRequest;
import com.openexchange.ajax.request.MailRequest;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.MultipleAdapter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.Streams;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.multiple.PathAware;
import com.openexchange.multiple.internal.MultipleHandlerRegistry;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.BoundedCompletionService;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class Multiple
extends SessionServlet {
    private static final long serialVersionUID = 3029074251138469122L;
    private static final transient Log LOG = com.openexchange.log.Log.loggerFor(Multiple.class);
    private static final String ACTION = "action";
    protected static final String MODULE = "module";
    protected static final String MODULE_FOLDER = "folder";
    protected static final String MODULE_FOLDERS = "folders";
    private static final String ATTRIBUTE_MAIL_INTERFACE = "mi";
    private static final String ATTRIBUTE_MAIL_REQUEST = "mr";
    private static volatile Dispatcher dispatcher;
    private static final int CONCURRENCY_LEVEL = 5;
    private static final Pattern SPLIT;
    private static final String HOSTNAME = "__hostname";
    private static final String ROUTE = "__route";
    private static final String REMOTE_ADDRESS = "__remoteAddress";

    public static void setDispatcher(Dispatcher dispatcher) {
        Multiple.dispatcher = dispatcher;
    }

    private static Dispatcher getDispatcher() {
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONArray dataArray;
        Reader reader = AJAXServlet.getReaderFor(req);
        try {
            dataArray = new JSONArray(reader);
        }
        catch (JSONException e) {
            OXException exc = OXJSONExceptionCodes.JSON_READ_ERROR.create(e, e.getMessage());
            LOG.warn((Object)(exc.getMessage() + Tools.logHeaderForError(req)), (Throwable)exc);
            dataArray = new JSONArray();
        }
        finally {
            Streams.close((Closeable)reader);
        }
        ServerSession session = Multiple.getSessionObject((ServletRequest)req);
        if (session == null) {
            OXException e = AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            this.log("Error while writing response object.", e);
            Multiple.sendError(resp);
        }
        try {
            JSONArray respArr = null;
            try {
                respArr = Multiple.perform(dataArray, req, session);
            }
            catch (JSONException e) {
                Multiple.logError("Error while writing response object.", session, (Exception)((Object)e));
                Multiple.sendError(resp);
            }
            catch (OXException e) {
                Multiple.logError("Error while writing response object.", session, (Exception)((Object)e));
                Multiple.sendError(resp);
            }
            catch (RuntimeException e) {
                Multiple.logError("Error while writing response object.", session, e);
                Multiple.sendError(resp);
            }
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            PrintWriter writer = resp.getWriter();
            Multiple.writeTo(null == respArr ? new JSONArray(0) : respArr, writer);
            ((Writer)writer).flush();
        }
        finally {
            LogProperties.removeLogProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray perform(JSONArray dataArray, HttpServletRequest req, ServerSession session) throws OXException, JSONException {
        int length = dataArray.length();
        JSONArray respArr = new JSONArray(length);
        if (length > 0) {
            AJAXState state = null;
            try {
                int pos;
                ArrayList<JsonInOut> serialTasks = null;
                CompletionService concurrentTasks = null;
                int concurrentTasksCount = 0;
                ConcurrentTIntObjectHashMap mapping = new ConcurrentTIntObjectHashMap(length);
                for (pos = 0; pos < length; ++pos) {
                    JSONObject dataObject = dataArray.getJSONObject(pos);
                    JsonInOut jsonInOut = new JsonInOut(pos, dataObject);
                    mapping.put(pos, (Object)jsonInOut);
                    if (!dataObject.hasAndNotNull(MODULE)) {
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create(MODULE);
                    }
                    String module = dataObject.getString(MODULE);
                    if ("mail".equals(module)) {
                        if (null == serialTasks) {
                            serialTasks = new ArrayList<JsonInOut>(length);
                        }
                        serialTasks.add(jsonInOut);
                        continue;
                    }
                    if (null == concurrentTasks) {
                        int concurrencyLevel = 5;
                        concurrentTasks = length <= 5 ? new ThreadPoolCompletionService(ThreadPools.getThreadPool()).setTrackable(true) : new BoundedCompletionService(ThreadPools.getThreadPool(), 5).setTrackable(true);
                    }
                    concurrentTasks.submit(new CallableImpl(jsonInOut, session, module, req));
                    ++concurrentTasksCount;
                }
                if (null != serialTasks) {
                    int size = serialTasks.size();
                    JSONArray serialResponses = new JSONArray(size);
                    for (JsonInOut jsonInOut : serialTasks) {
                        state = Multiple.parseActionElement(jsonInOut.getInputObject(), serialResponses, session, req, state);
                    }
                    Multiple.writeMailRequest(req);
                    for (int i = 0; i < size; ++i) {
                        ((JsonInOut)serialTasks.get(i)).setOutputObject((JSONValue)serialResponses.get(i));
                    }
                }
                if (null != concurrentTasks) {
                    for (int i = 0; i < concurrentTasksCount; ++i) {
                        try {
                            concurrentTasks.take();
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                        }
                    }
                }
                for (pos = 0; pos < length; ++pos) {
                    JsonInOut jsonInOut = (JsonInOut)mapping.get(pos);
                    if (null == jsonInOut) continue;
                    respArr.put((Object)jsonInOut.getOutputObject());
                }
            }
            finally {
                Multiple.close((MailServletInterface)req.getAttribute(ATTRIBUTE_MAIL_INTERFACE));
                if (state != null) {
                    Multiple.getDispatcher().end(state);
                }
            }
        }
        return respArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void performActionElement(JsonInOut jsonInOut, String module, ServerSession session, HttpServletRequest req) {
        AJAXState ajaxState = null;
        try {
            OXJSONWriter jWriter = new OXJSONWriter();
            JSONObject inObject = jsonInOut.getInputObject();
            ajaxState = Multiple.doAction(module, inObject.optString(ACTION), inObject, session, req, jWriter, null);
            jsonInOut.setOutputObject(jWriter.getObject());
        }
        finally {
            if (null != ajaxState) {
                ajaxState.close();
            }
        }
    }

    protected static final AJAXState parseActionElement(JSONObject inObject, JSONArray serialResponses, ServerSession session, HttpServletRequest req, AJAXState state) throws OXException {
        try {
            return Multiple.doAction(DataParser.checkString(inObject, MODULE), inObject.optString(ACTION), inObject, session, req, new OXJSONWriter(serialResponses), state);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeMailRequest(HttpServletRequest req) throws JSONException {
        MailRequest mailReq = (MailRequest)req.getAttribute(ATTRIBUTE_MAIL_REQUEST);
        if (mailReq != null) {
            try {
                mailReq.performMultiple((MailServletInterface)req.getAttribute(ATTRIBUTE_MAIL_INTERFACE));
            }
            finally {
                req.setAttribute(ATTRIBUTE_MAIL_REQUEST, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final AJAXState doAction(String module, String action, JSONObject jsonObj, ServerSession session, HttpServletRequest req, OXJSONWriter jsonWriter, AJAXState ajaxState) {
        AJAXState state = ajaxState;
        try {
            boolean handles;
            StringBuilder moduleCandidate;
            Dispatcher dispatcher;
            block48: {
                block49: {
                    block50: {
                        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
                        if (null == hostnameService) {
                            jsonObj.put(HOSTNAME, (Object)req.getServerName());
                        } else {
                            String hn = hostnameService.getHostname(session.getUserId(), session.getContextId());
                            jsonObj.put(HOSTNAME, (Object)(null == hn ? req.getServerName() : hn));
                        }
                        jsonObj.put(ROUTE, (Object)Tools.getRoute(req.getSession(true).getId()));
                        jsonObj.put(REMOTE_ADDRESS, (Object)req.getRemoteAddr());
                        dispatcher = Multiple.getDispatcher();
                        moduleCandidate = new StringBuilder(32);
                        handles = false;
                        for (String string : SPLIT.split(module, 0)) {
                            moduleCandidate.append(string);
                            handles = dispatcher.handles(moduleCandidate.toString());
                            if (handles) break;
                            moduleCandidate.append('/');
                        }
                        if (!"mail".equals(module)) break block48;
                        if (!action.equalsIgnoreCase("update")) break block49;
                        if (!MailRequest.isMove(jsonObj)) break block50;
                        handles = false;
                        break block48;
                    }
                    if (MailRequest.isStoreFlags(jsonObj)) {
                        handles = false;
                        break block48;
                    } else if (MailRequest.isColorLabel(jsonObj)) {
                        handles = false;
                    }
                    break block48;
                }
                if (action.equalsIgnoreCase("copy")) {
                    handles = false;
                }
            }
            if (handles) {
                AJAXRequestData request = MultipleAdapter.parse(moduleCandidate.toString(), module.substring(moduleCandidate.length()), action, jsonObj, session, Tools.considerSecure(req));
                jsonWriter.object();
                try {
                    AJAXRequestResult result;
                    if (action == null || action.length() == 0) {
                        request.setAction("GET");
                    }
                    if (state == null) {
                        state = dispatcher.begin();
                    }
                    if ((result = dispatcher.perform(request, state, session)).getTimestamp() != null) {
                        jsonWriter.key("timestamp");
                        jsonWriter.value(result.getTimestamp().getTime());
                    }
                    jsonWriter.key("data");
                    jsonWriter.value(result.getResultObject());
                    return state;
                }
                catch (OXException e) {
                    Multiple.logError(e.getMessage(), session, (Exception)((Object)e));
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session));
                    AJAXState aJAXState = state;
                    return aJAXState;
                }
                catch (RuntimeException rte) {
                    Multiple.logError(rte.getMessage(), session, rte);
                    OXException oXException = AjaxExceptionCodes.UNEXPECTED_ERROR.create(rte, rte.getMessage());
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session));
                    AJAXState aJAXState = state;
                    return aJAXState;
                }
                finally {
                    jsonWriter.endObject();
                }
            }
            MultipleHandler multipleHandler = Multiple.lookUpMultipleHandler(module);
            if (null != multipleHandler) {
                Multiple.writeMailRequest(req);
                jsonWriter.object();
                try {
                    Collection<OXException> collection;
                    Object tmp = multipleHandler.performRequest(action, jsonObj, session, Tools.considerSecure(req));
                    jsonWriter.key("data");
                    jsonWriter.value(tmp);
                    Date timestamp = multipleHandler.getTimestamp();
                    if (null != timestamp) {
                        jsonWriter.key("timestamp").value(timestamp.getTime());
                    }
                    if (null == (collection = multipleHandler.getWarnings())) return state;
                    if (collection.isEmpty()) return state;
                    ResponseWriter.writeException(collection.iterator().next(), jsonWriter, Multiple.localeFrom(session));
                    return state;
                }
                catch (OXException e) {
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session));
                    return state;
                }
                catch (JSONException e) {
                    OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    Multiple.logError(oje.getMessage(), session, (Exception)((Object)oje));
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(oje, jsonWriter, Multiple.localeFrom(session));
                    return state;
                }
                catch (RuntimeException rte) {
                    Multiple.logError(rte.getMessage(), session, rte);
                    OXException e = AjaxExceptionCodes.UNEXPECTED_ERROR.create(rte, rte.getMessage());
                    if (jsonWriter.isExpectingValue()) {
                        jsonWriter.value("");
                    }
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session));
                    return state;
                }
                finally {
                    multipleHandler.close();
                    jsonWriter.endObject();
                }
            }
            if (MODULE_FOLDER.equals(module) || MODULE_FOLDERS.equals(module)) {
                Multiple.writeMailRequest(req);
                FolderRequest folderequest = new FolderRequest(session, jsonWriter);
                try {
                    folderequest.action(action, jsonObj);
                    return state;
                }
                catch (OXException e) {
                    Multiple.logError(e.getMessage(), session, (Exception)((Object)e));
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session));
                    jsonWriter.endObject();
                    return state;
                }
                catch (JSONException e) {
                    OXException oXException = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    Multiple.logError(oXException.getMessage(), session, (Exception)((Object)oXException));
                    jsonWriter.object();
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session));
                    jsonWriter.endObject();
                    return state;
                }
                catch (RuntimeException rte) {
                    Multiple.logError(rte.getMessage(), session, rte);
                    OXException oXException = AjaxExceptionCodes.UNEXPECTED_ERROR.create(rte, rte.getMessage());
                    jsonWriter.object();
                    ResponseWriter.writeException(oXException, jsonWriter, Multiple.localeFrom(session));
                    jsonWriter.endObject();
                    return state;
                }
            }
            if ("mail".equals(module)) {
                try {
                    MailServletInterface mi;
                    boolean storeMailRequest;
                    MailRequest mailrequest;
                    Object object = req.getAttribute(ATTRIBUTE_MAIL_REQUEST);
                    if (object == null) {
                        mailrequest = new MailRequest(session, jsonWriter);
                        storeMailRequest = true;
                    } else {
                        mailrequest = (MailRequest)object;
                        storeMailRequest = false;
                    }
                    Object object2 = req.getAttribute(ATTRIBUTE_MAIL_INTERFACE);
                    if (object2 == null) {
                        mi = MailServletInterface.getInstance(session);
                        req.setAttribute(ATTRIBUTE_MAIL_INTERFACE, (Object)mi);
                    } else {
                        mi = (MailServletInterface)object2;
                    }
                    mailrequest.action(action, jsonObj, mi);
                    if (!mailrequest.isContiguousCollect()) return state;
                    if (!storeMailRequest) return state;
                    req.setAttribute(ATTRIBUTE_MAIL_REQUEST, (Object)mailrequest);
                    return state;
                }
                catch (OXException e) {
                    Multiple.logError(e.getMessage(), session, (Exception)((Object)e));
                    jsonWriter.object();
                    ResponseWriter.writeException(e, jsonWriter, Multiple.localeFrom(session));
                    jsonWriter.endObject();
                    return state;
                }
                catch (JSONException e) {
                    OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    Multiple.logError(oje.getMessage(), session, (Exception)((Object)oje));
                    jsonWriter.object();
                    ResponseWriter.writeException(oje, jsonWriter, Multiple.localeFrom(session));
                    jsonWriter.endObject();
                    return state;
                }
            }
            if ("attachment".equals(module)) {
                AttachmentRequest request = new AttachmentRequest(session, jsonWriter);
                request.action(action, new JSONSimpleRequest(jsonObj));
                return state;
            }
            OXException oxe = AjaxExceptionCodes.UNKNOWN_MODULE.create(module);
            Multiple.logError(oxe.getMessage(), session, (Exception)((Object)oxe));
            jsonWriter.object();
            ResponseWriter.writeException(oxe, jsonWriter, Multiple.localeFrom(session));
            jsonWriter.endObject();
            return state;
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return state;
    }

    private static MultipleHandler lookUpMultipleHandler(String module) {
        MultipleHandlerFactoryService factoryService;
        MultipleHandlerRegistry registry = ServerServiceRegistry.getInstance().getService(MultipleHandlerRegistry.class);
        if (null != registry && null != (factoryService = registry.getFactoryService(module))) {
            MultipleHandler multipleHandler = factoryService.createMultipleHandler();
            if (PathAware.class.isInstance(multipleHandler)) {
                PathAware pa = (PathAware)((Object)multipleHandler);
                pa.setPath(module.substring(factoryService.getSupportedModule().length()));
            }
            return multipleHandler;
        }
        return null;
    }

    private static void writeTo(JSONArray respArr, Writer writer) throws IOException {
        try {
            respArr.write(writer);
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void close(MailServletInterface mi) {
        if (mi != null) {
            try {
                mi.close(true);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void logError(Object message, Session session, Exception e) {
        LogProperties.putSessionProperties((Session)session);
        LOG.error(message, (Throwable)e);
    }

    static {
        SPLIT = Pattern.compile("/");
    }

    private static final class JsonInOut {
        private final int pos;
        private final JSONObject inObject;
        private volatile JSONValue outObject;

        protected JsonInOut(int pos, JSONObject inObject) {
            this.pos = pos;
            this.inObject = inObject;
        }

        public int getPos() {
            return this.pos;
        }

        public JSONObject getInputObject() {
            return this.inObject;
        }

        public JSONValue getOutputObject() {
            return this.outObject;
        }

        public void setOutputObject(JSONValue outObject) {
            this.outObject = outObject;
        }
    }

    private static final class CallableImpl
    implements Callable<Object> {
        private final JsonInOut jsonDataResponse;
        private final ServerSession session;
        private final String module;
        private final HttpServletRequest req;

        protected CallableImpl(JsonInOut jsonDataResponse, ServerSession session, String module, HttpServletRequest req) {
            this.jsonDataResponse = jsonDataResponse;
            this.session = session;
            this.module = module;
            this.req = req;
        }

        @Override
        public Object call() throws OXException {
            try {
                Multiple.performActionElement(this.jsonDataResponse, this.module, this.session, this.req);
                return null;
            }
            catch (RuntimeException e) {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }
}

