/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.osgi;

import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGIMessagingServiceRegistry
implements MessagingServiceRegistry {
    final ConcurrentMap<String, MessagingService> map = new ConcurrentHashMap<String, MessagingService>(8);
    private ServiceTracker<MessagingService, MessagingService> tracker;
    private ServiceTracker<ConfigViewFactory, ConfigViewFactory> configTracker;

    public void start(BundleContext context) {
        if (null == this.tracker) {
            this.tracker = new ServiceTracker(context, MessagingService.class, (ServiceTrackerCustomizer)new Customizer(context));
            this.tracker.open();
        }
        if (null == this.configTracker) {
            this.configTracker = new ServiceTracker(context, ConfigViewFactory.class, null);
            this.configTracker.open();
        }
    }

    public void stop() {
        if (null != this.tracker) {
            this.tracker.close();
            this.tracker = null;
        }
        if (null != this.configTracker) {
            this.configTracker.close();
            this.configTracker = null;
        }
    }

    @Override
    public List<MessagingService> getAllServices(int user, int context) throws OXException {
        return this.filter(new ArrayList<MessagingService>(this.map.values()), user, context);
    }

    @Override
    public MessagingService getMessagingService(String id, int user, int context) throws OXException {
        MessagingService messagingService = (MessagingService)this.map.get(id);
        if (null == messagingService || !this.isAllowed(id, user, context)) {
            throw MessagingExceptionCodes.UNKNOWN_MESSAGING_SERVICE.create(id);
        }
        return messagingService;
    }

    private boolean isAllowed(String id, int user, int context) throws OXException {
        if (user == -1 && context == -1) {
            return true;
        }
        ConfigView configView = this.getView(user, context);
        if (!this.isMessagingEnabled(configView)) {
            return false;
        }
        ComposedConfigProperty configProperty = configView.property(id, Boolean.TYPE);
        return !configProperty.isDefined() || (Boolean)configProperty.get() != false;
    }

    private List<MessagingService> filter(List<MessagingService> arrayList, int user, int context) throws OXException {
        ArrayList<MessagingService> filteredList = new ArrayList<MessagingService>(arrayList.size());
        ConfigView configView = this.getView(user, context);
        if (!this.isMessagingEnabled(configView)) {
            return Collections.emptyList();
        }
        for (MessagingService messagingService : arrayList) {
            ComposedConfigProperty configProperty = configView.property(messagingService.getId(), Boolean.TYPE);
            if (configProperty.isDefined() && !((Boolean)configProperty.get()).booleanValue()) continue;
            filteredList.add(messagingService);
        }
        return filteredList;
    }

    private boolean isMessagingEnabled(ConfigView configView) throws OXException {
        ComposedConfigProperty configProperty = configView.property("com.openexchange.messaging.enabled", Boolean.TYPE);
        if (!configProperty.isDefined() || ((Boolean)configProperty.get()).booleanValue()) {
            return true;
        }
        return false;
    }

    private ConfigView getView(int user, int context) throws OXException {
        ConfigViewFactory service = (ConfigViewFactory)this.configTracker.getService();
        return service.getView(user, context);
    }

    @Override
    public boolean containsMessagingService(String id, int user, int context) {
        try {
            return null == id ? false : this.map.containsKey(id) && this.isAllowed(id, user, context);
        }
        catch (OXException e) {
            return false;
        }
    }

    private final class Customizer
    implements ServiceTrackerCustomizer<MessagingService, MessagingService> {
        private final BundleContext context;

        Customizer(BundleContext context) {
            this.context = context;
        }

        public MessagingService addingService(ServiceReference<MessagingService> reference) {
            MessagingService service = (MessagingService)this.context.getService(reference);
            MessagingService addMe = service;
            if (null == OSGIMessagingServiceRegistry.this.map.putIfAbsent(addMe.getId(), addMe)) {
                return service;
            }
            Log logger = LogFactory.getLog(Customizer.class);
            if (logger.isWarnEnabled()) {
                logger.warn((Object)new StringBuilder(128).append("Messaging service ").append(addMe.getDisplayName()).append(" could not be added to registry. Another service is already registered with identifier: ").append(addMe.getId()).toString());
            }
            this.context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<MessagingService> reference, MessagingService service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<MessagingService> reference, MessagingService service) {
            if (null != service) {
                try {
                    MessagingService removeMe = service;
                    OSGIMessagingServiceRegistry.this.map.remove(removeMe.getId());
                }
                finally {
                    this.context.ungetService(reference);
                }
            }
        }
    }
}

