/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class AsciiWriter
extends Writer {
    private final OutputStream out;

    public AsciiWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write((byte)c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (null == cbuf) {
            throw new NullPointerException("cbuf is null.");
        }
        int len = cbuf.length;
        if (len == 0) {
            return;
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)cbuf[i];
        }
        this.out.write(bytes, 0, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (null == cbuf) {
            throw new NullPointerException("cbuf is null.");
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)cbuf[off + i];
        }
        this.out.write(bytes, 0, len);
    }

    @Override
    public void write(String str) throws IOException {
        if (null == str) {
            throw new NullPointerException("str is null.");
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)str.charAt(i);
        }
        this.out.write(bytes, 0, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (null == str) {
            throw new NullPointerException("str is null.");
        }
        if (off < 0 || off > str.length() || len < 0 || off + len > str.length() || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)str.charAt(off + i);
        }
        this.out.write(bytes, 0, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

