/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.strings;

import com.openexchange.tools.strings.StringParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateStringParser
implements StringParser {
    private StringParser subParser;

    public DateStringParser() {
    }

    public DateStringParser(StringParser subParser) {
        this.subParser = subParser;
    }

    public void setSubParser(StringParser subParser) {
        this.subParser = subParser;
    }

    public StringParser getSubParser() {
        return this.subParser;
    }

    @Override
    public <T> T parse(String s, Class<T> t) {
        if (t != Date.class || s == null) {
            return null;
        }
        Long parsed = this.subParser.parse(s, Long.class);
        if (parsed != null) {
            return (T)new Date(parsed);
        }
        return (T)DateStringParser.parseDate(s);
    }

    private static Date parseDate(String data) {
        List<Locale> locales = Arrays.asList(Locale.US, Locale.UK, Locale.CANADA, Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN, Locale.CHINA);
        int[] styles = new int[]{0, 1, 2, 3};
        for (Locale loc : locales) {
            for (int dateStyle : styles) {
                for (int timeStyle : styles) {
                    DateFormat sdf = DateFormat.getDateTimeInstance(dateStyle, timeStyle, loc);
                    try {
                        return sdf.parse(data);
                    }
                    catch (ParseException e) {
                    }
                }
                DateFormat sdf = DateFormat.getDateInstance(dateStyle, loc);
                try {
                    return sdf.parse(data);
                }
                catch (ParseException e) {
                }
            }
        }
        DateFormat sdf = DateFormat.getInstance();
        try {
            return sdf.parse(data);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

