/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.exception.internal.I18n;
import com.openexchange.java.StringAllocator;
import com.openexchange.session.Session;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class OXException
extends Exception
implements OXExceptionConstants {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(OXException.class);
    private static final long serialVersionUID = 2058371531364916608L;
    private static final String DELIM = "\n\t";
    private static final int SERVER_ID = new SecureRandom().nextInt();
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final int count;
    private final Map<String, String> properties;
    private final List<Category> categories;
    private Object[] displayArgs;
    private int code;
    private final List<ProblematicAttribute> problematics;
    private String displayMessage;
    private String logMessage;
    private Object[] logArgs;
    private String exceptionId;
    private String prefix;
    private Generic generic;
    private LogLevel optLogLevel;
    private static final ProblematicAttribute[] EMPTY_PROBLEMATICS = new ProblematicAttribute[0];
    private static final Pattern P = Pattern.compile("(\\p{L}) {2,}(\\p{L})");

    public static int getServerId() {
        return SERVER_ID;
    }

    public static OXException general(String logMessage) {
        return new OXException(9999, "A severe error occurred.", new Object[0]).setLogMessage(logMessage).setCategory(CATEGORY_ERROR).setPrefix("OX");
    }

    public static OXException notFound(String id) {
        return new OXException(1, "Object not found. %1$s", id).setCategory(CATEGORY_USER_INPUT).setPrefix("OX").setGeneric(Generic.NOT_FOUND);
    }

    public static OXException noPermissionForModule(String module) {
        return new OXException(1, "No permission for module: %1$s.", module).setCategory(CATEGORY_USER_INPUT).setPrefix("OX").setGeneric(Generic.NO_PERMISSION);
    }

    public static OXException noPermissionForFolder() {
        return new OXException(1, "No folder permission.", new Object[0]).setCategory(CATEGORY_PERMISSION_DENIED).setPrefix("OX").setGeneric(Generic.NO_PERMISSION);
    }

    public static OXException mandatoryField(String name) {
        return new OXException(9999, "Missing field: %s", name).setCategory(CATEGORY_ERROR).setPrefix("OX").setGeneric(Generic.MANDATORY_FIELD);
    }

    public static OXException mandatoryField(int code, String name) {
        return new OXException(code, "Missing field: %s", name).setCategory(CATEGORY_ERROR).setPrefix("OX").setGeneric(Generic.MANDATORY_FIELD);
    }

    public static OXException conflict() {
        return new OXException(1, "The object has been changed in the meantime.", new Object[0]).setCategory(CATEGORY_CONFLICT).setPrefix("OX").setGeneric(Generic.CONFLICT);
    }

    public OXException() {
        this.generic = Generic.NONE;
        this.code = 9999;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(8);
        this.categories = new LinkedList<Category>();
        this.displayMessage = "A severe error occurred.";
        this.logMessage = null;
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
    }

    public OXException(Throwable cause) {
        super(cause);
        this.generic = Generic.NONE;
        this.code = 9999;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(8);
        this.categories = new LinkedList<Category>();
        this.displayMessage = "A severe error occurred.";
        this.logMessage = null;
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
    }

    public OXException(OXException cloneMe) {
        this.setStackTrace(cloneMe.getStackTrace());
        this.generic = cloneMe.generic;
        this.count = cloneMe.count;
        this.code = cloneMe.code;
        this.categories = null == cloneMe.categories ? new LinkedList() : new ArrayList<Category>(cloneMe.categories);
        this.displayArgs = cloneMe.displayArgs;
        this.displayMessage = cloneMe.displayMessage;
        this.exceptionId = cloneMe.exceptionId;
        this.logMessage = cloneMe.logMessage;
        this.prefix = cloneMe.prefix;
        this.problematics = null == cloneMe.problematics ? new LinkedList() : new ArrayList<ProblematicAttribute>(cloneMe.problematics);
        this.properties = null == cloneMe.properties ? new HashMap<String, String>(8) : new HashMap<String, String>(cloneMe.properties);
    }

    public OXException(int code) {
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(8);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = "A severe error occurred.";
        this.displayArgs = MESSAGE_ARGS_EMPTY;
        this.problematics = new LinkedList<ProblematicAttribute>();
    }

    public OXException(int code, String displayMessage, Object ... displayArgs) {
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(8);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = null == displayMessage ? "A severe error occurred." : displayMessage;
        this.displayArgs = null == displayArgs ? MESSAGE_ARGS_EMPTY : displayArgs;
        this.problematics = new LinkedList<ProblematicAttribute>();
    }

    public OXException(int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(cause);
        this.generic = Generic.NONE;
        this.count = COUNTER.incrementAndGet();
        this.properties = new HashMap<String, String>(8);
        this.categories = new LinkedList<Category>();
        this.code = code;
        this.displayMessage = null == displayMessage ? "A severe error occurred." : displayMessage;
        this.displayArgs = displayArgs;
        this.problematics = new ArrayList<ProblematicAttribute>(1);
    }

    public void copyFrom(OXException e) {
        this.code = e.code;
        this.generic = e.generic;
        this.categories.clear();
        this.categories.addAll(e.getCategories());
        this.displayArgs = e.displayArgs;
        this.displayMessage = e.displayMessage;
        this.exceptionId = e.exceptionId;
        this.logMessage = e.logMessage;
        this.prefix = e.prefix;
        this.problematics.clear();
        if (null != e.problematics) {
            this.problematics.addAll(e.problematics);
        }
        this.properties.clear();
        this.properties.putAll(e.properties);
    }

    public int getCode() {
        return this.code;
    }

    public Generic getGeneric() {
        return this.generic;
    }

    public boolean isGeneric(Generic generic) {
        return null != generic && generic.equals((Object)this.generic);
    }

    public boolean isNotFound() {
        return Generic.NOT_FOUND.equals((Object)this.generic);
    }

    public boolean isNoPermission() {
        return Generic.NO_PERMISSION.equals((Object)this.generic);
    }

    public boolean isMandatory() {
        return Generic.MANDATORY_FIELD.equals((Object)this.generic);
    }

    public boolean isConflict() {
        return Generic.CONFLICT.equals((Object)this.generic);
    }

    public OXException setGeneric(Generic generic) {
        this.generic = generic;
        return this;
    }

    public OXException setLogMessage(String logMessage) {
        this.logMessage = logMessage;
        return this;
    }

    public OXException setLogMessage(String displayFormat, Object ... args) {
        if (null == displayFormat) {
            return this;
        }
        try {
            this.logMessage = String.format(Locale.US, displayFormat, args);
            this.logArgs = args;
        }
        catch (NullPointerException e) {
            this.logMessage = null;
        }
        catch (IllegalFormatException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Exception logMe = new Exception(super.getMessage());
            logMe.setStackTrace(super.getStackTrace());
            LOG.error((Object)"Illegal message format.", (Throwable)logMe);
            this.logMessage = null;
        }
        return this;
    }

    public OXException setDisplayMessage(String displayMessage, Object ... displayArgs) {
        this.displayMessage = null == displayMessage ? "A severe error occurred." : displayMessage;
        this.displayArgs = null == displayArgs ? MESSAGE_ARGS_EMPTY : displayArgs;
        return this;
    }

    public String getPlainLogMessage() {
        return this.logMessage;
    }

    public Object[] getLogArgs() {
        return this.logArgs;
    }

    public Object[] getDisplayArgs() {
        return this.displayArgs;
    }

    public void log(Log log) {
        LogLevel logLevel = this.getCategories().get(0).getLogLevel();
        if (!logLevel.appliesTo(log)) {
            return;
        }
        String loggable = this.getLogMessage(logLevel, null);
        if (null == loggable) {
            return;
        }
        logLevel.log(loggable, this, log);
    }

    public String getLogMessage(LogLevel logLevel) {
        return this.getLogMessage(logLevel, null);
    }

    public String getLogMessage(LogLevel logLevel, String defaultLog) {
        if (!this.isLoggable(logLevel)) {
            return defaultLog;
        }
        return this.getLogMessage();
    }

    public String getLogMessage() {
        StringAllocator sb = new StringAllocator(256).append(this.getErrorCode());
        sb.append(" Categories=");
        List<Category> cats = this.getCategories();
        sb.append((Object)cats.get(0));
        int size = cats.size();
        for (int i = 1; i < size; ++i) {
            sb.append(',').append((Object)cats.get(i));
        }
        sb.append(" Message=");
        if (null == this.logMessage) {
            String str = this.getDisplayMessage0(Locale.US);
            if (null == str) {
                sb.append("[Not available]");
            } else {
                sb.append('\'').append(str).append('\'');
            }
        } else {
            sb.append('\'').append(this.logMessage).append('\'');
        }
        sb.append(" exceptionID=").append(this.getExceptionId());
        if (!this.properties.isEmpty()) {
            for (String propertyName : new TreeSet<String>(this.properties.keySet())) {
                sb.append(DELIM).append(propertyName).append(": ").append(this.properties.get(propertyName));
            }
        }
        return OXException.dropSubsequentWhitespaces(sb.toString());
    }

    public String getSoleMessage() {
        StringAllocator sb = new StringAllocator(256);
        if (null == this.logMessage) {
            String str = this.getDisplayMessage0(Locale.US);
            if (null == str) {
                sb.append("[Not available]");
            } else {
                sb.append(str);
            }
        } else {
            sb.append(this.logMessage);
        }
        return OXException.dropSubsequentWhitespaces(sb.toString());
    }

    public boolean isLoggable(LogLevel logLevel) {
        LogLevel thisLogLevel = this.optLogLevel;
        if (null == thisLogLevel) {
            return logLevel.implies(this.getCategories().get(0));
        }
        return logLevel.implies(thisLogLevel);
    }

    public Category getCategory() {
        return this.getCategories().get(0);
    }

    public List<Category> getCategories() {
        if (this.categories.isEmpty()) {
            return Collections.singletonList(CATEGORY_ERROR);
        }
        if (1 == this.categories.size()) {
            return Collections.unmodifiableList(this.categories);
        }
        OXException.sortCategories(this.categories);
        return Collections.unmodifiableList(this.categories);
    }

    public static void sortCategories(List<Category> categories) {
        List<ComparableCategory> comparables = OXException.toComparables(categories);
        Collections.sort(comparables);
        categories.clear();
        for (ComparableCategory comparable : comparables) {
            categories.add(comparable.category);
        }
    }

    private static List<ComparableCategory> toComparables(List<Category> categories) {
        ArrayList<ComparableCategory> ret = new ArrayList<ComparableCategory>(categories.size());
        for (Category category : categories) {
            ret.add(new ComparableCategory(category));
        }
        return ret;
    }

    public final OXException addCategory(Category category) {
        if (null != category) {
            if (this.categories.isEmpty() && Category.EnumType.TRY_AGAIN.equals(category.getType()) && "A severe error occurred.".equals(this.displayMessage)) {
                this.displayMessage = "An error occurred. Please try again later.";
            }
            this.categories.add(category);
        }
        return this;
    }

    public OXException setLogLevel(LogLevel logLevel) {
        this.optLogLevel = logLevel;
        return this;
    }

    public OXException setCategory(Category category) {
        if (null != category) {
            this.categories.clear();
            if (Category.EnumType.TRY_AGAIN.equals(category.getType()) && "A severe error occurred.".equals(this.displayMessage)) {
                this.displayMessage = "An error occurred. Please try again later.";
            }
            this.categories.add(category);
        }
        return this;
    }

    public void removeCategory(Category category) {
        this.categories.remove(category);
    }

    public String getExceptionId() {
        if (this.exceptionId == null) {
            this.exceptionId = new StringAllocator(16).append(SERVER_ID).append('-').append(this.count).toString();
        }
        return this.exceptionId;
    }

    public void setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    public String getPrefix() {
        return null == this.prefix ? "OX" : this.prefix;
    }

    public boolean isPrefix(String expected) {
        return (null == this.prefix ? "OX" : this.prefix).equals(expected);
    }

    public OXException setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public final String getErrorCode() {
        return new StringAllocator(this.getPrefix()).append('-').append(String.format("%04d", this.code)).toString();
    }

    public String getDisplayMessage(Locale locale) {
        String msg = this.getDisplayMessage0(locale);
        return msg == null ? "[Not available]" : msg;
    }

    private String getDisplayMessage0(Locale locale) {
        Locale lcl = null == locale ? Locale.US : locale;
        String msg = I18n.getInstance().translate(lcl, this.displayMessage);
        if (msg != null && this.displayArgs != null) {
            try {
                msg = String.format(lcl, msg, this.displayArgs);
            }
            catch (NullPointerException e) {
                msg = null;
            }
            catch (MissingFormatArgumentException e) {
                LOG.debug((Object)("Missing format argument: >>" + msg + "<<"), (Throwable)e);
            }
            catch (IllegalFormatException e) {
                LOG.error((Object)("Illegal message format: >>" + msg + "<<"), (Throwable)e);
            }
        }
        return OXException.dropSubsequentWhitespaces(msg);
    }

    public final boolean similarTo(OXExceptionCode exceptionCode) {
        return exceptionCode.getCategory() == this.getCategory() && exceptionCode.getNumber() == this.getCode();
    }

    public final boolean similarTo(OXException other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other.getCategory() == this.getCategory() && other.getCode() == this.getCode();
    }

    @Override
    public String getMessage() {
        return this.getLogMessage();
    }

    @Override
    public String toString() {
        return this.getLogMessage();
    }

    @Deprecated
    public void addTruncatedId(final int truncatedId) {
        this.problematics.add(new Truncated(){

            @Override
            public int getId() {
                return truncatedId;
            }

            @Override
            public int getLength() {
                return -1;
            }

            @Override
            public int getMaxSize() {
                return -1;
            }
        });
    }

    public void addProblematic(ProblematicAttribute problematic) {
        this.problematics.add(problematic);
    }

    public final ProblematicAttribute[] getProblematics() {
        return this.problematics.isEmpty() ? EMPTY_PROBLEMATICS : this.problematics.toArray(new ProblematicAttribute[this.problematics.size()]);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String setProperty(String name, String value) {
        if (null == value) {
            return this.properties.remove(name);
        }
        return this.properties.put(name, value);
    }

    public OXException setSessionProperties(Session session) {
        this.properties.put("com.openexchange.exception.sessionId", session.getSessionID());
        this.properties.put("com.openexchange.exception.client", session.getClient());
        this.properties.put("com.openexchange.exception.authId", session.getAuthId());
        this.properties.put("com.openexchange.exception.login", session.getLogin());
        this.properties.put("com.openexchange.exception.context", String.valueOf(session.getContextId()));
        this.properties.put("com.openexchange.exception.user", String.valueOf(session.getContextId()));
        return this;
    }

    public String remove(String name) {
        return this.properties.remove(name);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    private static String dropSubsequentWhitespaces(String message) {
        if (null == message) {
            return message;
        }
        return P.matcher(message).replaceAll("$1 $2");
    }

    public static interface Parsing
    extends ProblematicAttribute {
        public String getAttribute();
    }

    public static interface Truncated
    extends ProblematicAttribute {
        public int getId();

        public int getMaxSize();

        public int getLength();
    }

    public static interface ProblematicAttribute {
    }

    private static final class ComparableCategory
    implements Comparable<ComparableCategory> {
        protected final Category category;

        protected ComparableCategory(Category category) {
            this.category = category;
        }

        @Override
        public int compareTo(ComparableCategory other) {
            return this.category.compareTo(other.category);
        }
    }

    public static enum Generic {
        NONE,
        NOT_FOUND,
        NO_PERMISSION,
        MANDATORY_FIELD,
        CONFLICT;

    }
}

