/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.classloader.osgi;

import com.openexchange.classloader.DynamicClassLoaderManager;
import com.openexchange.classloader.impl.DynamicClassLoaderManagerFactory;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class DynamicClassLoaderActivator
implements SynchronousBundleListener,
BundleActivator {
    private volatile ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private volatile ServiceRegistration<?> serviceReg;
    private volatile DynamicClassLoaderManagerFactory service;
    private volatile BundleContext bundleContext;

    public void start(BundleContext context) {
        this.bundleContext = context;
        ServiceTracker packageAdminTracker = new ServiceTracker(context, PackageAdmin.class, null);
        packageAdminTracker.open();
        this.packageAdminTracker = packageAdminTracker;
        this.registerManagerFactory();
        context.addBundleListener((BundleListener)this);
    }

    protected void registerManagerFactory() {
        DynamicClassLoaderManagerFactory service;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Dynamic Class Loader Service");
        props.put("service.vendor", "The Apache Software Foundation");
        this.service = service = new DynamicClassLoaderManagerFactory(this.bundleContext, (PackageAdmin)this.packageAdminTracker.getService());
        this.serviceReg = this.bundleContext.registerService(new String[]{DynamicClassLoaderManager.class.getName()}, (Object)service, props);
    }

    protected void unregisterManagerFactory() {
        DynamicClassLoaderManagerFactory service;
        ServiceRegistration<?> serviceReg = this.serviceReg;
        if (serviceReg != null) {
            serviceReg.unregister();
            this.serviceReg = null;
        }
        if ((service = this.service) != null) {
            this.service = null;
        }
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        this.unregisterManagerFactory();
        ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker = this.packageAdminTracker;
        if (packageAdminTracker != null) {
            packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        this.bundleContext = null;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle;
        int type = event.getType();
        boolean reload = type == 32 || type == 2 ? this.service.isBundleUsed((bundle = event.getBundle()).getBundleId()) || this.service.hasUnresolvedPackages(bundle) : (type == 64 ? this.service.isBundleUsed(event.getBundle().getBundleId()) : false);
        if (reload) {
            this.unregisterManagerFactory();
            this.registerManagerFactory();
        }
    }
}

