/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.classloader.impl;

import com.openexchange.classloader.DynamicClassLoaderManager;
import com.openexchange.classloader.DynamicClassLoaderProvider;
import com.openexchange.classloader.impl.ClassLoaderFacade;
import com.openexchange.classloader.impl.DynamicClassLoaderManagerFactory;
import com.openexchange.classloader.impl.PackageAdminClassLoader;
import java.util.Arrays;
import java.util.Comparator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class DynamicClassLoaderManagerImpl
extends ServiceTracker<DynamicClassLoaderProvider, DynamicClassLoaderProvider>
implements DynamicClassLoaderManager {
    private final PackageAdminClassLoader pckAdminCL;
    private final ClassLoaderFacade facade;
    private ClassLoader[] cache;
    private DynamicClassLoaderProvider[] providerCache;
    private volatile boolean active = true;
    private volatile int trackingCount = -1;

    public DynamicClassLoaderManagerImpl(BundleContext ctx, PackageAdmin pckAdmin, ClassLoader parent, DynamicClassLoaderManagerFactory factory) {
        super(ctx, DynamicClassLoaderProvider.class, null);
        this.pckAdminCL = new PackageAdminClassLoader(pckAdmin, parent, factory);
        this.cache = new ClassLoader[]{this.pckAdminCL};
        this.providerCache = new DynamicClassLoaderProvider[0];
        this.open();
        this.facade = new ClassLoaderFacade(this);
    }

    private synchronized void updateCache() {
        if (this.trackingCount < this.getTrackingCount()) {
            DynamicClassLoaderProvider[] providers;
            ClassLoader[] loaders;
            ServiceReference[] refs = this.getServiceReferences();
            if (refs == null || refs.length == 0) {
                loaders = new ClassLoader[]{this.pckAdminCL};
                providers = new DynamicClassLoaderProvider[]{};
            } else {
                loaders = new ClassLoader[1 + refs.length];
                providers = new DynamicClassLoaderProvider[refs.length];
                Arrays.sort(refs, ServiceReferenceComparator.INSTANCE);
                int index = 0;
                for (ServiceReference ref : refs) {
                    DynamicClassLoaderProvider provider = (DynamicClassLoaderProvider)this.getService(ref);
                    if (provider != null) {
                        loaders[index] = provider.getClassLoader(this.pckAdminCL);
                        providers[index] = provider;
                    }
                    ++index;
                }
                loaders[index] = this.pckAdminCL;
            }
            this.releaseProviders();
            this.cache = loaders;
            this.providerCache = providers;
            this.trackingCount = this.getTrackingCount();
        }
    }

    private void releaseProviders() {
        if (this.providerCache != null) {
            for (int i = 0; i < this.providerCache.length; ++i) {
                if (this.cache[i] == null) continue;
                this.providerCache[i].release(this.cache[i]);
            }
        }
    }

    public void deactivate() {
        this.releaseProviders();
        this.active = false;
        this.close();
        this.providerCache = null;
        this.cache = null;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public ClassLoader getDynamicClassLoader() {
        return this.facade;
    }

    public ClassLoader[] getDynamicClassLoaders() {
        if (this.trackingCount < this.getTrackingCount()) {
            this.updateCache();
        }
        return this.cache;
    }

    protected static final class ServiceReferenceComparator
    implements Comparator<ServiceReference> {
        public static final ServiceReferenceComparator INSTANCE = new ServiceReferenceComparator();

        protected ServiceReferenceComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o1.compareTo((Object)o2);
        }
    }
}

