/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.classloader.impl;

import com.openexchange.classloader.DynamicClassLoaderManager;
import com.openexchange.classloader.impl.BundleProxyClassLoader;
import com.openexchange.classloader.impl.DynamicClassLoaderManagerImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class DynamicClassLoaderManagerFactory
implements ServiceFactory<DynamicClassLoaderManager> {
    private static final Object PRESENT = new Object();
    private final PackageAdmin pckAdmin;
    private final BundleContext context;
    private final ConcurrentMap<Long, Object> usedBundles = new ConcurrentHashMap<Long, Object>();
    private final ConcurrentMap<String, Object> unresolvedPackages = new ConcurrentHashMap<String, Object>();

    public DynamicClassLoaderManagerFactory(BundleContext ctx, PackageAdmin pckAdmin) {
        this.context = ctx;
        this.pckAdmin = pckAdmin;
    }

    public DynamicClassLoaderManager getService(Bundle bundle, ServiceRegistration<DynamicClassLoaderManager> registration) {
        DynamicClassLoaderManagerImpl manager = new DynamicClassLoaderManagerImpl(this.context, this.pckAdmin, new BundleProxyClassLoader(bundle), this);
        return manager;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<DynamicClassLoaderManager> registration, DynamicClassLoaderManager service) {
        if (service != null) {
            ((DynamicClassLoaderManagerImpl)service).deactivate();
        }
    }

    public boolean isBundleUsed(long bundleId) {
        return this.usedBundles.containsKey(bundleId);
    }

    public void addUsedBundle(Bundle bundle) {
        long id = bundle.getBundleId();
        this.usedBundles.put(id, PRESENT);
    }

    public void addUnresolvedPackage(String pckName) {
        this.unresolvedPackages.put(pckName, PRESENT);
    }

    public boolean hasUnresolvedPackages(Bundle bundle) {
        ExportedPackage[] pcks;
        if (!this.unresolvedPackages.isEmpty() && (pcks = this.pckAdmin.getExportedPackages(bundle)) != null) {
            for (ExportedPackage pck : pcks) {
                if (!this.unresolvedPackages.containsKey(pck.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

