/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import org.json.AbstractJSONValue;
import org.json.ICharArray;

public class CharArray
implements ICharArray {
    protected final char[] chars;
    protected int pos;
    protected Integer hash;

    protected CharArray() {
        this.chars = null;
    }

    protected CharArray(int capacity) {
        this.chars = new char[capacity];
        this.pos = 0;
    }

    private CharArray(char[] chars) {
        this.chars = chars;
        this.pos = 0;
    }

    @Override
    public String toString() {
        try {
            return AbstractJSONValue.directString(0, this.pos, this.chars);
        }
        catch (Exception e) {
            return new String(this.chars, 0, this.pos);
        }
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    public int capacity() {
        return this.chars.length;
    }

    @Override
    public int remainingCapacity() {
        return this.chars.length - this.pos;
    }

    @Override
    public int length() {
        return this.pos;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.pos) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.chars[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.length()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        char[] chars = new char[end - start];
        System.arraycopy(this.chars, start, chars, 0, chars.length);
        return new CharArray(chars);
    }

    @Override
    public void copyTo(CharArray other) {
        other.reset();
        System.arraycopy(this.chars, 0, other.chars, 0, this.pos);
    }

    @Override
    public void copyFrom(CharArray other) {
        this.reset();
        int otherLen = other.pos;
        System.arraycopy(other.chars, 0, this.chars, 0, otherLen);
        this.pos += otherLen;
        this.hash = null;
    }

    public int hashCode() {
        Integer hash = this.hash;
        if (null == hash) {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.chars);
            result = 31 * result + this.pos;
            this.hash = hash = Integer.valueOf(result);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharArray)) {
            return false;
        }
        CharArray other = (CharArray)obj;
        if (this.pos != other.pos) {
            return false;
        }
        return Arrays.equals(this.chars, other.chars);
    }
}

