/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavGetAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.io.IOException;
import java.io.InputStream;

public class GetTest
extends ActionTestCase {
    private WebdavPath INDEX_HTML_URL = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
    }

    public void testBasic() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        WebdavGetAction action = new WebdavGetAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        String content = this.getContent(this.INDEX_HTML_URL);
        GetTest.assertEquals((String)this.getContent(this.INDEX_HTML_URL), (String)res.getResponseBodyAsString());
        GetTest.assertEquals((int)content.getBytes(Charsets.UTF_8).length, (int)new Integer(res.getHeader("content-length")));
        GetTest.assertEquals((String)"text/html", (String)res.getHeader("content-type"));
        GetTest.assertEquals((String)this.factory.resolveResource(this.INDEX_HTML_URL).getETag(), (String)res.getHeader("ETag"));
        GetTest.assertEquals((int)200, (int)res.getStatus());
        GetTest.assertEquals((String)"bytes", (String)res.getHeader("Accept-Ranges"));
    }

    public void testNotFound() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(new WebdavPath((CharSequence)"iDontExist"));
        WebdavGetAction action = new WebdavGetAction();
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            GetTest.fail((String)"Expected 404 not found");
        }
        catch (WebdavProtocolException x) {
            GetTest.assertEquals((int)404, (int)x.getStatus());
        }
    }

    public void testPartial() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        this.rangeTest(this.INDEX_HTML_URL, "2-5", this.getBytes(this.INDEX_HTML_URL, 2, 5));
    }

    public void testPartialWithOpenEnd() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        this.rangeTest(this.INDEX_HTML_URL, "5-", this.getBytes(this.INDEX_HTML_URL, 5, 10));
    }

    public void testPartialWithOpenBeginning() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        this.rangeTest(this.INDEX_HTML_URL, "-5", this.getBytes(this.INDEX_HTML_URL, 6, 10));
    }

    public void testPartialWithOpenBeginningTooMuch() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        this.rangeTest(this.INDEX_HTML_URL, "-23", this.getBytes(this.INDEX_HTML_URL, 0, 10));
    }

    public void testBogusRange() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        this.rangeTest(this.INDEX_HTML_URL, "5-2", new byte[0]);
    }

    public void testRangeOutsideLength() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        try {
            this.rangeTest(this.INDEX_HTML_URL, "23-25", this.getBytes(this.INDEX_HTML_URL, 0, 10));
            GetTest.fail();
        }
        catch (WebdavProtocolException x) {
            GetTest.assertEquals((int)416, (int)x.getStatus());
        }
    }

    public void testMultipleRanges() throws Exception {
        GetTest.assertEquals((Object)11L, (Object)this.factory.resolveResource(this.INDEX_HTML_URL).getLength());
        byte[] all = this.getBytes(this.INDEX_HTML_URL, 0, 10);
        byte[] expect = new byte[]{all[0], all[10]};
        this.rangeTest(this.INDEX_HTML_URL, "0-0,-1", expect);
    }

    private void rangeTest(WebdavPath url, String byteHeader, byte[] expect) throws OXException {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(url);
        req.setHeader("Bytes", byteHeader);
        WebdavGetAction action = new WebdavGetAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        GetTest.assertEquals((int)206, (int)res.getStatus());
        byte[] bytes = res.getResponseBytes();
        GetTest.assertEquals((String)(expect.length + ""), (String)res.getHeader("Content-Length"));
        GetTest.assertEquals((int)expect.length, (int)bytes.length);
        for (int i = 0; i < expect.length; ++i) {
            GetTest.assertEquals((byte)expect[i], (byte)bytes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(WebdavPath url, int start, int stop) throws OXException, IOException {
        InputStream is = null;
        try {
            is = this.factory.resolveResource(url).getBody();
            is.skip(start);
            byte[] bytes = new byte[stop - start + 1];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

