/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utilitytests;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public final class MailMessageSerializationTest
extends AbstractMailTest {
    public MailMessageSerializationTest() {
    }

    public MailMessageSerializationTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailSerialization() {
        try {
            MailMessage[] mails = MailMessageSerializationTest.getMessages(this.getTestMailDir(), -1);
            File file = new File("/tmp/dummy" + System.currentTimeMillis() + ".dat");
            if (file.createNewFile()) {
                file.deleteOnExit();
            }
            for (MailMessage mail : mails) {
                MailMessage clone;
                ObjectInputStream inputStream;
                FileInputStream in;
                ObjectOutputStream outputStream;
                FileOutputStream out;
                if (mail.getContentType().isMimeType("multipart/*")) {
                    out = new FileOutputStream(file, false);
                    outputStream = new ObjectOutputStream(out);
                    try {
                        outputStream.writeObject(mail);
                        outputStream.flush();
                    }
                    finally {
                        outputStream.close();
                        ((OutputStream)out).close();
                    }
                    int count = mail.getEnclosedCount();
                    for (int i = 0; i < count; ++i) {
                        MailPart part = mail.getEnclosedMailPart(i);
                        if (part.getContentType().isMimeType("multipart/*")) {
                            int c = part.getEnclosedCount();
                            MailMessageSerializationTest.assertTrue((String)"Count not available from multipart part", (c != -1 ? 1 : 0) != 0);
                            continue;
                        }
                        Object content = part.getContent();
                        MailMessageSerializationTest.assertTrue((String)"Content object not available from part", (content != null ? 1 : 0) != 0);
                    }
                    in = new FileInputStream(file);
                    inputStream = new ObjectInputStream(in);
                    try {
                        clone = (MailMessage)inputStream.readObject();
                    }
                    finally {
                        inputStream.close();
                        ((InputStream)in).close();
                    }
                    int cloneCount = clone.getEnclosedCount();
                    MailMessageSerializationTest.assertTrue((String)"Enclosed part count does not match", (cloneCount == count ? 1 : 0) != 0);
                    for (int i = 0; i < cloneCount; ++i) {
                        MailPart part = clone.getEnclosedMailPart(i);
                        if (part.getContentType().isMimeType("multipart/*")) {
                            int c = part.getEnclosedCount();
                            MailMessageSerializationTest.assertTrue((String)"Count not available from multipart part", (c != -1 ? 1 : 0) != 0);
                            continue;
                        }
                        Object content = part.getContent();
                        MailMessageSerializationTest.assertTrue((String)"Content object not available from part", (content != null ? 1 : 0) != 0);
                    }
                    continue;
                }
                out = new FileOutputStream(file);
                outputStream = new ObjectOutputStream(out);
                try {
                    outputStream.writeObject(mail);
                    outputStream.flush();
                }
                finally {
                    outputStream.close();
                    ((OutputStream)out).close();
                }
                Object origContent = mail.getContent();
                MailMessageSerializationTest.assertTrue((String)"Original content not available after serialization", (origContent != null ? 1 : 0) != 0);
                in = new FileInputStream(file);
                inputStream = new ObjectInputStream(in);
                try {
                    clone = (MailMessage)inputStream.readObject();
                }
                finally {
                    inputStream.close();
                    ((InputStream)in).close();
                }
                Object cloneContent = clone.getContent();
                MailMessageSerializationTest.assertTrue((String)"Cloned content not available after serialization", (cloneContent != null ? 1 : 0) != 0);
                MailMessageSerializationTest.assertTrue((String)"Original content class and cloned content class are not equal", (boolean)origContent.getClass().isInstance(cloneContent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailMessageSerializationTest.fail((String)e.getMessage());
        }
    }
}

