/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.importexport.SessionHelper;
import com.openexchange.groupware.importexport.VersitParserTest;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import com.openexchange.tools.versit.values.RecurrenceValue;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;

public class OXContainerConverterTest
extends TestCase {
    protected SessionObject session;
    protected OXContainerConverter converter;
    protected VersitParserTest parser;

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        this.session = SessionHelper.getSession();
        this.converter = new OXContainerConverter((Session)this.session);
        this.parser = new VersitParserTest();
    }

    public Task convertTask(VersitObject obj) throws ConverterException {
        return this.converter.convertTask(obj);
    }

    public Appointment convertAppointment(VersitObject obj) throws ConverterException {
        return this.converter.convertAppointment(obj);
    }

    public Contact convertContact(VersitObject obj) throws ConverterException {
        return this.converter.convertContact(obj);
    }

    public void test8411() throws ConverterException {
        Appointment app = new Appointment();
        app.setTitle("Tierlieb's birthday");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        app.setTimezone("UTC");
        cal.set(1981, 3, 1, 0, 0);
        app.setStartDate(cal.getTime());
        cal.set(1981, 3, 2, 0, 0);
        app.setEndDate(cal.getTime());
        app.setShownAs(4);
        app.setFullTime(true);
        app.setRecurrenceType(4);
        app.setDayInMonth(1);
        app.setMonth(3);
        app.setInterval(1);
        app.setCreatedBy(this.session.getUserId());
        VersitObject ical = this.converter.convertAppointment(app);
        Property prop = ical.getProperty("SUMMARY");
        OXContainerConverterTest.assertEquals((String)"Summary is correct", (Object)"Tierlieb's birthday", (Object)prop.getValue());
        prop = ical.getProperty("RRULE");
        RecurrenceValue rv = (RecurrenceValue)prop.getValue();
        OXContainerConverterTest.assertEquals((String)"Interval is correct", (int)rv.Freq, (int)6);
    }

    public void test7470() throws IOException, ConverterException {
        String ical2 = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP\n\t=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\\n\\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000\n\t010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-ALT-DESC;FMTTYPE=text/html:<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//E\n\tN\">\\n<HTML>\\n<HEAD>\\n<META NAME=\"Generator\" CONTENT=\"MS Exchange Server ve\\n\trsion 08.00.0681.000\">\\n<TITLE></TITLE>\\n</HEAD>\\n<BODY>\\n<!-- Converted f\n\trom text/rtf format -->\\n\\n<P DIR=LTR><SPAN LANG=\"de\"><FONT FACE=\"Calibri\"\n\t>Hallo Hallo</FONT></SPAN></P>\\n\\n<P DIR=LTR><SPAN LANG=\"de\"></SPAN></P>\\n\\n\t\\n</BODY>\\n</HTML>\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n";
        List<VersitObject> list = this.parser.parseICal("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:REQUEST\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP\n\t=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDESCRIPTION:Hallo Hallo\\n\\n\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nLAST-MODIFIED:20070521T150327Z\nLOCATION:Location here\nORGANIZER;CN=Tobias:mailto:tfriedrich@oxhemail.open-xchange.com\nPRIORITY:5\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E0080000000060565ABBC99BC701000000000000000\n\t010000000E4B2BA931D32B84DAFB227C9E0CA348C\nX-ALT-DESC;FMTTYPE=text/html:<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//E\n\tN\">\\n<HTML>\\n<HEAD>\\n<META NAME=\"Generator\" CONTENT=\"MS Exchange Server ve\\n\trsion 08.00.0681.000\">\\n<TITLE></TITLE>\\n</HEAD>\\n<BODY>\\n<!-- Converted f\n\trom text/rtf format -->\\n\\n<P DIR=LTR><SPAN LANG=\"de\"><FONT FACE=\"Calibri\"\n\t>Hallo Hallo</FONT></SPAN></P>\\n\\n<P DIR=LTR><SPAN LANG=\"de\"></SPAN></P>\\n\\n\t\\n</BODY>\\n</HTML>\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-DISALLOW-COUNTER:FALSE\nX-MS-OLK-ALLOWEXTERNCHECK:TRUE\nX-MS-OLK-AUTOFILLLOCATION:FALSE\nX-MS-OLK-CONFTYPE:0\nBEGIN:VALARM\nTRIGGER:PT0M\nACTION:DISPLAY\nDESCRIPTION:Reminder\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n");
        Appointment obj = this.convertAppointment(list.get(1));
        Participant[] participants = obj.getParticipants();
        OXContainerConverterTest.assertEquals((String)"One participant?", (int)participants.length, (int)1);
        OXContainerConverterTest.assertEquals((String)"User is the right one?", (String)"cbartkowiak@oxhemail.open-xchange.com", (String)participants[0].getEmailAddress());
    }

    public void testBug9771() throws IOException, ConverterException {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:Pope;John\nTEL;TYPE=home;TYPE=cell:123435235\nEND:VCARD\n";
        List<VersitObject> list = this.parser.parseVCard3(vcard);
        VersitObject obj = list.get(0);
        Contact contact = this.convertContact(obj);
        OXContainerConverterTest.assertFalse((boolean)contact.containsTelephoneHome1());
        OXContainerConverterTest.assertTrue((boolean)contact.containsCellularTelephone1());
    }
}

