/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.properties.SupportedCalendarComponentSetProperty;
import com.openexchange.groupware.container.FolderObject;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.OptionsMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class MkCalendarTest
extends CalDAVTest {
    public MkCalendarTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptions() throws Exception {
        OptionsMethod options = null;
        try {
            options = new OptionsMethod(MkCalendarTest.getBaseUri());
            MkCalendarTest.assertEquals((String)"unexpected http status", (int)200, (int)super.getWebDAVClient().executeMethod((HttpMethod)options));
            MkCalendarTest.assertResponseHeaders(new String[]{"MKCALENDAR"}, "Allow", (HttpMethod)options);
        }
        catch (Throwable throwable) {
            MkCalendarTest.release(options);
            throw throwable;
        }
        MkCalendarTest.release((HttpMethodBase)options);
    }

    public void testCreateCalendar() throws Exception {
        String uid = MkCalendarTest.randomUID();
        String name = MkCalendarTest.randomUID();
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.CALENDAR_COLOR, (Object)"#0E61B9FF"));
        setProperties.add((DavProperty)new SupportedCalendarComponentSetProperty(SupportedCalendarComponentSetProperty.Comp.VEVENT));
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.DISPLAYNAME, (Object)name));
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.CALENDAR_ORDER, (Object)35));
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.CALENDAR_TIMEZONE, (Object)"BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nEND:VCALENDAR\r\n"));
        super.mkCalendar(uid, setProperties);
        FolderObject folder = super.getCalendarFolder(name);
        MkCalendarTest.assertNotNull((String)"folder not found on server", (Object)folder);
        this.rememberForCleanUp(folder);
        MkCalendarTest.assertEquals((String)"folder name wrong", (String)name, (String)folder.getFolderName());
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.ADD_MEMBER);
        props.add(PropertyNames.ALLOWED_SHARING_MODES);
        props.add(PropertyNames.BULK_REQUESTS);
        props.add(PropertyNames.CALENDAR_COLOR);
        props.add(PropertyNames.CALENDAR_DESCRIPTION);
        props.add(PropertyNames.CALENDAR_FREE_BUSY_SET);
        props.add(PropertyNames.CALENDAR_ORDER);
        props.add(PropertyNames.CALENDAR_TIMEZONE);
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATE);
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATETIME);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.GETCTAG);
        props.add(PropertyNames.OWNER);
        props.add(PropertyNames.PRE_PUBLISH_URL);
        props.add(PropertyNames.PUBLISH_URL);
        props.add(PropertyNames.PUSH_TRANSPORTS);
        props.add(PropertyNames.PUSHKEY);
        props.add(PropertyNames.QUOTA_AVAILABLE_BYTES);
        props.add(PropertyNames.QUOTA_USED_BYTES);
        props.add(PropertyNames.REFRESHRATE);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        props.add(PropertyNames.SCHEDULE_CALENDAR_TRANSP);
        props.add(PropertyNames.SCHEDULE_DEFAULT_CALENDAR_URL);
        props.add(PropertyNames.SOURCE);
        props.add(PropertyNames.SUBSCRIBED_STRIP_ALARMS);
        props.add(PropertyNames.SUBSCRIBED_STRIP_ATTACHMENTS);
        props.add(PropertyNames.SUBSCRIBED_STRIP_TODOS);
        props.add(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET);
        props.add(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SETS);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        props.add(PropertyNames.SYNC_TOKEN);
        props.add(PropertyNames.XMPP_SERVER);
        props.add(PropertyNames.XMPP_URI);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = super.getWebDAVClient().doPropFind(propFind);
        MkCalendarTest.assertNotNull((String)"got no response", (Object)responses);
        MkCalendarTest.assertTrue((String)"got no response", (0 < responses.length ? 1 : 0) != 0);
        MultiStatusResponse folderResponse = null;
        for (MultiStatusResponse response : responses) {
            if (!response.getPropertyNames(200).contains(PropertyNames.DISPLAYNAME) || !name.equals(super.extractTextContent(PropertyNames.DISPLAYNAME, response))) continue;
            folderResponse = response;
            break;
        }
        MkCalendarTest.assertNotNull((String)"no response for new folder", folderResponse);
    }
}

