/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.resource.actions.AbstractResourceRequest;
import com.openexchange.ajax.resource.actions.ResourceSearchResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceSearchRequest
extends AbstractResourceRequest<ResourceSearchResponse> {
    private boolean failOnError;
    private String searchPattern;

    public ResourceSearchRequest(String pattern, boolean failOnError) {
        this.setSearchPattern(pattern);
        this.setFailOnError(failOnError);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("pattern", (Object)this.getSearchPattern());
        return jo;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String pattern) {
        this.searchPattern = pattern;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new Params("action", "search").toArray();
    }

    @Override
    public AbstractAJAXParser<? extends ResourceSearchResponse> getParser() {
        return new AbstractAJAXParser<ResourceSearchResponse>(this.failOnError){

            @Override
            protected ResourceSearchResponse createResponse(Response response) {
                return new ResourceSearchResponse(response);
            }
        };
    }
}

