/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ManagedSearchTests
extends AbstractManagedContactTest {
    public List<String> sinographs = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");

    public ManagedSearchTests(String name) {
        super(name);
    }

    public void testGuiLikeSearch() {
        LinkedList<ContactSearchObject> searches = new LinkedList<ContactSearchObject>();
        for (String name : this.sinographs) {
            Contact tmp = this.generateContact();
            tmp.setSurName(name);
            this.manager.newAction(tmp);
            ContactSearchObject search = new ContactSearchObject();
            search.setFolder(this.folderID);
            search.setGivenName(name);
            search.setSurname(name);
            search.setDisplayName(name);
            search.setEmail1(name);
            search.setEmail2(name);
            search.setEmail3(name);
            search.setCatgories(name);
            search.setYomiFirstname(name);
            search.setYomiLastName(name);
            search.setOrSearch(true);
            searches.add(search);
        }
        for (int i = 0; i < this.sinographs.size(); ++i) {
            Contact[] results = this.manager.searchAction((ContactSearchObject)searches.get(i));
            ManagedSearchTests.assertEquals((String)("#" + i + " Should find one contact"), (int)1, (int)results.length);
            ManagedSearchTests.assertEquals((String)("#" + i + " Should find the right contact"), (String)this.sinographs.get(i), (String)results[0].getSurName());
        }
    }

    public void testSearchPattern() {
        for (String name : this.sinographs) {
            Contact tmp = this.generateContact();
            tmp.setSurName(name);
            this.manager.newAction(tmp);
        }
        Contact[] contacts = this.manager.searchAction("*", this.folderID, ContactField.SUR_NAME.getNumber(), Order.ASCENDING, "gb2312", Contact.ALL_COLUMNS);
        for (int i = 0; i < this.sinographs.size(); ++i) {
            String name = contacts[i].getSurName();
            ManagedSearchTests.assertEquals((String)("#" + i + " Should have the right order"), (String)this.sinographs.get(i), (String)name);
        }
    }
}

