/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;

public class Bug15937Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Contact contact;

    public Bug15937Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.contact = new Contact();
        this.contact.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        this.contact.setDisplayName("Test for bug 15937");
        this.contact.setNumberOfAttachments(42);
        InsertRequest request = new InsertRequest(this.contact);
        InsertResponse response = this.client.execute(request);
        response.fillObject((DataObject)this.contact);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contact));
        super.tearDown();
    }

    public void testNumberOfAttachments() throws Throwable {
        GetRequest request = new GetRequest(this.contact, this.client.getValues().getTimeZone());
        GetResponse response = this.client.execute(request);
        Contact testContact = response.getContact();
        Bug15937Test.assertTrue((String)"Number of attachments should be send.", (boolean)testContact.containsNumberOfAttachments());
        Bug15937Test.assertEquals((String)"Number of attachments must be zero.", (int)0, (int)testContact.getNumberOfAttachments());
    }
}

