/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.attach.actions.ListRequest;
import com.openexchange.ajax.attach.actions.ListResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.java.util.TimeZones;
import java.io.ByteArrayInputStream;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug24876Test {
    private AJAXClient client;
    private Contact contact;
    private TimeZone tz;
    private long timestamp;
    private int attachmentId;

    @Before
    public void setUp() throws Exception {
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.tz = this.client.getValues().getTimeZone();
        int folderId = this.client.getValues().getPrivateContactFolder();
        this.contact = new Contact();
        this.contact.setDisplayName("Test for bug 24876");
        this.contact.setParentFolderID(folderId);
        this.client.execute(new InsertRequest(this.contact)).fillObject((DataObject)this.contact);
        this.attachmentId = this.client.execute(new AttachRequest((CommonObject)this.contact, "test.txt", new ByteArrayInputStream("Test".getBytes()), "text/plain")).getId();
        this.contact = this.client.execute(new GetRequest(this.contact, this.tz)).getContact();
        this.timestamp = this.contact.getLastModifiedOfNewestAttachment().getTime();
    }

    @After
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contact));
        this.client.logout();
    }

    @Test
    public void testList() throws Exception {
        ListResponse response = this.client.execute(new ListRequest((CommonObject)this.contact, new int[]{this.attachmentId}, new int[]{4}, TimeZones.UTC));
        Assert.assertEquals((String)"attachment listing did not return the only created attachment", (int)1, (int)response.getArray().length);
        long toTest = 0L;
        for (Object[] values : response) {
            toTest = (Long)values[response.getColumnPos(4)];
        }
        Assert.assertEquals((String)"time stamp for attachments is wrong in list request", (long)this.timestamp, (long)toTest);
    }

    public void testMultipleList() throws Exception {
        ListResponse response = (ListResponse)((MultipleResponse)this.client.execute(MultipleRequest.create(new ListRequest((CommonObject)this.contact, new int[]{this.attachmentId}, new int[]{4}, TimeZones.UTC)))).getResponse(0);
        Assert.assertEquals((String)"attachment listing did not return the only created attachment", (int)1, (int)response.getArray().length);
        long toTest = 0L;
        for (Object[] values : response) {
            toTest = (Long)values[response.getColumnPos(4)];
        }
        Assert.assertEquals((String)"time stamp for attachments is wrong in list request", (long)this.timestamp, (long)toTest);
    }
}

