/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;

public class Bug17535Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment updateAppointment;

    public Bug17535Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("19.01.2010 00:00"));
        this.appointment.setEndDate(TimeTools.D("20.01.2010 00:00"));
        this.appointment.setFullTime(true);
        this.appointment.setRecurrenceType(4);
        this.appointment.setDayInMonth(19);
        this.appointment.setMonth(0);
        this.appointment.setInterval(1);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("Bug 17599 Test");
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(insertRequest);
        insertResponse.fillAppointment(this.appointment);
        this.updateAppointment = new Appointment();
        this.updateAppointment.setObjectID(this.appointment.getObjectID());
        this.updateAppointment.setStartDate(TimeTools.D("19.01.2010 00:00"));
        this.updateAppointment.setFullTime(true);
        this.updateAppointment.setRecurrenceType(4);
        this.updateAppointment.setDayInMonth(19);
        this.updateAppointment.setMonth(0);
        this.updateAppointment.setInterval(1);
        this.updateAppointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.updateAppointment.setIgnoreConflicts(true);
        this.updateAppointment.setTitle("Bug 17599 Test");
        this.updateAppointment.setLabel(3);
        this.updateAppointment.setCategories("Burtstage");
        this.updateAppointment.setShownAs(4);
        this.updateAppointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    public void testBug17599() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.updateAppointment, this.getClient().getValues().getTimeZone());
        UpdateResponse updateResponse = this.getClient().execute(updateRequest);
        updateResponse.fillObject((DataObject)this.appointment);
        GetRequest getRequest = new GetRequest(this.appointment);
        GetResponse getResponse = this.getClient().execute(getRequest);
        Appointment loadedAppointment = getResponse.getAppointment(this.getClient().getValues().getTimeZone());
        Bug17535Test.assertEquals((String)"Wrong recurrence type", (int)4, (int)loadedAppointment.getRecurrenceType());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }
}

