/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Bug13501Test
extends AbstractAJAXSession {
    private TimeZone tz;
    private Appointment appointment;
    private Appointment update;
    private int[] columns;
    private Date startSearch;
    private Date endSearch;

    public Bug13501Test(String name) {
        super(name);
    }

    public void testBug13501() throws Exception {
        InsertRequest request = new InsertRequest(this.appointment, this.tz);
        CommonInsertResponse response = this.client.execute(request);
        this.appointment.setObjectID(response.getId());
        this.appointment.setLastModified(response.getTimestamp());
        this.update.setObjectID(response.getId());
        this.update.setLastModified(response.getTimestamp());
        UpdateRequest updateRequest = new UpdateRequest(this.update, this.client.getValues().getTimeZone());
        UpdateResponse updateResponse = this.client.execute(updateRequest);
        this.appointment.setLastModified(updateResponse.getTimestamp());
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), this.columns, this.startSearch, this.endSearch, TimeZone.getTimeZone("UTC"), false);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        Object[][] objects = allResponse.getArray();
        int count = 0;
        for (Object[] object : objects) {
            if (((Integer)object[0]).intValue() != this.appointment.getObjectID()) continue;
            ++count;
        }
        Bug13501Test.assertEquals((String)"Wrong number of occurrences in this view.", (int)3, (int)count);
        GetRequest getRequest = new GetRequest(this.client.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID());
        GetResponse getResponse = this.client.execute(getRequest);
        Appointment sequenceApp = getResponse.getAppointment(this.client.getValues().getTimeZone());
        Bug13501Test.assertEquals((String)"Wrong occurrences value", (int)5, (int)sequenceApp.getOccurrence());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tz = this.getClient().getValues().getTimeZone();
        Calendar start = Calendar.getInstance();
        start.set(5, 15);
        start.set(2, 5);
        start.set(1, 2009);
        start.set(11, 8);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(start.getTimeInMillis() + 3600000L);
        this.appointment = new Appointment();
        this.appointment.setTitle("bug 13501 test");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setStartDate(start.getTime());
        this.appointment.setEndDate(end.getTime());
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        Calendar until = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        until.set(1, 2009);
        until.set(11, 0);
        until.set(12, 0);
        until.set(13, 0);
        until.set(14, 0);
        until.set(5, 13);
        until.set(2, 6);
        until.set(1, 2009);
        this.update = new Appointment();
        this.update.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.update.setRecurrenceType(2);
        this.update.setDays(2);
        this.update.setOccurrence(5);
        this.update.setInterval(1);
        this.columns = new int[]{1, 222, 201, 202};
        this.startSearch = new Date(1246233600000L);
        this.endSearch = new Date(1249257600000L);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.appointment.getObjectID() > 0) {
            this.client.execute(new DeleteRequest(this.appointment.getObjectID(), this.client.getValues().getPrivateAppointmentFolder(), this.appointment.getLastModified()));
        }
        super.tearDown();
    }
}

